"use strict";const perf=require("./vs/base/common/performance");perf.mark("code/didStartMain");const path=require("path"),fs=require("fs"),os=require("os"),bootstrap=require("./bootstrap"),bootstrapNode=require("./bootstrap-node"),{getUserDataPath}=require("./vs/platform/environment/node/userDataPath"),product=require("../product.json"),{app,protocol,crashReporter}=require("electron");app.allowRendererProcessReuse=!1;const portable=bootstrapNode.configurePortable(product);bootstrap.enableASARSupport(void 0,!1);const args=parseCLIArgs(),userDataPath=getUserDataPath(args);app.setPath("userData",userDataPath);const codeCachePath=getCodeCachePath(),argvConfig=configureCommandlineSwitchesSync(args);perf.mark("code/willStartCrashReporter"),configureCrashReporter(),perf.mark("code/didStartCrashReporter"),portable&&portable.isPortable&&app.setAppLogsPath(path.join(userDataPath,"logs")),protocol.registerSchemesAsPrivileged([{scheme:"vscode-webview",privileges:{standard:!0,secure:!0,supportFetchAPI:!0,corsEnabled:!0,allowServiceWorkers:!0}},{scheme:"vscode-file",privileges:{secure:!0,standard:!0,supportFetchAPI:!0,corsEnabled:!0}}]),registerListeners();let nlsConfigurationPromise;const metaDataFile=path.join(__dirname,"nls.metadata.json"),locale=getUserDefinedLocale(argvConfig);if(locale){const{getNLSConfiguration:e}=require("./vs/base/node/languagePacks");nlsConfigurationPromise=e(product.commit,userDataPath,metaDataFile,locale)}app.once("ready",function(){if(args.trace){const e=require("electron").contentTracing,r={categoryFilter:args["trace-category-filter"]||"*",traceOptions:args["trace-options"]||"record-until-full,enable-sampling"};e.startRecording(r).finally(()=>onReady())}else onReady()});function startup(e,r){r._languagePackSupport=!0,process.env.VSCODE_NLS_CONFIG=JSON.stringify(r),process.env.VSCODE_CODE_CACHE_PATH=e||"",perf.mark("code/willLoadMainBundle"),require("./bootstrap-amd").load("vs/code/electron-main/main",()=>{perf.mark("code/didLoadMainBundle")})}async function onReady(){perf.mark("code/mainAppReady");try{const[,e]=await Promise.all([mkdirpIgnoreError(codeCachePath),resolveNlsConfiguration()]);startup(codeCachePath,e)}catch(e){console.error(e)}}function configureCommandlineSwitchesSync(e){const r=["disable-hardware-acceleration","disable-color-correct-rendering","force-color-profile"];process.platform==="linux"&&r.push("force-renderer-accessibility");const n=["enable-proposed-api","enable-browser-code-loading","log-level"],s=readArgvConfigSync();let o=typeof codeCachePath=="string"?"bypassHeatCheck":"none";Object.keys(s).forEach(a=>{const t=s[a];if(r.indexOf(a)!==-1)a==="force-color-profile"?t&&app.commandLine.appendSwitch(a,t):(t===!0||t==="true")&&(a==="disable-hardware-acceleration"?app.disableHardwareAcceleration():app.commandLine.appendSwitch(a));else if(n.indexOf(a)!==-1)switch(a){case"enable-proposed-api":Array.isArray(t)?t.forEach(i=>i&&typeof i=="string"&&process.argv.push("--enable-proposed-api",i)):console.error("Unexpected value for `enable-proposed-api` in argv.json. Expected array of extension ids.");break;case"enable-browser-code-loading":t===!1?o=void 0:typeof t=="string"&&(o=t);break;case"log-level":typeof t=="string"&&process.argv.push("--log",t);break}});const c=getJSFlags(e);return c&&app.commandLine.appendSwitch("js-flags",c),(e.__sandbox||o)&&(process.env.VSCODE_BROWSER_CODE_LOADING=o||"bypassHeatCheck"),s}function readArgvConfigSync(){const e=getArgvConfigPath();let r;try{r=JSON.parse(stripComments(fs.readFileSync(e).toString()))}catch(n){n&&n.code==="ENOENT"?createDefaultArgvConfigSync(e):console.warn(`Unable to read argv.json configuration file in ${e}, falling back to defaults (${n})`)}return r||(r={"disable-color-correct-rendering":!0}),r}function createDefaultArgvConfigSync(e){try{const r=path.dirname(e);fs.existsSync(r)||fs.mkdirSync(r);const n=["// This configuration file allows you to pass permanent command line arguments to VS Code.","// Only a subset of arguments is currently supported to reduce the likelihood of breaking","// the installation.","//","// PLEASE DO NOT CHANGE WITHOUT UNDERSTANDING THE IMPACT","//","// NOTE: Changing this file requires a restart of VS Code.","{","	// Use software rendering instead of hardware accelerated rendering.","	// This can help in cases where you see rendering issues in VS Code.",'	// "disable-hardware-acceleration": true,',"","	// Enabled by default by VS Code to resolve color issues in the renderer","	// See https://github.com/microsoft/vscode/issues/51791 for details",'	"disable-color-correct-rendering": true',"}"];fs.writeFileSync(e,n.join(`
`))}catch(r){console.error(`Unable to create argv.json configuration file in ${e}, falling back to defaults (${r})`)}}function getArgvConfigPath(){const e=process.env.VSCODE_PORTABLE;if(e)return path.join(e,"argv.json");let r=product.dataFolderName;return process.env.VSCODE_DEV&&(r=`${r}-dev`),path.join(os.homedir(),r,"argv.json")}function configureCrashReporter(){let e=args["crash-reporter-directory"],r="";if(e){if(e=path.normalize(e),path.isAbsolute(e)||(console.error(`The path '${e}' specified for --crash-reporter-directory must be absolute.`),app.exit(1)),!fs.existsSync(e))try{fs.mkdirSync(e)}catch(o){console.error(`The path '${e}' specified for --crash-reporter-directory does not seem to exist or cannot be created.`),app.exit(1)}console.log(`Found --crash-reporter-directory argument. Setting crashDumps directory to be '${e}'`),app.setPath("crashDumps",e)}else{const o=product.appCenter;if(o&&argvConfig["enable-crash-reporter"]&&!args["disable-crash-reporter"]){const c=process.platform==="win32",a=process.platform==="linux",t=process.platform==="darwin",i=argvConfig["crash-reporter-id"];if(/^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/i.test(i)){if(c)switch(process.arch){case"ia32":r=o["win32-ia32"];break;case"x64":r=o["win32-x64"];break;case"arm64":r=o["win32-arm64"];break}else if(t)if(product.darwinUniversalAssetId)r=o["darwin-universal"];else switch(process.arch){case"x64":r=o.darwin;break;case"arm64":r=o["darwin-arm64"];break}else a&&(r=o["linux-x64"]);r=r.concat("&uid=",i,"&iid=",i,"&sid=",i);const l=process.argv,d=l.indexOf("--");d===-1?l.push("--crash-reporter-id",i):l.splice(d,0,"--crash-reporter-id",i)}}}const n=(product.crashReporter?product.crashReporter.productName:void 0)||product.nameShort,s=(product.crashReporter?product.crashReporter.companyName:void 0)||"Microsoft";crashReporter.start({companyName:s,productName:process.env.VSCODE_DEV?`${n} Dev`:n,submitURL:r,uploadToServer:!e,compress:!0})}function getJSFlags(e){const r=[];return e["js-flags"]&&r.push(e["js-flags"]),e["max-memory"]&&!/max_old_space_size=(\d+)/g.exec(e["js-flags"])&&r.push(`--max_old_space_size=${e["max-memory"]}`),r.length>0?r.join(" "):null}function parseCLIArgs(){return require("minimist")(process.argv,{string:["user-data-dir","locale","js-flags","max-memory","crash-reporter-directory"]})}function registerListeners(){const e=[];global.macOpenFiles=e,app.on("open-file",function(s,o){e.push(o)});const r=[],n=function(s,o){s.preventDefault(),r.push(o)};app.on("will-finish-launching",function(){app.on("open-url",n)}),global.getOpenUrls=function(){return app.removeListener("open-url",n),r}}function getCodeCachePath(){if(process.argv.indexOf("--no-cached-data")>0||process.env.VSCODE_DEV)return;const e=product.commit;if(!!e)return path.join(userDataPath,"CachedData",e)}function mkdirp(e){const r=require("fs");return new Promise((n,s)=>{r.mkdir(e,{recursive:!0},o=>o&&o.code!=="EEXIST"?s(o):n(e))})}async function mkdirpIgnoreError(e){if(typeof e=="string")try{return await mkdirp(e),e}catch(r){}}async function resolveNlsConfiguration(){let e=nlsConfigurationPromise?await nlsConfigurationPromise:void 0;if(!e){let r=app.getLocale();if(!r)e={locale:"en",availableLanguages:{}};else{r=r.toLowerCase();const{getNLSConfiguration:n}=require("./vs/base/node/languagePacks");e=await n(product.commit,userDataPath,metaDataFile,r),e||(e={locale:r,availableLanguages:{}})}}return e}function stripComments(e){const r=/("(?:[^\\"]*(?:\\.)?)*")|('(?:[^\\']*(?:\\.)?)*')|(\/\*(?:\r?\n|.)*?\*\/)|(\/{2,}.*?(?:(?:\r?\n)|$))/g;return e.replace(r,function(n,s,o,c,a){if(c)return"";if(a){const t=a.length;return t>2&&a[t-1]===`
`?a[t-2]==="\r"?`\r
`:`
`:""}else return n})}function getUserDefinedLocale(e){const r=args.locale;return r?r.toLowerCase():e.locale&&typeof e.locale=="string"?e.locale.toLowerCase():void 0}

//# sourceMappingURL=https://ticino.blob.core.windows.net/sourcemaps/9ae988fce0738e895e7dc27c21062ee95ce4e77b/core/main.js.map
