declare namespace mtl {

            const nfc: nfc;
            const contacts: contacts;
            const ai: ai;
            const ymPrinter: ymPrinter;
            const im: im;
            const mobile: mobile;
            const wifi: wifi;
            const vui: vui;
            const apkCheck: apkCheck;
            const push: push;
            const pay: pay;
            const calendar: calendar;
            const ble: ble;
            const aliPush: aliPush;

    interface commonFun {
        /** 调用成功 */
        success():void;
        /** 调用失败 */
        fail():void;
    }

            /**
 * `新建日程`
 */ 
            function createNewSchedule(option: commonFun):void;
            interface mtl_viewScheduleList_Params extends commonFun{
            
                        /**指定日期时间戳（10位）'*/
                        time: number,
                        /**人员id'*/
                        memberId: string
            }  
           /**
 * `展示指定日期的日程列表`
 * ========params==========
 *
 * `time` :number : (可选项) 
 *
 * `memberId` :string : (可选项) 
 *
 */
            function viewScheduleList(option: mtl_viewScheduleList_Params):void;
            interface mtl_viewScheduleDetail_Params extends commonFun{
            
                        /**日程id'*/
                        scheduleId: string,
                        /**日程子Id(只有重复日程存在子Id)'*/
                        subId: string,
                        /**用户ID'*/
                        memberId: string
            }  
           /**
 * `展示出指定日程的详细信息`
 * ========params==========
 *
 * `scheduleId` :string : (可选项) 
 *
 * `subId` :string : (可选项) 
 *
 * `memberId` :string : (可选项) 
 *
 */
            function viewScheduleDetail(option: mtl_viewScheduleDetail_Params):void;
            interface mtl_openScheduleDetail_Params extends commonFun{
            
                        /**日程id'*/
                        scheduleId: string,
                        /**日程当前时间(20201112)'*/
                        currentDay: string,
                        /**用户id(从哪个进入的，从共享人进行，就是共享人的id)'*/
                        memberId: string
            }  
           /**
 * `打开日程查看详情界面`
 * ========params==========
 *
 * `scheduleId` :string : (可选项) 
 *
 * `currentDay` :string : (可选项) 
 *
 * `memberId` :string : (可选项) 
 *
 */
            function openScheduleDetail(option: mtl_openScheduleDetail_Params):void;
            interface mtl_startMirrorScreen_Params extends commonFun{
            
                        /**投屏码'*/
                        code: string
            }  
           /**
 * `开启投屏功能`
 * ========params==========
 *
 * `code` :string : (可选项) 
 *
 */
            function startMirrorScreen(option: mtl_startMirrorScreen_Params):void;
            /**
 * `关闭投屏功能`
 */ 
            function closeMirrorScreen(option: commonFun):void;
            /**
 * `检测投屏状态`
 */ 
            function checkMirrorStatus(option: commonFun):void;
            interface mtl_openLibraryFiles_Params extends commonFun{
            
                        /**一级目录(企业文档：1；内部群文档：2；我的文档：3；项目文档：4)'*/
                        firstCatalog: number,
                        /**二级目录(企业文档：0；我的文档：0；我的文档(TA人共享)：-4；内部群文档：内部群ID；项目文档：项目ID；)'*/
                        secondCatalog: number,
                        /**三级目录(文件夹id)'*/
                        thirdCatalog: number
            }  
           /**
 * `打开文库具体路径`
 * ========params==========
 *
 * `firstCatalog` :number : (可选项) 
 *
 * `secondCatalog` :number : (可选项) 
 *
 * `thirdCatalog` :number : (可选项) 
 *
 */
            function openLibraryFiles(option: mtl_openLibraryFiles_Params):void;
            interface mtl_chooseLibraryFiles_Params extends commonFun{
            
                        /**文库选择类型(0:从文库列表和传输列表选择 1:从文库列表选择 2:从传输列表选择)'*/
                        type: number
            }  
           /**
 * `文库列表中选择文库文件`
 * ========params==========
 *
 * `type` :number : (可选项) 
 *
 */
            function chooseLibraryFiles(option: mtl_chooseLibraryFiles_Params):void;
            interface mtl_wpsPreview_Params extends commonFun{
            
                        /**文件地址，使用 url 方式时必传'*/
                        fileUrl: string,
                        /**文件 id，使用文件 fid 方式时必传'*/
                        fileId: string,
                        /**文件名称'*/
                        fileName: string,
                        /**文件扩展名'*/
                        fileExt: string,
                        /**文件来源，具体应用调用需要传入自己的 appId 才生效'*/
                        appId: string
            }  
           /**
 * `wps 文件预览`
 * ========params==========
 *
 * `fileUrl` :string : (可选项) 
 *
 * `fileId` :string : (可选项) 
 *
 * `fileName` :string : (可选项) 
 *
 * `fileExt` :string : (可选项) 
 *
 * `appId` :string : (可选项) 
 *
 */
            function wpsPreview(option: mtl_wpsPreview_Params):void;
            interface mtl_previewFile_Params extends commonFun{
            
                        /**文件ID或下载url（下载url预览from_type传入5）'*/
                        fid: string,
                        /**0来自文库，1IM，2web，3项目，4旧IM，5下载地址预览,6公告附件，7.新NC预览,8任务预览,9金格编辑'*/
                        from_type: number,
                        /**1.企业文档，2.团队文档，3.我的文档，4.项目文档'*/
                        file_type: number,
                        /**文件名（fid为下载url的预览,即from_type=5的时候，文件名必须传且必须带后缀名）'*/
                        filename: string,
                        /**是否需要下载按钮（0不需要，1需要，对from_type = 5有效）'*/
                        need_download: number
            }  
           /**
 * `预览文件`
 * ========params==========
 *
 * `fid` :string : (可选项) 
 *
 * `from_type` :number : (可选项) 
 *
 * `file_type` :number : (可选项) 
 *
 * `filename` :string : (可选项) 
 *
 * `need_download` :number : (可选项) 
 *
 */
            function previewFile(option: mtl_previewFile_Params):void;
            interface mtl_chooseFileFromLibrary_Params extends commonFun{
            
                        /**选择类型，0 从文库列表和传输列表选择，1 从文库列表选择，2 从传输列表选择'*/
                        type: number
            }  
           /**
 * `选择文件`
 * ========params==========
 *
 * `type` :number : (可选项) 
 *
 */
            function chooseFileFromLibrary(option: mtl_chooseFileFromLibrary_Params):void;
            interface mtl_writeAnnounceReply_Params extends commonFun{
            
                        /**发言Id'*/
                        feedId: string,
                        /**回复数量'*/
                        replyNum: string
            }  
           /**
 * `公告写评论`
 * ========params==========
 *
 * `feedId` :string : (可选项) 
 *
 * `replyNum` :string : (可选项) 
 *
 */
            function writeAnnounceReply(option: mtl_writeAnnounceReply_Params):void;
            interface mtl_openAnnounceReply_Params extends commonFun{
            
                        /**发言Id'*/
                        feedId: string,
                        /**回复数量'*/
                        replyNum: string
            }  
           /**
 * `打开公告评论列表`
 * ========params==========
 *
 * `feedId` :string : (可选项) 
 *
 * `replyNum` :string : (可选项) 
 *
 */
            function openAnnounceReply(option: mtl_openAnnounceReply_Params):void;
            interface mtl_announceDetail_Params extends commonFun{
            
                        /**公告id'*/
                        announce_id: number,
                        /**空间id'*/
                        qz_id: number
            }  
           /**
 * `公告详情`
 * ========params==========
 *
 * `announce_id` :number : (可选项) 
 *
 * `qz_id` :number : (可选项) 
 *
 */
            function announceDetail(option: mtl_announceDetail_Params):void;
            interface mtl_viewUserInfo_Params extends commonFun{
            
                        /**人员id'*/
                        memberId: number
            }  
           /**
 * `打开人员详情界面`
 * ========params==========
 *
 * `memberId` :number : (可选项) 
 *
 */
            function viewUserInfo(option: mtl_viewUserInfo_Params):void;
            /**
 * `打开原生创建页面`
 */ 
            function openCreateSpace(option: commonFun):void;
            interface mtl_convertMemberIDs_Params extends commonFun{
            
                        /**转换类型(0:空间ID换友互通ID 1:友互通ID换空间ID)'*/
                        type: string,
                        /**需要转换的数组'*/
                        idArray: Array,
                        /**内部群类型(0:已加入的内部群 1:所有内部群 2:未加入的内部群)'*/
                        groupType: number
            }  
           /**
 * `空间member_id和友户通user_id相互转换`
 * ========params==========
 *
 * `type` :string : (可选项) 
 *
 * `idArray` :arrayobject : (可选项) 
 *
 * `groupType` :number : (可选项) 
 *
 */
            function convertMemberIDs(option: mtl_convertMemberIDs_Params):void;
            interface mtl_chooseUserOrGroupFromChat_Params extends commonFun{
            
                        /**导航标题(ios有这个参数Android没有)'*/
                        navTitle: string,
                        /**内部群类型(0:已加入的内部群 1:所有内部群 2:未加入的内部群)'*/
                        groupType: number
            }  
           /**
 * `获取用户或群组ID`
 * ========params==========
 *
 * `navTitle` :string : (可选项) 
 *
 * `groupType` :number : (可选项) 
 *
 */
            function chooseUserOrGroupFromChat(option: mtl_chooseUserOrGroupFromChat_Params):void;
            interface mtl_chooseInsideGroup_Params extends commonFun{
            
                        /**是否多选'*/
                        multiple: boolean,
                        /**已选内部群数组'*/
                        selectedList: Array,
                        /**内部群类型(0:已加入的内部群 1:所有内部群 2:未加入的内部群)'*/
                        groupType: number
            }  
           /**
 * `选择内部群，返回内部群信息`
 * ========params==========
 *
 * `multiple` :boolean : (可选项) 
 *
 * `selectedList` :arrayobject : (可选项) 
 *
 * `groupType` :number : (可选项) 
 *
 */
            function chooseInsideGroup(option: mtl_chooseInsideGroup_Params):void;
            interface mtl_chooseDepartment_Params extends commonFun{
            
                        /**是否多选'*/
                        multiple: boolean,
                        /**已选部门数组'*/
                        selectedList: Array,
                        /**最大选择组织数'*/
                        maxCount: number,
                        /**已选择组织数'*/
                        selectedCount: number,
                        /**部门类型(0:所有 1:部门 2:组织)'*/
                        deptType: number
            }  
           /**
 * `选择部门，返回部门基础信息`
 * ========params==========
 *
 * `multiple` :boolean : (可选项) 
 *
 * `selectedList` :arrayobject : (可选项) 
 *
 * `maxCount` :number : (可选项) 
 *
 * `selectedCount` :number : (可选项) 
 *
 * `deptType` :number : (可选项) 
 *
 */
            function chooseDepartment(option: mtl_chooseDepartment_Params):void;
            interface mtl_chooseContacts_Params extends commonFun{
            
                        /**是否多选'*/
                        multiple: boolean,
                        /**已选用户数组'*/
                        selectedList: any,
                        /**最大选择人数'*/
                        maxCount: number,
                        /**导航标题'*/
                        navTitle: string,
                        /**导航颜色值'*/
                        navColor: string,
                        /**需要选择的空间id'*/
                        qzId: string,
                        /**是否可以删除已选人员(IOS 已弃用)'*/
                        canDelete: boolean,
                        /**是否可以点部门选择（仅多选时有效）(true:可通过部门选择 false:不可以通过部门选择)'*/
                        canSelectDept: boolean,
                        /**是否需要友户通ID(1:需要友户通ID 0:不需要友户通ID)'*/
                        needYhtUserId: number
            }  
           /**
 * `选择联系人，返回联系人基础信息`
 * ========params==========
 *
 * `multiple` :boolean : (可选项) 
 *
 * `selectedList` :arraystring : (可选项) 
 *
 * `maxCount` :number : (可选项) 
 *
 * `navTitle` :string : (可选项) 
 *
 * `navColor` :string : (可选项) 
 *
 * `qzId` :string : (可选项) 
 *
 * `canDelete` :boolean : (可选项) 
 *
 * `canSelectDept` :boolean : (可选项) 
 *
 * `needYhtUserId` :number : (可选项) 
 *
 */
            function chooseContacts(option: mtl_chooseContacts_Params):void;
            interface mtl_chooseAllContacts_Params extends commonFun{
            
                        /**是否多选'*/
                        multiple: boolean,
                        /**已选人员ID数组'*/
                        selectedList: any,
                        /**导航标题'*/
                        navTitle: string
            }  
           /**
 * `跨空间选择联系人，返回联系人基础信息`
 * ========params==========
 *
 * `multiple` :boolean : (可选项) 
 *
 * `selectedList` :arraystring : (可选项) 
 *
 * `navTitle` :string : (可选项) 
 *
 */
            function chooseAllContacts(option: mtl_chooseAllContacts_Params):void;
            interface mtl_commonReplyComponent_Params extends commonFun{
            
                        /**被回复对象的名字'*/
                        replyName: string,
                        /**限定人员范围'*/
                        memberArray: Array,
                        /**空间 id'*/
                        qzId: string
            }  
           /**
 * `评论组件`
 * ========params==========
 *
 * `replyName` :string : (可选项) 
 *
 * `memberArray` :objectarray : (可选项) 
 *
 * `qzId` :string : (可选项) 
 *
 */
            function commonReplyComponent(option: mtl_commonReplyComponent_Params):void;
            /**
 * `人脸`
 */ 
            function 提供检测目标微笑值的功能(option: commonFun):void;
            interface mtl_smileDetect_Params extends commonFun{
            
                        /**空间id'*/
                        spaceId: string
            }  
           /**
 * `提供检测目标微笑值的功能`
 * ========params==========
 *
 * `spaceId` :string : (可选项) 
 *
 */
            function smileDetect(option: mtl_smileDetect_Params):void;
            interface mtl_faceVerify_Params extends commonFun{
            
                        /**空间id'*/
                        spaceId: string,
                        /**存放人脸信息的库id'*/
                        faceGroupId: string,
                        /**是否需要返回微笑分数'*/
                        needSmile: boolean
            }  
           /**
 * `人脸信息识别`
 * ========params==========
 *
 * `spaceId` :string : (可选项) 
 *
 * `faceGroupId` :string : (可选项) 
 *
 * `needSmile` :boolean : (可选项) 
 *
 */
            function faceVerify(option: mtl_faceVerify_Params):void;
            interface mtl_faceCompare_Params extends commonFun{
            
                        /**空间id'*/
                        spaceId: string,
                        /**存放人脸信息的库id'*/
                        faceGroupId: string,
                        /**是否需要返回微笑分数'*/
                        needSmile: boolean
            }  
           /**
 * `人脸信息比对`
 * ========params==========
 *
 * `spaceId` :string : (可选项) 
 *
 * `faceGroupId` :string : (可选项) 
 *
 * `needSmile` :boolean : (可选项) 
 *
 */
            function faceCompare(option: mtl_faceCompare_Params):void;
            interface mtl_faceRegister_Params extends commonFun{
            
                        /**空间id'*/
                        spaceId: string,
                        /**存放人脸信息的库id'*/
                        faceGroupId: string
            }  
           /**
 * `注册人脸信息`
 * ========params==========
 *
 * `spaceId` :string : (可选项) 
 *
 * `faceGroupId` :string : (可选项) 
 *
 */
            function faceRegister(option: mtl_faceRegister_Params):void;
            interface mtl_operateCloudAlarm_Params extends commonFun{
            
                        /**人员id'*/
                        member_id: string,
                        /**空间id'*/
                        qz_id: number,
                        /**开关，1开启，0关闭 (开闹钟必须传)'*/
                        operate_type: number,
                        /**事件id'*/
                        id: string,
                        /**提醒时间（10位）(开闹钟必须传)'*/
                        remind_time: string,
                        /**事件名称 (开闹钟必须传)'*/
                        title: string,
                        /**事件名称 事件开始时间（10位）'*/
                        start_time: string,
                        /**事件结束时间（10位）'*/
                        end_time: string,
                        /**事件来源（0考勤，1日程，2会议）(开闹钟必须传)'*/
                        from: number,
                        /**提醒模式（0只提醒一次，暂时不需要）'*/
                        remind_mode: number
            }  
           /**
 * `开关云闹铃`
 * ========params==========
 *
 * `member_id` :string : (可选项) 
 *
 * `qz_id` :number : (可选项) 
 *
 * `operate_type` :number : (可选项) 
 *
 * `id` :string : (可选项) 
 *
 * `remind_time` :string : (可选项) 
 *
 * `title` :string : (可选项) 
 *
 * `start_time` :string : (可选项) 
 *
 * `end_time` :string : (可选项) 
 *
 * `from` :number : (可选项) 
 *
 * `remind_mode` :number : (可选项) 
 *
 */
            function operateCloudAlarm(option: mtl_operateCloudAlarm_Params):void;
            interface mtl_checkCloudAlarm_Params extends commonFun{
            
                        /**事件id'*/
                        id: string
            }  
           /**
 * `查询云闹钟开关状态`
 * ========params==========
 *
 * `id` :string : (可选项) 
 *
 */
            function checkCloudAlarm(option: mtl_checkCloudAlarm_Params):void;
            interface mtl_getWatermarkInfo_Params extends commonFun{
            
                        /**圈子ID'*/
                        qzId: string
            }  
           /**
 * `获取空间水印信息`
 * ========params==========
 *
 * `qzId` :string : (可选项) 
 *
 */
            function getWatermarkInfo(option: mtl_getWatermarkInfo_Params):void;
            interface mtl_verifyLoginPassword_Params extends commonFun{
            
                        /**弹窗标题，若不传，显示默认的文案：为了确保数据安全，需要验证您的登录密码'*/
                        title: string
            }  
           /**
 * `弹出密码验证对话框，验证用户身份`
 * ========params==========
 *
 * `title` :string : (可选项) 
 *
 */
            function verifyLoginPassword(option: mtl_verifyLoginPassword_Params):void;
            interface mtl_createFeedComponent_Params extends commonFun{
            
                        /**开放权限(是否能看到这条发言)的团队id'*/
                        groupId: string,
                        /**开放权限的团队id的名字'*/
                        groupName: string
            }  
           /**
 * `新建发言`
 * ========params==========
 *
 * `groupId` :string : (可选项) 
 *
 * `groupName` :string : (可选项) 
 *
 */
            function createFeedComponent(option: mtl_createFeedComponent_Params):void;
            interface mtl_sendMiniMail_Params extends commonFun{
            
                        /**收件人列表'*/
                        users: Array,
                        /**空间id'*/
                        spaceId: string
            }  
           /**
 * `打开发送微邮界面`
 * ========params==========
 *
 * `users` :arrayobject : (可选项) 
 *
 * `spaceId` :string : (可选项) 
 *
 */
            function sendMiniMail(option: mtl_sendMiniMail_Params):void;
            interface mtl_sendImageMessages_Params extends commonFun{
            
                        /**对方用户id的使用类型，0-使用友空间用户id；1-使用友互通用户id'*/
                        userType: number,
                        /**对方的唯一标示'*/
                        chatId: string,
                        /**对方的类型(chat: 单聊 groupchat: 群聊)'*/
                        chatType: string,
                        /**发送图片的本地地址集合'*/
                        filePaths: Array
            }  
           /**
 * `发送图片消息`
 * ========params==========
 *
 * `userType` :number : (可选项) 
 *
 * `chatId` :string : (可选项) 
 *
 * `chatType` :string : (可选项) 
 *
 * `filePaths` :Arraystring : (可选项) 
 *
 */
            function sendImageMessages(option: mtl_sendImageMessages_Params):void;
            interface mtl_openChatWindow_Params extends commonFun{
            
                        /**对方用户id的使用类型，0-使用友空间用户id；1-使用友互通用户id'*/
                        userType: number,
                        /**对方用户的唯一标示'*/
                        userId: string
            }  
           /**
 * `打开聊天页面`
 * ========params==========
 *
 * `userType` :number : (可选项) 
 *
 * `userId` :string : (可选项) 
 *
 */
            function openChatWindow(option: mtl_openChatWindow_Params):void;
            interface mtl_getOAuthCode_Params extends commonFun{
            
                        /**租户ID'*/
                        tenantId: string
            }  
           /**
 * `获取免登授权码，实现单点登录`
 * ========params==========
 *
 * `tenantId` :string : (可选项) 
 *
 */
            function getOAuthCode(option: mtl_getOAuthCode_Params):void;
            interface mtl_openPluginWithParams_Params extends commonFun{
            
                        /**插件id'*/
                        plugin_id: string
            }  
           /**
 * `打开插件`
 * ========params==========
 *
 * `plugin_id` :string : (可选项) 
 *
 */
            function openPluginWithParams(option: mtl_openPluginWithParams_Params):void;
            interface mtl_openAppWithParams_Params extends commonFun{
            
                        /**应用id'*/
                        app_id: string,
                        /**应用唯一标识'*/
                        serviceCode: string,
                        /**透传给目标应用的参数，json串。通过getAppletShareParams方法获取透传参数'*/
                        expandParams: string
            }  
           /**
 * `启动应用`
 * ========params==========
 *
 * `app_id` :string : (可选项) 
 *
 * `serviceCode` :string : (可选项) 
 *
 * `expandParams` :string : (可选项) 
 *
 */
            function openAppWithParams(option: mtl_openAppWithParams_Params):void;
            /**
 * `获取透传参数`
 */ 
            function getAppletShareParams(option: commonFun):void;
            interface mtl_getOffLineOutSignPhoto_Params extends commonFun{
            
                        /**租户ID，可跨租户上传(友空间6.5.0及以上版本)'*/
                        tenantId: string,
                        /**1签到'*/
                        watermark_type: number,
                         /**水印数据对象与type匹配'*/
                        watermark: Object
            }  
           /**
 * `拍照上传服务器或者返回base64信息`
 * ========params==========
 *
 * `tenantId` :string : (可选项) 
 *
 * `watermark_type` :number : (可选项) 
 *
 * `watermark` :object : (可选项) 
 *
 */
            function getOffLineOutSignPhoto(option: mtl_getOffLineOutSignPhoto_Params):void;
            /**
 * `获取红火台缓存信息`
 */ 
            function getHhtQrCodeInfo(option: commonFun):void;
            interface mtl_getAppData_Params extends commonFun{
            
                        /**appid'*/
                        appId: string
            }  
           /**
 * `查询单个应用信息`
 * ========params==========
 *
 * `appId` :string : (可选项) 
 *
 */
            function getAppData(option: mtl_getAppData_Params):void;
            interface mtl_configAppletMenu_Params extends commonFun{
            
                        /**隐藏分享按钮'*/
                        hideShare: number,
                        /**隐藏转发按钮'*/
                        hideForward: number
            }  
           /**
 * `配置小程序的菜单`
 * ========params==========
 *
 * `hideShare` :number : (可选项) 
 *
 * `hideForward` :number : (可选项) 
 *
 */
            function configAppletMenu(option: mtl_configAppletMenu_Params):void;
            interface mtl_appletFromQzId_Params extends commonFun{
            
                        /**fromQzId'*/
                        fromQzId: string
            }  
           /**
 * `获取小程序来源圈子ID`
 * ========params==========
 *
 * `fromQzId` :string : (可选项) 
 *
 */
            function appletFromQzId(option: mtl_appletFromQzId_Params):void;
            interface mtl_setExclusiveLanguage_Params extends commonFun{
            
                        /**多语言类别： 0:跟随系统， 1:英文， 2:简体， 3:繁体'*/
                        language: number
            }  
           /**
 * `设置语言`
 * ========params==========
 *
 * `language` :int : (可选项) 
 *
 */
            function setExclusiveLanguage(option: mtl_setExclusiveLanguage_Params):void;
            /**
 * `获取应用加载本地H5路径`
 */ 
            function getExclusiveAppH5LocationPath(option: commonFun):void;
            /**
 * `获取认证code---调用接口`
 */ 
            function getExclusiveCode(option: commonFun):void;
            interface mtl_saveExclusiveYhtInfo_Params extends commonFun{
            
                        /**当前用户友互通长token'*/
                        yht_access_token: any,
                        /**单点认证凭证'*/
                        wb_at: any
            }  
           /**
 * `保存友互通信息---保存到请求头`
 * ========params==========
 *
 * `yht_access_token` :sting : (可选项) 
 *
 * `wb_at` :sting : (可选项) 
 *
 */
            function saveExclusiveYhtInfo(option: mtl_saveExclusiveYhtInfo_Params):void;
            interface mtl_saveExclusiveUserInfo_Params extends commonFun{
            
                        /**用户唯一标识符'*/
                        userId: any,
                        /**用户当前租户id'*/
                        tenantId: any
            }  
           /**
 * `保存用户基本信息---保存到本地`
 * ========params==========
 *
 * `userId` :sting : (可选项) 
 *
 * `tenantId` :sting : (可选项) 
 *
 */
            function saveExclusiveUserInfo(option: mtl_saveExclusiveUserInfo_Params):void;
            interface mtl_saveExclusiveDomain_Params extends commonFun{
            
                        /**接口请求域名'*/
                        domain: any
            }  
           /**
 * `保存接口域名信息---保存到本地`
 * ========params==========
 *
 * `domain` :sting : (可选项) 
 *
 */
            function saveExclusiveDomain(option: mtl_saveExclusiveDomain_Params):void;
            interface mtl_isExclusivePreloadMDF_Params extends commonFun{
            
                        /**是否预加载mdf应用'*/
                        isPreload: any,
                        /**mdf应用预加载的URL'*/
                        mdfUrl: any
            }  
           /**
 * `当前空间是否预加载MDF应用`
 * ========params==========
 *
 * `isPreload` :sting : (可选项) 
 *
 * `mdfUrl` :sting : (可选项) 
 *
 */
            function isExclusivePreloadMDF(option: mtl_isExclusivePreloadMDF_Params):void;
            /**
 * `获取个人友互通信息`
 */ 
            function getUserYHTInfo(option: commonFun):void;
            /**
 * `获取个人信息`
 */ 
            function gainUserInfo(option: commonFun):void;
            /**
 * `获取轻应用code`
 */ 
            function getToken(option: commonFun):void;
            interface mtl_blueToothConnect_Params extends commonFun{
            
                        /**需要连接的设备标识'*/
                        deviceIndentify: string,
                        /**需要连接的蓝牙设备名字'*/
                        deviceName: string
            }  
           /**
 * `连接蓝牙打印机`
 * ========params==========
 *
 * `deviceIndentify` :string : (可选项) 
 *
 * `deviceName` :string : (可选项) 
 *
 */
            function blueToothConnect(option: mtl_blueToothConnect_Params):void;
            /**
 * `获得当前蓝牙连接状态`
 */ 
            function blueToothConnectState(option: commonFun):void;
            /**
 * `断开当前连接的蓝牙打印机`
 */ 
            function blueToothDisConnect(option: commonFun):void;
            interface mtl_blueToothPrint_Params extends commonFun{
            
                        /**打印的页数'*/
                        printNum: number,
                        /**打印的内容列表'*/
                        content: Array
            }  
           /**
 * `打印当前连接的蓝牙打印机`
 * ========params==========
 *
 * `printNum` :number : (可选项) 
 *
 * `content` :objectarray : (可选项) 
 *
 */
            function blueToothPrint(option: mtl_blueToothPrint_Params):void;
            interface mtl_blueToothScan_Params extends commonFun{
            
                        /**持续获取蓝牙扫描信息的回调函数'*/
                        registerFunc():void 
            }  
           /**
 * `获得当前蓝牙连接状态`
 * ========params==========
 *
 * `registerFunc` :function : (可选项) 
 *
 */
            function blueToothScan(option: mtl_blueToothScan_Params):void;
            /**
 * `停止扫描蓝牙打印机`
 */ 
            function blueToothStopScan(option: commonFun):void;
            /**
 * `获取蓝牙打开状态`
 */ 
            function getBlueToothState(option: commonFun):void;
            interface mtl_scanInvoice_Params extends commonFun{
            
                        /**apiLink申请的 appcode'*/
                        appCode: string
            }  
           /**
 * `发票`
 * ========params==========
 *
 * `appCode` :string : (可选项) 
 *
 */
            function scanInvoice(option: mtl_scanInvoice_Params):void;
            interface mtl_recognizeInvoice_Params extends commonFun{
            
                        /**apiLink申请的 appcode'*/
                        appCode: string,
                        /**图片，支持 localId/base64'*/
                        image: string
            }  
           /**
 * `图片`
 * ========params==========
 *
 * `appCode` :string : (可选项) 
 *
 * `image` :string : (可选项) 
 *
 */
            function recognizeInvoice(option: mtl_recognizeInvoice_Params):void;
            interface mtl_scanIDCard_Params extends commonFun{
            
                        /**apiLink申请的 appcode'*/
                        appCode: string,
                        /**身份证正反面；face/back'*/
                        side: string
            }  
           /**
 * `身份证`
 * ========params==========
 *
 * `appCode` :string : (可选项) 
 *
 * `side` :string : (可选项) 
 *
 */
            function scanIDCard(option: mtl_scanIDCard_Params):void;
            interface mtl_recognizeIDCard_Params extends commonFun{
            
                        /**apiLink申请的 appcode'*/
                        appCode: string,
                        /**身份证正反面；face/back'*/
                        side: string,
                        /**图片，支持 localId/base64'*/
                        image: string
            }  
           /**
 * `身份证图片`
 * ========params==========
 *
 * `appCode` :string : (可选项) 
 *
 * `side` :string : (可选项) 
 *
 * `image` :string : (可选项) 
 *
 */
            function recognizeIDCard(option: mtl_recognizeIDCard_Params):void;
            interface mtl_scanBankCard_Params extends commonFun{
            
                        /**apiLink申请的 appcode'*/
                        appCode: string
            }  
           /**
 * `银行卡`
 * ========params==========
 *
 * `appCode` :string : (可选项) 
 *
 */
            function scanBankCard(option: mtl_scanBankCard_Params):void;
            interface mtl_recognizeBankCard_Params extends commonFun{
            
                        /**apiLink申请的 appcode'*/
                        appCode: string,
                        /**图片，支持 localId/base64'*/
                        image: string
            }  
           /**
 * `银行卡照片`
 * ========params==========
 *
 * `appCode` :string : (可选项) 
 *
 * `image` :string : (可选项) 
 *
 */
            function recognizeBankCard(option: mtl_recognizeBankCard_Params):void;
            /**
 * `获取状态栏高度`
 */ 
            function getStatusBarHeight(option: commonFun):void;
            interface mtl_setStatusBar_Params extends commonFun{
            
                        /**“1”：通栏  “0” :不通栏'*/
                        isScreenEdge: string,
                        /**“1”：默认样式  “0” :高亮'*/
                        isStatusBarDefault: string
            }  
           /**
 * `状态栏配置`
 * ========params==========
 *
 * `isScreenEdge` :string : (可选项) 
 *
 * `isStatusBarDefault` :string : (可选项) 
 *
 */
            function setStatusBar(option: mtl_setStatusBar_Params):void;
            interface mtl_switchLongPress_Params extends commonFun{
            
                        /**0-禁用长按事件  1-启用长按事件'*/
                        enabled: number
            }  
           /**
 * `长按手势`
 * ========params==========
 *
 * `enabled` :int : (可选项) 
 *
 */
            function switchLongPress(option: mtl_switchLongPress_Params):void;
            interface mtl_setCookie_Params extends commonFun{
            
                        /**需要注入cookie的地址'*/
                        url: any,
                        /**cookie数据'*/
                        cookie: any
            }  
           /**
 * `设置cookie`
 * ========params==========
 *
 * `url` :stirng : (可选项) 
 *
 * `cookie` :stirng : (可选项) 
 *
 */
            function setCookie(option: mtl_setCookie_Params):void;
            interface mtl_requestPermission_Params extends commonFun{
            
                        /**需要申请权限数组'*/
                        list: Array
            }  
           /**
 * `申请隐私权限`
 * ========params==========
 *
 * `list` :array : (可选项) 
 *
 */
            function requestPermission(option: mtl_requestPermission_Params):void;
            interface mtl_execPluginBridge_Params extends commonFun{
            
                        /**方法名称'*/
                        method: any,
                        /**需要加载模块名称'*/
                        requireName: any,
                        /**调用方法需要额外参数'*/
                        xxx: any
            }  
           /**
 * `调用mtl未封装api`
 * ========params==========
 *
 * `method` :stirng : (可选项) 
 *
 * `requireName` :stirng : (可选项) 
 *
 * `xxx` : : (可选项) 
 *
 */
            function execPluginBridge(option: mtl_execPluginBridge_Params):void;
            interface mtl_execPluginSyncBridge_Params extends commonFun{
            
                        /**方法名称'*/
                        method: any,
                        /**需要加载模块名称'*/
                        requireName: any,
                        /**调用方法需要额外参数'*/
                        xxx: any
            }  
           /**
 * `调用mtl未封装同步api`
 * ========params==========
 *
 * `method` :stirng : (可选项) 
 *
 * `requireName` :stirng : (可选项) 
 *
 * `xxx` : : (可选项) 
 *
 */
            function execPluginSyncBridge(option: mtl_execPluginSyncBridge_Params):void;
            interface mtl_showCityPicker_Params extends commonFun{
            
                        /**默认选择省份（严格按照国家命名传入）'*/
                        province: string
            }  
           /**
 * `城市选择`
 * ========params==========
 *
 * `province` :string : (可选项) 
 *
 */
            function showCityPicker(option: mtl_showCityPicker_Params):void;
            interface mtl_showDateTimePicker_Params extends commonFun{
            
                        /**返回的日期格式 1. yyyy-MM-dd 2. HH:mm 3. yyyy-MM-dd HH:mm 4.yyyy-MM 5.yyyy'*/
                        format: string,
                        /**控件默认选择的日期时间(格式yyyy-MM-dd)'*/
                        currentDate: string
            }  
           /**
 * `日期选择`
 * ========params==========
 *
 * `format` :string : (可选项) 
 *
 * `currentDate` :string : (可选项) 
 *
 */
            function showDateTimePicker(option: mtl_showDateTimePicker_Params):void;
            interface mtl_chooseImage_Params extends commonFun{
            
                        /**最多可以选择的图片张数'*/
                        count: number,
                        /**选择图片的来源'*/
                        sourceType: any,
                         /**照片添加水印，只有拍照功能下生效'*/
                        watermark: Object,
                        /**是否需要返回缩略图'*/
                        returnThumbnail: boolean
            }  
           /**
 * `调用相机/相册`
 * ========params==========
 *
 * `count` :number : (可选项) 
 *
 * `sourceType` :StringArray : (可选项) 
 *
 * `watermark` :object : (可选项) 
 *
 * `returnThumbnail` :boolean : (可选项) 
 *
 */
            function chooseImage(option: mtl_chooseImage_Params):void;
            interface mtl_chooseImageToServer_Params extends commonFun{
            
                        /**最多可以选择的图片张数'*/
                        count: number,
                        /**选择图片的来源'*/
                        sourceType: any,
                         /**照片添加水印，只有拍照功能下生效(wx不支持)'*/
                        watermark: Object
            }  
           /**
 * `选取图片并上传友空间服务器`
 * ========params==========
 *
 * `count` :number : (可选项) 
 *
 * `sourceType` :StringArray : (可选项) 
 *
 * `watermark` :object : (可选项) 
 *
 */
            function chooseImageToServer(option: mtl_chooseImageToServer_Params):void;
            /**
 * `预览图片`
 */ 
            function previewImage(option: commonFun):void;
            interface mtl_saveImageToPhotoAlbum_Params extends commonFun{
            
                        /**图片的文件服务器地址'*/
                        url: string
            }  
           /**
 * `保存图片到相册`
 * ========params==========
 *
 * `url` :string : (可选项) 
 *
 */
            function saveImageToPhotoAlbum(option: mtl_saveImageToPhotoAlbum_Params):void;
            interface mtl_getLocalImgData_Params extends commonFun{
            
                        /**图片的localID'*/
                        localId: string
            }  
           /**
 * `获取本地图片的base64编码`
 * ========params==========
 *
 * `localId` :string : (可选项) 
 *
 */
            function getLocalImgData(option: mtl_getLocalImgData_Params):void;
            interface mtl_saveImageToLocal_Params extends commonFun{
            
                        /**图片的文件服务器地址'*/
                        url: string
            }  
           /**
 * `保存图片到本地`
 * ========params==========
 *
 * `url` :string : (可选项) 
 *
 */
            function saveImageToLocal(option: mtl_saveImageToLocal_Params):void;
            interface mtl_loadImageFromLocal_Params extends commonFun{
            
                        /**图片的文件服务器地址'*/
                        url: string
            }  
           /**
 * `读取本地图片`
 * ========params==========
 *
 * `url` :string : (可选项) 
 *
 */
            function loadImageFromLocal(option: mtl_loadImageFromLocal_Params):void;
            interface mtl_chooseVideo_Params extends commonFun{
            
                        /**选择视频来源，默认二者都有。['album', 'camera']'*/
                        sourceType: Array,
                        /**最长视频时间。最长60秒，默认15秒'*/
                        maxDuration: number
            }  
           /**
 * `选取视频`
 * ========params==========
 *
 * `sourceType` :array : (可选项) 
 *
 * `maxDuration` :number : (可选项) 
 *
 */
            function chooseVideo(option: mtl_chooseVideo_Params):void;
            interface mtl_chooseVideoToServer_Params extends commonFun{
            
                        /**选择视频来源，默认二者都有。['album', 'camera']'*/
                        sourceType: Array,
                        /**最长视频时间。最长60秒，默认15秒'*/
                        maxDuration: number
            }  
           /**
 * `选取视频并上传友空间服务器`
 * ========params==========
 *
 * `sourceType` :array : (可选项) 
 *
 * `maxDuration` :number : (可选项) 
 *
 */
            function chooseVideoToServer(option: mtl_chooseVideoToServer_Params):void;
            /**
 * `音频-开始录音`
 */ 
            function startRecord(option: commonFun):void;
            /**
 * `音频-结束录音`
 */ 
            function stopRecord(option: commonFun):void;
            /**
 * `监听录音自动停止`
 */ 
            function onVoiceRecordEnd(option: commonFun):void;
            interface mtl_playVoice_Params extends commonFun{
            
                        /**需要播放的音频的本地ID，由 stopRecord 接口获得'*/
                        localId: string,
                        /**露营线上路径(mtl 6.1.4支持)。 wx不支持'*/
                        url: string
            }  
           /**
 * `音频-播放录音`
 * ========params==========
 *
 * `localId` :string : (可选项) 
 *
 * `url` :string : (可选项) 
 *
 */
            function playVoice(option: mtl_playVoice_Params):void;
            interface mtl_pauseVoice_Params extends commonFun{
            
                        /**需要暂停的音频的本地ID，由 stopRecord 接口获得'*/
                        localId: string
            }  
           /**
 * `音频-暂停播放录音`
 * ========params==========
 *
 * `localId` :string : (可选项) 
 *
 */
            function pauseVoice(option: mtl_pauseVoice_Params):void;
            interface mtl_stopVoice_Params extends commonFun{
            
                        /**需要停止的音频的本地ID，由 stopRecord 接口获得'*/
                        localId: string
            }  
           /**
 * `音频-结束播放`
 * ========params==========
 *
 * `localId` :string : (可选项) 
 *
 */
            function stopVoice(option: mtl_stopVoice_Params):void;
            /**
 * `监听录音播放完毕`
 */ 
            function onVoicePlayEnd(option: commonFun):void;
            /**
 * `录音（含UI）`
 */ 
            function showRecordAudio(option: commonFun):void;
            interface mtl_addImageWaterMark_Params extends commonFun{
            
                        /**图片路径'*/
                        image: string,
                         /**照片添加水印'*/
                        watermark: Object
            }  
           /**
 * `给图片添加水印`
 * ========params==========
 *
 * `image` :string : (可选项) 
 *
 * `watermark` :object : (可选项) 
 *
 */
            function addImageWaterMark(option: mtl_addImageWaterMark_Params):void;
            interface mtl_compressLocalImage_Params extends commonFun{
            
                        /**图片数据类型（0 或 1）0: 图片 base64 数据； 1: 图片路径'*/
                        type: number,
                        /**压缩的级别，支持 0 ~ 3 的整数0:不压缩；1: 低质量； 2:中质量； 3:高质量'*/
                        level: number,
                        /**图片地址或 base64 数据'*/
                        imgData: string
            }  
           /**
 * `图片压缩`
 * ========params==========
 *
 * `type` :number : (可选项) 
 *
 * `level` :number : (可选项) 
 *
 * `imgData` :string : (可选项) 
 *
 */
            function compressLocalImage(option: mtl_compressLocalImage_Params):void;
            interface mtl_continuousShooting_Params extends commonFun{
            
                        /**最多可以连拍的图片张数，最多支持 9'*/
                        count: number
            }  
           /**
 * `连拍多张照片并上传`
 * ========params==========
 *
 * `count` :number : (可选项) 
 *
 */
            function continuousShooting(option: mtl_continuousShooting_Params):void;
            interface mtl_deleteBase64Image_Params extends commonFun{
            
                        /**图片的名称'*/
                        name: string
            }  
           /**
 * `删除本地的 base64 图片`
 * ========params==========
 *
 * `name` :string : (可选项) 
 *
 */
            function deleteBase64Image(option: mtl_deleteBase64Image_Params):void;
            interface mtl_getBase64Image_Params extends commonFun{
            
                        /**图片的名称'*/
                        name: string
            }  
           /**
 * `获取本地的 base64 字符串数据`
 * ========params==========
 *
 * `name` :string : (可选项) 
 *
 */
            function getBase64Image(option: mtl_getBase64Image_Params):void;
            interface mtl_saveBase64Image_Params extends commonFun{
            
                        /**图片的名称'*/
                        name: string,
                        /**图片的 base64 数据'*/
                        base64str: string
            }  
           /**
 * `将图片的 base64 字符串以图片形式存储到本地`
 * ========params==========
 *
 * `name` :string : (可选项) 
 *
 * `base64str` :string : (可选项) 
 *
 */
            function saveBase64Image(option: mtl_saveBase64Image_Params):void;
            interface mtl_getVideoThumbnail_Params extends commonFun{
            
                        /**本地视频的地址'*/
                        videoPath: string,
                        /**缩略图质量（0-100）'*/
                        thumbnailQuality: number
            }  
           /**
 * `获取视频缩略图，返回缩略图的 base64 编码数据`
 * ========params==========
 *
 * `videoPath` :string : (可选项) 
 *
 * `thumbnailQuality` :number : (可选项) 
 *
 */
            function getVideoThumbnail(option: mtl_getVideoThumbnail_Params):void;
            interface mtl_scanQRCode_Params extends commonFun{
            
                        /**可以指定扫二维码还是条形码，可选值为 qrCode 和 barCode，默认二维码['qrCode']。'*/
                        scanType: string,
                        /**默认为0，扫描结果由端上处理，1则直接返回扫描结果。'*/
                        needResult: number
            }  
           /**
 * `二维码扫码`
 * ========params==========
 *
 * `scanType` :string : (可选项) 
 *
 * `needResult` :number : (可选项) 
 *
 */
            function scanQRCode(option: mtl_scanQRCode_Params):void;
            interface mtl_generateQRCode_Params extends commonFun{
            
                        /**用于生成二维码的字符串'*/
                        str: string,
                        /**生成图片大小，默认 100 * 100'*/
                        size: string
            }  
           /**
 * `生成二维码`
 * ========params==========
 *
 * `str` :string : (可选项) 
 *
 * `size` :string : (可选项) 
 *
 */
            function generateQRCode(option: mtl_generateQRCode_Params):void;
            interface mtl_customScanQRCode_Params extends commonFun{
            
                        /**扫描方式0: 单次，扫描出结果后自动关闭页面1: 连续，扫描出结果后不自动关闭页面'*/
                        type: number,
                        /**扫码页面内部扫描结果浏览器的网址'*/
                        url: string,
                        /**扫描完成后的回调方法名 [注册方式](#nuq8e)'*/
                        callback: string,
                        /**1: 自定义导航 0: 默认导航'*/
                        customNavi: number,
                        /**导航栏左边的菜单项 (点击默认关闭页面)'*/
                        leftItems: Array,
                        /**导航栏右边的菜单项'*/
                        rightItems: Array,
                        /**导航栏中间的菜单项'*/
                        centerItems: Array
            }  
           /**
 * `自定义扫描`
 * ========params==========
 *
 * `type` :number : (可选项) 
 *
 * `url` :string : (可选项) 
 *
 * `callback` :string : (可选项) 
 *
 * `customNavi` :number : (可选项) 
 *
 * `leftItems` :arrayobject : (可选项) 
 *
 * `rightItems` :arrayobject : (可选项) 
 *
 * `centerItems` :arrayobject : (可选项) 
 *
 */
            function customScanQRCode(option: mtl_customScanQRCode_Params):void;
            interface mtl_suspendScanQRCode_Params extends commonFun{
            
                        /**扫描方式0: 单次，扫描出结果后自动关闭页面1: 连续，扫描出结果后不自动关闭页面'*/
                        type: number,
                        /**是否隐藏悬浮扫描框 0:显示 1:隐藏'*/
                        hide: number,
                        /**扫描结果的回调方法'*/
                        callback():void ,
                        /**扫描框左边与屏幕左边的间距占屏幕宽度的比例，范围[0,1]'*/
                        scanLeftRatio: number,
                        /**扫描框顶部与屏幕顶部的间距占屏幕高度的比例，范围[0,1]'*/
                        scanTopRatio: number,
                        /**扫描框宽度占屏幕宽度的比例，范围(0, 1]'*/
                        scanWidthRatio: number,
                        /**扫描框高度占屏幕高度的比例，范围[0, 1]'*/
                        scanHeightRatio: number
            }  
           /**
 * `mdf悬浮扫描`
 * ========params==========
 *
 * `type` :number : (可选项) 
 *
 * `hide` :number : (可选项) 
 *
 * `callback` :function : (可选项) 
 *
 * `scanLeftRatio` :number : (可选项) 
 *
 * `scanTopRatio` :number : (可选项) 
 *
 * `scanWidthRatio` :number : (可选项) 
 *
 * `scanHeightRatio` :number : (可选项) 
 *
 */
            function suspendScanQRCode(option: mtl_suspendScanQRCode_Params):void;
            interface mtl_setStorage_Params extends commonFun{
            
                        /**缺省时使用默认的域'*/
                        domain: string,
                        /**存储数据用的 key'*/
                        key: string,
                        /**存储的数据，支持 number、string、及能够通过 JSON.stringify 序列化的对象。'*/
                        data: any
            }  
           /**
 * `存储数据`
 * ========params==========
 *
 * `domain` :string : (可选项) 
 *
 * `key` :string : (可选项) 
 *
 * `data` :any : (可选项) 
 *
 */
            function setStorage(option: mtl_setStorage_Params):void;
            interface mtl_getStorage_Params extends commonFun{
            
                        /**缺省时使用默认的域'*/
                        domain: string,
                        /**存储数据用的 key'*/
                        key: string
            }  
           /**
 * `获取数据`
 * ========params==========
 *
 * `domain` :string : (可选项) 
 *
 * `key` :string : (可选项) 
 *
 */
            function getStorage(option: mtl_getStorage_Params):void;
            interface mtl_getStorageSync_Params extends commonFun{
            
                        /**缺省时使用默认的域'*/
                        domain: string,
                        /**存储数据用的 key'*/
                        key: string
            }  
           /**
 * `同步获取数据`
 * ========params==========
 *
 * `domain` :string : (可选项) 
 *
 * `key` :string : (可选项) 
 *
 */
            function getStorageSync(option: mtl_getStorageSync_Params):void;
            interface mtl_removeStorage_Params extends commonFun{
            
                        /**缺省时使用默认的域'*/
                        domain: string,
                        /**存储数据用的 key'*/
                        key: string
            }  
           /**
 * `移除数据`
 * ========params==========
 *
 * `domain` :string : (可选项) 
 *
 * `key` :string : (可选项) 
 *
 */
            function removeStorage(option: mtl_removeStorage_Params):void;
            interface mtl_clearStorage_Params extends commonFun{
            
                        /**缺省时使用默认的域'*/
                        domain: string
            }  
           /**
 * `清除所有数据`
 * ========params==========
 *
 * `domain` :string : (可选项) 
 *
 */
            function clearStorage(option: mtl_clearStorage_Params):void;
            interface mtl_executeDBOperate_Params extends commonFun{
            
                        /**执行SQL类型0:建表；1:删表；2:新增数据；3:删除数据；4:更新数据；5:查询数据'*/
                        executeType: string,
                        /**执行SQL语句业务方控制该sql安全性，创建表格要求表名字前缀为NCC_'*/
                        executeSql: string
            }  
           /**
 * `DB数据库操作`
 * ========params==========
 *
 * `executeType` :string : (可选项) 
 *
 * `executeSql` :string : (可选项) 
 *
 */
            function executeDBOperate(option: mtl_executeDBOperate_Params):void;
            interface mtl_encryptData_Params extends commonFun{
            
                        /**需要加密的数据'*/
                        data: string
            }  
           /**
 * `信息加密`
 * ========params==========
 *
 * `data` :string : (可选项) 
 *
 */
            function encryptData(option: mtl_encryptData_Params):void;
            interface mtl_decryptData_Params extends commonFun{
            
                        /**需要解密的数据'*/
                        data: string
            }  
           /**
 * `信息解密`
 * ========params==========
 *
 * `data` :string : (可选项) 
 *
 */
            function decryptData(option: mtl_decryptData_Params):void;
            interface mtl_openLocalFile_Params extends commonFun{
            
                        /**文件的本地地址（通过下载文件获取的本地路径）'*/
                        filePath: string,
                        /**文件格式jpeg,txt,pdf等'*/
                        fileType: string
            }  
           /**
 * `打开本地文件`
 * ========params==========
 *
 * `filePath` :string : (可选项) 
 *
 * `fileType` :string : (可选项) 
 *
 */
            function openLocalFile(option: mtl_openLocalFile_Params):void;
            interface mtl_chooseLocalFiles_Params extends commonFun{
            
                        /**可以选择文件的最大数量默认是5，不能超过5或者小于等于0，这种情况默认是5个**h5不支持**'*/
                        maxNumber: number
            }  
           /**
 * `选择本地文件`
 * ========params==========
 *
 * `maxNumber` :number : (可选项) 
 *
 */
            function chooseLocalFiles(option: mtl_chooseLocalFiles_Params):void;
            /**
 * `选取本地文件并上传友空间服务器`
 */ 
            function chooseLocalFileToServer(option: commonFun):void;
            /**
 * `文件预览`
 */ 
            function previewDoc(option: commonFun):void;
            /**
 * `浏览器当前网页是否可返回上一级`
 */ 
            function canWebviewBack(option: commonFun):void;
            /**
 * `浏览器当前网页返回上一级`
 */ 
            function webviewBack(option: commonFun):void;
            interface mtl_setNavBar_Params extends commonFun{
            
                        /**是否隐藏导航栏，1隐藏 0 不隐藏，【iOS需要注意修改的是全局导航，遵循谁修改谁负责还原】'*/
                        hide: number,
                        /**导航条背景色'*/
                        backgroundColor: string,
                        /**导航栏上按钮、标题等的颜色统一设置'*/
                        tintColor: string,
                        /**是否调整webview内边距(仅iOS)'*/
                        fullScreen: number,
                        /**是否显示导航栏底部线(仅iOS)'*/
                        hideShadowImage: number,
                        /**状态栏样式(仅iOS)'*/
                        statusBarStyle: number,
                        /**导航栏左边的菜单项'*/
                        leftItems: Array,
                        /**导航栏中间的菜单项'*/
                        centerItems: Array,
                        /**导航栏右边的菜单项'*/
                        rightItems: Array
            }  
           /**
 * `导航栏配置`
 * ========params==========
 *
 * `hide` :int : (可选项) 
 *
 * `backgroundColor` :string : (可选项) 
 *
 * `tintColor` :string : (可选项) 
 *
 * `fullScreen` :number : (可选项) 
 *
 * `hideShadowImage` :number : (可选项) 
 *
 * `statusBarStyle` :number : (可选项) 
 *
 * `leftItems` :arrayobject : (可选项) 
 *
 * `centerItems` :arrayobject : (可选项) 
 *
 * `rightItems` :arrayobject : (可选项) 
 *
 */
            function setNavBar(option: mtl_setNavBar_Params):void;
            /**
 * `获取原生导航信息`
 */ 
            function getNavBarInfo(option: commonFun):void;
            interface mtl_showToast_Params extends commonFun{
            
                        /**需要显示的文本内容'*/
                        content: string,
                        /**显示时长'*/
                        duration: number
            }  
           /**
 * `信息提示框`
 * ========params==========
 *
 * `content` :string : (可选项) 
 *
 * `duration` :number : (可选项) 
 *
 */
            function showToast(option: mtl_showToast_Params):void;
            interface mtl_showAlert_Params extends commonFun{
            
                        /**弹窗类型。'*/
                        type: string,
                        /**alert框的标题'*/
                        title: string,
                        /**alert框的内容'*/
                        content: string,
                        /**左侧按钮的文字'*/
                        confirmButtonText: string,
                        /**右侧按钮的文字'*/
                        cancelButtonText: string
            }  
           /**
 * `警告框`
 * ========params==========
 *
 * `type` :string : (可选项) 
 *
 * `title` :string : (可选项) 
 *
 * `content` :string : (可选项) 
 *
 * `confirmButtonText` :string : (可选项) 
 *
 * `cancelButtonText` :string : (可选项) 
 *
 */
            function showAlert(option: mtl_showAlert_Params):void;
            interface mtl_navigateTo_Params extends commonFun{
            
                        /**新浏览器窗体加载的url'*/
                        url: string,
                        /**0 强制竖屏; 1 跟随系统; 2 强制横屏(微信不支持)'*/
                        orientation: number,
                        /**0：不显示顶部导航栏 1：显示顶部导航栏(微信不支持)，默认1'*/
                        navShow: number,
                        /**是否立即将webview添加到屏幕，不用等待资源加载完成。默认false'*/
                        forceShow: any,
                        /**导航标题(微信不支持)'*/
                        title: any
            }  
           /**
 * `打开新的浏览窗体`
 * ========params==========
 *
 * `url` :string : (可选项) 
 *
 * `orientation` :number : (可选项) 
 *
 * `navShow` :number : (可选项) 
 *
 * `forceShow` :bool : (可选项) 
 *
 * `title` :sting : (可选项) 
 *
 */
            function navigateTo(option: mtl_navigateTo_Params):void;
            /**
 * `关闭当前浏览窗体`
 */ 
            function navigateBack(option: commonFun):void;
            interface mtl_redirectTo_Params extends commonFun{
            
                        /**新浏览器窗体加载的url'*/
                        url: string,
                        /**0 强制竖屏; 1 跟随系统; 2 强制横屏(微信不支持)'*/
                        orientation: number,
                        /**是否清除cookie。0 否；1 是(微信不支持)'*/
                        isClearCookie: number,
                        /**0：不显示顶部导航栏 1：显示顶部导航栏(微信不支持)'*/
                        navShow: number,
                        /**是否立即将webview添加到屏幕，不用等待资源加载完成'*/
                        forceShow: any,
                        /**导航标题(微信不支持)'*/
                        title: any
            }  
           /**
 * `打开新的浏览窗体，并关闭当前页面`
 * ========params==========
 *
 * `url` :string : (可选项) 
 *
 * `orientation` :number : (可选项) 
 *
 * `isClearCookie` :number : (可选项) 
 *
 * `navShow` :number : (可选项) 
 *
 * `forceShow` :bool : (可选项) 
 *
 * `title` :sting : (可选项) 
 *
 */
            function redirectTo(option: mtl_redirectTo_Params):void;
            interface mtl_reLaunch_Params extends commonFun{
            
                        /**新浏览器窗体加载的url'*/
                        url: string,
                        /**0 强制竖屏; 1 跟随系统; 2 强制横屏(微信不支持)'*/
                        orientation: number,
                        /**是否清楚cookie。0 否；1 是(微信不支持)'*/
                        isClearCookie: number,
                        /**0：不显示顶部导航栏 1：显示顶部导航栏(微信不支持)'*/
                        navShow: number,
                        /**是否立即将webview添加到屏幕，不用等待资源加载完成'*/
                        forceShow: any,
                        /**导航标题(微信不支持)'*/
                        title: any
            }  
           /**
 * `打开新的浏览窗体，关闭前面所有页面`
 * ========params==========
 *
 * `url` :string : (可选项) 
 *
 * `orientation` :number : (可选项) 
 *
 * `isClearCookie` :number : (可选项) 
 *
 * `navShow` :number : (可选项) 
 *
 * `forceShow` :bool : (可选项) 
 *
 * `title` :sting : (可选项) 
 *
 */
            function reLaunch(option: mtl_reLaunch_Params):void;
            interface mtl_webviewLoadUrl_Params extends commonFun{
            
                        /**接口请求域名'*/
                        url: any
            }  
           /**
 * `当前页面打开url`
 * ========params==========
 *
 * `url` :sting : (可选项) 
 *
 */
            function webviewLoadUrl(option: mtl_webviewLoadUrl_Params):void;
            interface mtl_openExclusiveApp_Params extends commonFun{
            
                        /**小程序与MDF小程序资源包id'*/
                        appletExtId: any,
                        /**小程序与MDF小程序资源包版本号'*/
                        appletVersion: any,
                        /**gzip资源包id'*/
                        extId: any,
                        /**gzip资源包版本号'*/
                        gzipVersion: any,
                        /**应用编码'*/
                        serviceCode: any,
                        /**应用类型'*/
                        app_type: number,
                        /**应用icon'*/
                        serviceIcon: any,
                        /**应用名'*/
                        serviceName: any,
                        /**要打开应用所在的租户id'*/
                        tenantId: any,
                        /**应用唯一标识符'*/
                        serviceId: any,
                        /**应用打开URL'*/
                        appUrl: any,
                        /**应用类型'*/
                        appletPackageType: any,
                        /**应用类型'*/
                        packageType: any,
                        /**小程序拼接URL'*/
                        appletUrl: any,
                        /**是否显示导航栏，1显示，2不显示'*/
                        navShow: any,
                        /**横竖屏，0竖屏，1横竖屏均支持，2横屏'*/
                        supportHorizontal: number,
                        /**导航条颜色'*/
                        tintColor: any,
                        /**导航条字体颜色'*/
                        titleColor: any,
                        /**状态栏颜色'*/
                        statusBarStyle: number,
                        /**是否使用外部浏览器打开'*/
                        isbrowser: any
            }  
           /**
 * `打开应用`
 * ========params==========
 *
 * `appletExtId` :sting : (可选项) 
 *
 * `appletVersion` :sting : (可选项) 
 *
 * `extId` :sting : (可选项) 
 *
 * `gzipVersion` :sting : (可选项) 
 *
 * `serviceCode` :sting : (可选项) 
 *
 * `app_type` :int : (可选项) 
 *
 * `serviceIcon` :sting : (可选项) 
 *
 * `serviceName` :sting : (可选项) 
 *
 * `tenantId` :sting : (可选项) 
 *
 * `serviceId` :sting : (可选项) 
 *
 * `appUrl` :sting : (可选项) 
 *
 * `appletPackageType` :sting : (可选项) 
 *
 * `packageType` :sting : (可选项) 
 *
 * `appletUrl` :sting : (可选项) 
 *
 * `navShow` :sting : (可选项) 
 *
 * `supportHorizontal` :int : (可选项) 
 *
 * `tintColor` :sting : (可选项) 
 *
 * `titleColor` :sting : (可选项) 
 *
 * `statusBarStyle` :int : (可选项) 
 *
 * `isbrowser` :sting : (可选项) 
 *
 */
            function openExclusiveApp(option: mtl_openExclusiveApp_Params):void;
            /**
 * `获取字体大小`
 */ 
            function getUserFontSize(option: commonFun):void;
            interface mtl_setUserFontSize_Params extends commonFun{
            
                        /**字体大小0:移动端字体14；1:移动端字体16；2:移动端字体18；3:移动端字体20；4:移动端字体22；5:移动端字体24'*/
                        level: number
            }  
           /**
 * `设置字体大小`
 * ========params==========
 *
 * `level` :int : (可选项) 
 *
 */
            function setUserFontSize(option: mtl_setUserFontSize_Params):void;
            interface mtl_configureWebView_Params extends commonFun{
            
                        /**是否开启下拉刷新'*/
                        pullDownRefresh: any,
                        /**是否开启上拉刷新&#124;'*/
                        pullUpRefresh: any,
                        /**是否允许WebView弹簧效果，true允许，false不允许，如果设置了上拉或下拉，则强制允许（友空间iOS特有，友空间7.0.5及以上版本）'*/
                        scrollViewBounces: any
            }  
           /**
 * `webView配置`
 * ========params==========
 *
 * `pullDownRefresh` :bool : (可选项) 
 *
 * `pullUpRefresh` :bool : (可选项) 
 *
 * `scrollViewBounces` :bool : (可选项) 
 *
 */
            function configureWebView(option: mtl_configureWebView_Params):void;
            /**
 * `设备信息-获取网络状态`
 */ 
            function getNetworkType(option: commonFun):void;
            /**
 * `设备信息-获取系统信息`
 */ 
            function getSystemInfo(option: commonFun):void;
            /**
 * `设备信息-获取设备唯一标识`
 */ 
            function getUniqueId(option: commonFun):void;
            interface mtl_getLocation_Params extends commonFun{
            
                        /**默认为wgs84的gps坐标，如果要返回直接给openLocation用的火星坐标，可传入'gcj02''*/
                        type: string
            }  
           /**
 * `地图-获取位置信息`
 * ========params==========
 *
 * `type` :string : (可选项) 
 *
 */
            function getLocation(option: mtl_getLocation_Params):void;
            interface mtl_openMap_Params extends commonFun{
            
                        /**纬度，浮点数，范围为90 ~ -90'*/
                        latitude: number,
                        /**经度，浮点数，范围为180 ~ -180。'*/
                        longitude: number,
                        /**查询半径（单位：米），小于0时不限制(微信不支持)'*/
                        searchRaidus: number,
                        /**位置名，如 "用友软件园"，缺省时显示 "[位置]"（仅微信支持）'*/
                        name: string,
                        /**地址详情说明（仅微信支持）'*/
                        address: string,
                        /**地图缩放级别,整形值,范围从1~28。默认为28（仅微信支持）'*/
                        scale: number
            }  
           /**
 * `地图-打开地图`
 * ========params==========
 *
 * `latitude` :number : (可选项) 
 *
 * `longitude` :number : (可选项) 
 *
 * `searchRaidus` :number : (可选项) 
 *
 * `name` :string : (可选项) 
 *
 * `address` :string : (可选项) 
 *
 * `scale` :number : (可选项) 
 *
 */
            function openMap(option: mtl_openMap_Params):void;
            interface mtl_markAndNavigationDestination_Params extends commonFun{
            
                        /**目标地区地址'*/
                        address: string,
                        /**目标地区详细地址'*/
                        subAddress: string,
                        /**目标地区纬度'*/
                        latitude: string,
                        /**目标地区经度'*/
                        longitude: string,
                         /**用户信息'*/
                        userInfo: Object,
                        /**客户信息'*/
                        infomation: string,
                        /**是否需要导航'*/
                        navigation: any
            }  
           /**
 * `地图打点(导航)`
 * ========params==========
 *
 * `address` :string : (可选项) 
 *
 * `subAddress` :string : (可选项) 
 *
 * `latitude` :string : (可选项) 
 *
 * `longitude` :string : (可选项) 
 *
 * `userInfo` :object : (可选项) 
 *
 * `infomation` :string : (可选项) 
 *
 * `navigation` :bool : (可选项) 
 *
 */
            function markAndNavigationDestination(option: mtl_markAndNavigationDestination_Params):void;
            interface mtl_openMapToNavi_Params extends commonFun{
            
                        /**导航类型，mtl.NAVITYPE.GAODE：高德地图;mtl.NAVITYPE.BAIDU：百度地图;mtl.NAVITYPE.TENCENT：腾讯地图'*/
                        type: any,
                        /**目的地纬度'*/
                        latitude: string,
                        /**目的地经度'*/
                        longitude: string
            }  
           /**
 * `打开第三方地图导航`
 * ========params==========
 *
 * `type` :enum : (可选项) 
 *
 * `latitude` :string : (可选项) 
 *
 * `longitude` :string : (可选项) 
 *
 */
            function openMapToNavi(option: mtl_openMapToNavi_Params):void;
            interface mtl_mapLocationExtend_Params extends commonFun{
            
                        /**纬度'*/
                        latitude: string,
                        /**经度'*/
                        longitude: string,
                        /**目标距离，单位米'*/
                        targetDistance: number
            }  
           /**
 * `地图定位扩展`
 * ========params==========
 *
 * `latitude` :string : (可选项) 
 *
 * `longitude` :string : (可选项) 
 *
 * `targetDistance` :number : (可选项) 
 *
 */
            function mapLocationExtend(option: mtl_mapLocationExtend_Params):void;
            /**
 * `开启持续定位`
 */ 
            function startContinuousLocation(option: commonFun):void;
            /**
 * `获取持续定位信息`
 */ 
            function getContinuousLocation(option: commonFun):void;
            /**
 * `关闭持续定位`
 */ 
            function stopContinuousLocation(option: commonFun):void;
            interface mtl_getAuthorizationStatus_Params extends commonFun{
            
                        /**授权类型。0相册权限开关；1相机权限开关；2麦克风权限开关；3位置权限开关；4通讯录权限开关'*/
                        type: number
            }  
           /**
 * `权限查询`
 * ========params==========
 *
 * `type` :number : (可选项) 
 *
 */
            function getAuthorizationStatus(option: mtl_getAuthorizationStatus_Params):void;
            interface mtl_onNetworkStatusChange_Params extends commonFun{
            
                        /**网络变化是的回调函数'*/
                        callback():void 
            }  
           /**
 * `监听网络状态变化`
 * ========params==========
 *
 * `callback` :function : (可选项) 
 *
 */
            function onNetworkStatusChange(option: mtl_onNetworkStatusChange_Params):void;
            interface mtl_onShake_Params extends commonFun{
            
                        /**回调函数'*/
                        callback():void 
            }  
           /**
 * `监听摇一摇`
 * ========params==========
 *
 * `callback` :function : (可选项) 
 *
 */
            function onShake(option: mtl_onShake_Params):void;
            interface mtl_screenShot_Params extends commonFun{
            
                        /**0 只截取当前webview的图像1 截取整个友空间APP的图像（包含导航条）'*/
                        type: number,
                        /**0 返回截图的base字符串1 返回截图的存储路径'*/
                        resultType: number
            }  
           /**
 * `截屏`
 * ========params==========
 *
 * `type` :number : (可选项) 
 *
 * `resultType` :number : (可选项) 
 *
 */
            function screenShot(option: mtl_screenShot_Params):void;
            interface mtl_onUserCaptureScreen_Params extends commonFun{
            
                        /**用户截屏时的回调函数'*/
                        callback():void 
            }  
           /**
 * `监听用户截屏`
 * ========params==========
 *
 * `callback` :function : (可选项) 
 *
 */
            function onUserCaptureScreen(option: mtl_onUserCaptureScreen_Params):void;
            interface mtl_dail_Params extends commonFun{
            
                        /**电话号码'*/
                        number: string
            }  
           /**
 * `拨打电话`
 * ========params==========
 *
 * `number` :string : (可选项) 
 *
 */
            function dail(option: mtl_dail_Params):void;
            interface mtl_onInterceptBack_Params extends commonFun{
            
                        /**返回事件回调函数'*/
                        callback():void 
            }  
           /**
 * `拦截返回事件`
 * ========params==========
 *
 * `callback` :function : (可选项) 
 *
 */
            function onInterceptBack(option: mtl_onInterceptBack_Params):void;
            interface mtl_registerLifeCycle_Params extends commonFun{
            
                        /**页面展示时回调函数'*/
                        onShow():void ,
                        /**页面隐藏时回调函数'*/
                        onHide():void 
            }  
           /**
 * `监听页面展示、隐藏`
 * ========params==========
 *
 * `onShow` :function : (可选项) 
 *
 * `onHide` :function : (可选项) 
 *
 */
            function registerLifeCycle(option: mtl_registerLifeCycle_Params):void;
            /**
 * `震动`
 */ 
            function vibrateOnce(option: commonFun):void;
            interface mtl_changeScreenOrientation_Params extends commonFun{
            
                        /**横屏 false, 竖屏 true'*/
                        orientation: boolean
            }  
           /**
 * `强制横竖屏`
 * ========params==========
 *
 * `orientation` :boolean : (可选项) 
 *
 */
            function changeScreenOrientation(option: mtl_changeScreenOrientation_Params):void;
            /**
 * `恢复默认横竖屏`
 */ 
            function restoreScreenOrientation(option: commonFun):void;
            interface mtl_openSchema_Params extends commonFun{
            
                        /**页面的url'*/
                        url: any
            }  
           /**
 * `打开系统浏览器`
 * ========params==========
 *
 * `url` :undefined : (可选项) 
 *
 */
            function openSchema(option: mtl_openSchema_Params):void;
            /**
 * `获取系统剪贴板的内容`
 */ 
            function getClipboardData(option: commonFun):void;
            interface mtl_createShortcut_Params extends commonFun{
            
                        /**快捷方式的对应页面的 url'*/
                        url: string,
                        /**快捷方式名称'*/
                        name: string,
                        /**快捷方式图标'*/
                        icon: string,
                        /**快捷方式的对应页面的标题'*/
                        title: string
            }  
           /**
 * `创建桌面快捷方式`
 * ========params==========
 *
 * `url` :string : (可选项) 
 *
 * `name` :string : (可选项) 
 *
 * `icon` :string : (可选项) 
 *
 * `title` :string : (可选项) 
 *
 */
            function createShortcut(option: mtl_createShortcut_Params):void;
            /**
 * `使手机发生较长时间的震动`
 */ 
            function vibrateLong(option: commonFun):void;
            /**
 * `获取通用UserAgent信息`
 */ 
            function getUserAgent(option: commonFun):void;
            /**
 * `获取手机当前UI模式（正常模式/暗黑模式）`
 */ 
            function appearanceMode(option: commonFun):void;
            interface mtl_onAppearanceModeChange_Params extends commonFun{
            
                        /**网络变化是的回调函数'*/
                        callback():void 
            }  
           /**
 * `监听系统UI模式的改变`
 * ========params==========
 *
 * `callback` :function : (可选项) 
 *
 */
            function onAppearanceModeChange(option: mtl_onAppearanceModeChange_Params):void;
            interface mtl_request_Params extends commonFun{
            
                        /**开发者服务器接口地址'*/
                        url: string,
                         /**请求参数'*/
                        params: Object,
                        /**设置请求的 headers，`content-type`默认为 `application/json`'*/
                        headers: any,
                        /**默认为 GET'*/
                        method: string,
                        /**请求参数的类型'*/
                        paramsType: number
            }  
           /**
 * `网络请求`
 * ========params==========
 *
 * `url` :string : (可选项) 
 *
 * `params` :object : (可选项) 
 *
 * `headers` :Object : (可选项) 
 *
 * `method` :string : (可选项) 
 *
 * `paramsType` :number : (可选项) 
 *
 */
            function request(option: mtl_request_Params):void;
            interface mtl_uploadFile_Params extends commonFun{
            
                        /**指定服务器地址'*/
                        url: string,
                        /**文件路径'*/
                        filePath: string,
                        /**HTTP 请求 Header'*/
                        header: any,
                        /**HTTP 请求中其他额外的 form data'*/
                        formData: any
            }  
           /**
 * `文件上传`
 * ========params==========
 *
 * `url` :string : (可选项) 
 *
 * `filePath` :string : (可选项) 
 *
 * `header` :Object : (可选项) 
 *
 * `formData` :Object : (可选项) 
 *
 */
            function uploadFile(option: mtl_uploadFile_Params):void;
            interface mtl_downloadFile_Params extends commonFun{
            
                        /**需要下载资源的url'*/
                        url: string,
                        /**文件格式jpg,txt,pdf等'*/
                        fileType: string,
                        /**文件名 如abc.jpg等'*/
                        fileName: string,
                        /**是否自动打开预览界面，0不打开，1打开，默认0'*/
                        autoPreview: number,
                         /**http请求头部参数'*/
                        header: Object,
                         /**http请求额外body参数-表单形式。参数非空为post请求，否则为get请求。'*/
                        formBody: Object,
                        /**http请求额外参数-json形式'*/
                        jsonBody: string
            }  
           /**
 * `文件下载`
 * ========params==========
 *
 * `url` :string : (可选项) 
 *
 * `fileType` :string : (可选项) 
 *
 * `fileName` :string : (可选项) 
 *
 * `autoPreview` :int : (可选项) 
 *
 * `header` :object : (可选项) 
 *
 * `formBody` :object : (可选项) 
 *
 * `jsonBody` :string : (可选项) 
 *
 */
            function downloadFile(option: mtl_downloadFile_Params):void;
            /**
 * `向原生注册JS事件`
 */ 
            function registerCommonCallback(option: commonFun):void;
            interface mtl_doShare_Params extends commonFun{
            
                        /**分享的平台 ID(ios、安卓不支持0和1类型)'*/
                        type: number,
                        /**文本标题'*/
                        title: string,
                        /**文本内容'*/
                        desc: string,
                        /**分享图标'*/
                        imgUrl: string,
                        /**分享链接'*/
                        link: string
            }  
           /**
 * `分享`
 * ========params==========
 *
 * `type` :number : (可选项) 
 *
 * `title` :string : (可选项) 
 *
 * `desc` :string : (可选项) 
 *
 * `imgUrl` :string : (可选项) 
 *
 * `link` :string : (可选项) 
 *
 */
            function doShare(option: mtl_doShare_Params):void;
            interface mtl_openShare_Params extends commonFun{
            
                        /**menu 中展示的可分享到的平台'*/
                        type: number,
                        /**文本标题'*/
                        title: string,
                        /**文本内容'*/
                        desc: string,
                        /**分享图标'*/
                        imgUrl: string,
                        /**分享链接'*/
                        link: string
            }  
           /**
 * `分享页面组件`
 * ========params==========
 *
 * `type` :number : (可选项) 
 *
 * `title` :string : (可选项) 
 *
 * `desc` :string : (可选项) 
 *
 * `imgUrl` :string : (可选项) 
 *
 * `link` :string : (可选项) 
 *
 */
            function openShare(option: mtl_openShare_Params):void;
            interface mtl_searchBleClient_Params extends commonFun{
            
                        /**每次扫描的时长，单位毫秒'*/
                        searchTime: number,
                        /**扫描 BLE 设备的次数'*/
                        searchCount: number,
                        /**搜索到蓝牙设备时的回调函数'*/
                        callback():void 
            }  
           /**
 * `恩普特搜索蓝牙设备`
 * ========params==========
 *
 * `searchTime` :number : (可选项) 
 *
 * `searchCount` :number : (可选项) 
 *
 * `callback` :function : (可选项) 
 *
 */
            function searchBleClient(option: mtl_searchBleClient_Params):void;
            interface mtl_bindSensor_Params extends commonFun{
            
                        /**要绑定设备的mac地址'*/
                        address: any
            }  
           /**
 * `恩普特绑定设备`
 * ========params==========
 *
 * `address` :String : (可选项) 
 *
 */
            function bindSensor(option: mtl_bindSensor_Params):void;
            interface mtl_collectRev_Params extends commonFun{
            
                        /**采集到转速时回调的函数'*/
                        callback():void 
            }  
           /**
 * `恩普特转速采集`
 * ========params==========
 *
 * `callback` :function : (可选项) 
 *
 */
            function collectRev(option: mtl_collectRev_Params):void;
            interface mtl_collectTmp_Params extends commonFun{
            
                        /**发射率（0~1）'*/
                        emissivity: string,
                        /**采集到温度时回调的函数'*/
                        callback():void 
            }  
           /**
 * `恩普特温度采集`
 * ========params==========
 *
 * `emissivity` :string : (可选项) 
 *
 * `callback` :function : (可选项) 
 *
 */
            function collectTmp(option: mtl_collectTmp_Params):void;
            interface mtl_collectVib_Params extends commonFun{
            
                        /**采集类型。ACC:加速度；SPEED: 速度；DIS: 位移'*/
                        collectionType: string,
                        /**是否采集波值'*/
                        savewave: boolean,
                        /**采集到测振时回调的函数'*/
                        callback():void 
            }  
           /**
 * `恩普特测振采集`
 * ========params==========
 *
 * `collectionType` :string : (可选项) 
 *
 * `savewave` :boolean : (可选项) 
 *
 * `callback` :function : (可选项) 
 *
 */
            function collectVib(option: mtl_collectVib_Params):void;
            interface mtl_connectBle_Params extends commonFun{
            
                        /**需要连接的设备 mac 地址'*/
                        address: string
            }  
           /**
 * `恩普特连接设备`
 * ========params==========
 *
 * `address` :string : (可选项) 
 *
 */
            function connectBle(option: mtl_connectBle_Params):void;
            /**
 * `恩普特断开连接`
 */ 
            function disconnectBle(option: commonFun):void;
            /**
 * `恩普特获取绑定设备的 macAddress`
 */ 
            function getBindedSensor(option: commonFun):void;
            /**
 * `恩普特获取连接状态`
 */ 
            function getConnectStatus(option: commonFun):void;
            interface mtl_registerConnectStatusListener_Params extends commonFun{
            
                        /**当前绑定的传感器连接状态变化时的回调函数'*/
                        callback():void 
            }  
           /**
 * `恩普特连接状态监听`
 * ========params==========
 *
 * `callback` :function : (可选项) 
 *
 */
            function registerConnectStatusListener(option: mtl_registerConnectStatusListener_Params):void;
            /**
 * `恩普特释放资源`
 */ 
            function releaseBle(option: commonFun):void;
            /**
 * `恩普特停止采集`
 */ 
            function stopCollect(option: commonFun):void;
            /**
 * `插件名称：斑马打印`
 */ 
            function zebraPrinterList(option: commonFun):void;
            interface mtl_zebraPrintImage_Params extends commonFun{
            
                        /**图片数据base64编码后的数组字符串'*/
                        images: string,
                        /**打印设备mac地址'*/
                        serialNumber: string
            }  
           /**
 * `插件名称：斑马打印`
 * ========params==========
 *
 * `images` :string : (可选项) 
 *
 * `serialNumber` :string : (可选项) 
 *
 */
            function zebraPrintImage(option: mtl_zebraPrintImage_Params):void;
            interface mtl_rfidConnect_Params extends commonFun{
            
                        /**监听事件回调'*/
                        callback():void 
            }  
           /**
 * `插件名称：斑马RFID`
 * ========params==========
 *
 * `callback` :function : (可选项) 
 *
 */
            function rfidConnect(option: mtl_rfidConnect_Params):void;
            /**
 * `插件名称：斑马RFID`
 */ 
            function rfidDisconnect(option: commonFun):void;

            interface mtl_setTips_Params extends commonFun{
            
                        /**提示文案'*/
                        tips: string,
                        /**提示文案字体颜色'*/
                        tipsColor: string,
                        /**提示文案是否需要抖动效果'*/
                        isShake: boolean
            }
            
        interface nfc {
            
            /**
 * `打开NFC`
 */ 
            init(option: commonFun ):void;
            /**
 * `关闭NFC`
 */ 
            unInit(option: commonFun ):void;
            /**
 * `设置提示文案`
 * ========params==========
 *
 * `tips` :string : (可选项) 
 *
 * `tipsColor` :string : (可选项) 
 *
 * `isShake` :boolean : (可选项) 
 *
 */ 
            setTips(option: mtl_setTips_Params ):void;
        }
        

        interface contacts {
            
            /**
 * `选人调用api`
 */ 
            selectContacts(option: commonFun ):void;
            /**
 * `选员工调用api`
 */ 
            selectPersonnel(option: commonFun ):void;
        }
        

            interface mtl_verify_Params extends commonFun{
            
                        /**验证弹框的标题(安卓不支持此参数)'*/
                        title: any
            }

            interface mtl_vrOpen_Params extends commonFun{
            
                        /**页面的位置及长宽'*/
                        rect: any,
                        /**展示类型。sphere： 360度全景图，video： vr视频'*/
                        type: string,
                        /**播放的资源类型。0 代表资源是标准的2:1 数据；11 代表资源是单鱼眼数据——即SphereS 拍摄出来的数据；2002 代表资源是双鱼眼数据——即twin相机拍摄出来的数据；'*/
                        device: number,
                        /**要展示的 360 度全景图片、vr视频的路径'*/
                        path: string,
                        /**陀螺仪是否开启'*/
                        gyroEnable: any,
                        /**是否要缩放'*/
                        zoomEnable: any,
                        /**模块视图添加到指定 frame 的名字（ios：只指 frame，传 window 无效）(android可以是frame或者Window，但是在全屏的时候，需要挂在Window上或者frame是全屏)'*/
                        fixedOn: string,
                        /**模块是否随所属 window 或 frame 滚动'*/
                        fixed: any,
                        /**是否展示关闭按钮'*/
                        showBackBtn: any
            }

            interface mtl_vrSetViewMode_Params extends commonFun{
            
                        /**模式类型；1:默认模式，2:鱼眼模式，3:小行星模式，4:VR 模式水平，8:VR 模式竖直 9:平面模式'*/
                        mode: number
            }

            interface mtl_configuration_Params extends commonFun{
            
                        /**最小检测人脸阈值'*/
                        minFaceSize: number,
                        /**截取人脸图片大小'*/
                        cropFaceSizeWidth: number,
                        /**人脸遮挡阀值'*/
                        occluThreshold: number,
                        /**图像模糊阀值'*/
                        blurThreshold: number,
                        /**'*/
                        eulurAngle: string,
                        /**'*/
                        否: any,
                        /**超时时间'*/
                        timeout: number,
                        /**人脸检测精度阀值'*/
                        threshold: number,
                        /**照片采集张数'*/
                        maxCropImageNum: number,
                        /**是否开启提示音'*/
                        sound: boolean
            }

            interface mtl_openLivenessView_Params extends commonFun{
            
                        /**活体检测动作0/眨眼，1/张嘴，2/向右摇头，3/向左摇头，4，抬头，5，低头，6/摇头（1.0.2以及以后版本不再支持），7/没有动作'*/
                        actions: Array,
                        /**是否按顺序进行活体动作'*/
                        isByOrder: boolean,
                        /**活体动作数目（actions为空时起作用）'*/
                        numOfLiveness: number
            }

            interface mtl_gestureValidate_Params extends commonFun{
            
                        /**是否显示手势轨迹'*/
                        track: boolean,
                        /**用户信息，不传则不显示(仅支持iOS)'*/
                        user: any
            }

            interface mtl_startSpeechSyn_Params extends commonFun{
            
                        /**合成内容'*/
                        text: string
            }

            interface mtl_translateVoice_Params extends commonFun{
            
                        /**需要播放的音频的字符串，由 stopRecord 接口获得'*/
                        localId: string,
                        /**默认1。1显示加载框，0 不显示加载框。'*/
                        isShowProgressTips: number
            }
            
        interface ai {
            
            /**
 * `是否支持指纹识别`
 */ 
            isValid(option: commonFun ):void;
            /**
 * `验证faceID`
 * ========params==========
 *
 * `title` :stirng : (可选项) 
 *
 */ 
            verify(option: mtl_verify_Params ):void;
            /**
 * `取消验证`
 */ 
            cancelVerify(option: commonFun ):void;
            /**
 * `打开页面`
 * ========params==========
 *
 * `rect` :obj : (可选项) 
 *
 * `type` :string : (可选项) 
 *
 * `device` :number : (可选项) 
 *
 * `path` :string : (可选项) 
 *
 * `gyroEnable` :booblean : (可选项) 
 *
 * `zoomEnable` :booblean : (可选项) 
 *
 * `fixedOn` :string : (可选项) 
 *
 * `fixed` :booblean : (可选项) 
 *
 * `showBackBtn` :booblean : (可选项) 
 *
 */ 
            vrOpen(option: mtl_vrOpen_Params ):void;
            /**
 * `关闭页面`
 */ 
            vrClose(option: commonFun ):void;
            /**
 * `设置模式`
 * ========params==========
 *
 * `mode` :number : (可选项) 
 *
 */ 
            vrSetViewMode(option: mtl_vrSetViewMode_Params ):void;
            /**
 * `人脸功能配置`
 * ========params==========
 *
 * `minFaceSize` :number : (可选项) 
 *
 * `cropFaceSizeWidth` :number : (可选项) 
 *
 * `occluThreshold` :number : (可选项) 
 *
 * `blurThreshold` :number : (可选项) 
 *
 * `eulurAngle` :string : (可选项) 
 *
 * `否` : : (可选项) 
 *
 * `timeout` :number : (可选项) 
 *
 * `threshold` :number : (可选项) 
 *
 * `maxCropImageNum` :number : (可选项) 
 *
 * `sound` :boolean : (可选项) 
 *
 */ 
            configuration(option: mtl_configuration_Params ):void;
            /**
 * `打开活体检测页面`
 * ========params==========
 *
 * `actions` :array : (可选项) 
 *
 * `isByOrder` :boolean : (可选项) 
 *
 * `numOfLiveness` :number : (可选项) 
 *
 */ 
            openLivenessView(option: mtl_openLivenessView_Params ):void;
            /**
 * `打开人脸图像采集页面`
 */ 
            openDetectionView(option: commonFun ):void;
            /**
 * `打开设置密码页面`
 */ 
            gestureCreate(option: commonFun ):void;
            /**
 * `获取手势密码`
 */ 
            gesturePassword(option: commonFun ):void;
            /**
 * `清空设置的手势密码`
 */ 
            gestureDelete(option: commonFun ):void;
            /**
 * `打开验证手势密码视图`
 * ========params==========
 *
 * `track` :boolean : (可选项) 
 *
 * `user` :obj : (可选项) 
 *
 */ 
            gestureValidate(option: mtl_gestureValidate_Params ):void;
            /**
 * `语音播报`
 * ========params==========
 *
 * `text` :string : (可选项) 
 *
 */ 
            startSpeechSyn(option: mtl_startSpeechSyn_Params ):void;
            /**
 * `停止语音播报`
 */ 
            stopSpeechSyn(option: commonFun ):void;
            /**
 * `语音文件转文字`
 * ========params==========
 *
 * `localId` :string : (可选项) 
 *
 * `isShowProgressTips` :number : (可选项) 
 *
 */ 
            translateVoice(option: mtl_translateVoice_Params ):void;
            /**
 * `语音转文字`
 */ 
            voiceToText(option: commonFun ):void;
        }
        

            interface mtl_searchDevices_Params extends commonFun{
            
                        /**搜索超时时间，默认10秒，超出时间后没有搜索到可用设备时需要重新搜索'*/
                        time: number,
                        /**搜索类型，参考值："wifi":局域网wifi; "classic":蓝牙经典版；"ble":蓝牙低功耗版; "all":包括全面三种全部'*/
                        type: string,
                        /**搜索数据回调函数'*/
                        callback():void 
            }

            interface mtl_printPicture_Params extends commonFun{
            
                        /**searchDevices方法中返回的deviceInfos中的任意一个都可以选择'*/
                        deviceInfo: any,
                        /**本地图片的路径，支持fs、绝对路径'*/
                        path: string
            }

            interface mtl_printHTML_Params extends commonFun{
            
                        /**searchDevices方法中返回的deviceInfos中的任意一个都可以选择'*/
                        deviceInfo: any,
                        /**本地html的路径，支持fs、绝对路径'*/
                        path: string
            }

            interface mtl_printFile_Params extends commonFun{
            
                        /**searchDevices方法中返回的deviceInfos中的任意一个都可以选择'*/
                        deviceInfo: any
            }
            
        interface ymPrinter {
            
            /**
 * `搜索可用的映美打印设备`
 * ========params==========
 *
 * `time` :number : (可选项) 
 *
 * `type` :string : (可选项) 
 *
 * `callback` :function : (可选项) 
 *
 */ 
            searchDevices(option: mtl_searchDevices_Params ):void;
            /**
 * `是否支持蓝牙BLE`
 */ 
            isSupportedBLE(option: commonFun ):void;
            /**
 * `蓝牙是否开启`
 */ 
            isBluetoothOpen(option: commonFun ):void;
            /**
 * `获取已链接设备信息`
 */ 
            getConnectedDevice(option: commonFun ):void;
            /**
 * `打印图片`
 * ========params==========
 *
 * `deviceInfo` :obj : (可选项) 
 *
 * `path` :string : (可选项) 
 *
 */ 
            printPicture(option: mtl_printPicture_Params ):void;
            /**
 * `打印html`
 * ========params==========
 *
 * `deviceInfo` :obj : (可选项) 
 *
 * `path` :string : (可选项) 
 *
 */ 
            printHTML(option: mtl_printHTML_Params ):void;
            /**
 * `选择一个文件打印`
 * ========params==========
 *
 * `deviceInfo` :obj : (可选项) 
 *
 */ 
            printFile(option: mtl_printFile_Params ):void;
            /**
 * `停止搜索`
 */ 
            stopSearch(option: commonFun ):void;
            /**
 * `关闭链接`
 */ 
            closeConnect(option: commonFun ):void;
            /**
 * `释放资源`
 */ 
            release(option: commonFun ):void;
        }
        

            interface mtl_loginIM_Params extends commonFun{
            
                        /**用户ID'*/
                        userId: string,
                        /**密码'*/
                        paswword: string,
                        /**token'*/
                        imToken: any,
                        /**token过期时间'*/
                        expiration: string
            }

            interface mtl_openChat_Params extends commonFun{
            
                        /**聊天ID'*/
                        chatId: string,
                        /**单聊或群聊。chat、groupchat'*/
                        chatType: string,
                        /**搜索时需要此参数'*/
                        messagePid: string,
                        /**头像跳转和设置跳转的数据类{avatar:'xxxx', //跳转时需要传chatId  setting: 'xxxx'  //跳转时需要传chatId和chatType}'*/
                        bundle: any
            }

            interface mtl_doSearch_Params extends commonFun{
            
                        /**搜索内容'*/
                        text: string,
                        /**搜索类型。1: 消息搜索；2:群组搜索；3:消息+群组搜索；类型为3时，超过三条数据只返回三条数据， loadMore:true'*/
                        searchType: number,
                        /**消息ID。  (在此消息内搜索聊天内容)'*/
                        chatId: string
            }

            interface mtl_createChatGroup_Params extends commonFun{
            
                        /**群组名称'*/
                        groupName: string,
                        /**群组人员(用户ID列表)'*/
                        userIds: any,
                        /**群头像  base64格式'*/
                        groupPhoto: string
            }

            interface mtl_getGroupMembers_Params extends commonFun{
            
                        /**群组ID'*/
                        chatId: string,
                        /**指定个数(默认全部)'*/
                        limit: number
            }

            interface mtl_renameChatGroupName_Params extends commonFun{
            
                        /**群组ID'*/
                        chatId: string,
                        /**群组名称'*/
                        groupName: string
            }

            interface mtl_modifyChatGroupAnnounce_Params extends commonFun{
            
                        /**群组ID'*/
                        chatId: string,
                        /**公告内容'*/
                        announce: string
            }

            interface mtl_inviteRosterIntoChatGroup_Params extends commonFun{
            
                        /**群组ID'*/
                        chatId: string,
                        /**人员(用户ID列表)'*/
                        userIds: any
            }

            interface mtl_kickGroupMember_Params extends commonFun{
            
                        /**群组ID'*/
                        chatId: string,
                        /**人员(用户ID列表)'*/
                        userIds: any
            }

            interface mtl_leaveChatGroup_Params extends commonFun{
            
                        /**群组ID'*/
                        chatId: string
            }

            interface mtl_changeChatGroupAdmin_Params extends commonFun{
            
                        /**群组ID'*/
                        chatId: string,
                        /**人员(用户ID)'*/
                        userId: string
            }

            interface mtl_dismissChatGroup_Params extends commonFun{
            
                        /**群组ID'*/
                        chatId: string
            }

            interface mtl_updateStickTop_Params extends commonFun{
            
                        /**聊天ID'*/
                        chatId: string,
                        /**单聊或群聊。chat、groupchat'*/
                        chatType: string,
                        /**是否置顶'*/
                        stickTop: boolean
            }

            interface mtl_updateNoDisturb_Params extends commonFun{
            
                        /**聊天ID'*/
                        chatId: string,
                        /**单聊或群聊。chat、groupchat'*/
                        chatType: string,
                        /**是否免打扰'*/
                        noDisturb: boolean
            }

            interface mtl_deleteMessage_Params extends commonFun{
            
                        /**聊天ID'*/
                        chatId: string,
                        /**单聊或群聊。chat、groupchat'*/
                        chatType: string
            }

            interface mtl_forwardMessage_Params extends commonFun{
            
                        /**聊天ID'*/
                        chatId: string,
                        /**单聊或群聊。chat、groupchat'*/
                        chatType: string,
                        /**消息ID'*/
                        messagePid: string
            }

            interface mtl_getContactInfo_Params extends commonFun{
            
                        /**用户、群组ID'*/
                        chatId: string,
                        /**单聊或群聊。chat、groupchat'*/
                        chatType: string
            }
            
        interface im {
            
            /**
 * `登陆`
 * ========params==========
 *
 * `userId` :string : (可选项) 
 *
 * `paswword` :string : (可选项) 
 *
 * `imToken` :sting : (可选项) 
 *
 * `expiration` :string : (可选项) 
 *
 */ 
            loginIM(option: mtl_loginIM_Params ):void;
            /**
 * `退出`
 */ 
            logoutIM(option: commonFun ):void;
            /**
 * `打开聊天页面`
 * ========params==========
 *
 * `chatId` :string : (可选项) 
 *
 * `chatType` :string : (可选项) 
 *
 * `messagePid` :string : (可选项) 
 *
 * `bundle` :obj : (可选项) 
 *
 */ 
            openChat(option: mtl_openChat_Params ):void;
            /**
 * `获取消息未读书`
 */ 
            getUnreadMsgCount(option: commonFun ):void;
            /**
 * `获取消息列表`
 */ 
            getRecentMessage(option: commonFun ):void;
            /**
 * `获取更新消息`
 */ 
            getReceiveMessage(option: commonFun ):void;
            /**
 * `搜索人员、群组和消息`
 * ========params==========
 *
 * `text` :string : (可选项) 
 *
 * `searchType` :int : (可选项) 
 *
 * `chatId` :string : (可选项) 
 *
 */ 
            doSearch(option: mtl_doSearch_Params ):void;
            /**
 * `创建群聊`
 * ========params==========
 *
 * `groupName` :string : (可选项) 
 *
 * `userIds` :obj : (可选项) 
 *
 * `groupPhoto` :string : (可选项) 
 *
 */ 
            createChatGroup(option: mtl_createChatGroup_Params ):void;
            /**
 * `获取全部群成员`
 * ========params==========
 *
 * `chatId` :string : (可选项) 
 *
 * `limit` :int : (可选项) 
 *
 */ 
            getGroupMembers(option: mtl_getGroupMembers_Params ):void;
            /**
 * `修改群名称`
 * ========params==========
 *
 * `chatId` :string : (可选项) 
 *
 * `groupName` :string : (可选项) 
 *
 */ 
            renameChatGroupName(option: mtl_renameChatGroupName_Params ):void;
            /**
 * `设置群公告`
 * ========params==========
 *
 * `chatId` :string : (可选项) 
 *
 * `announce` :string : (可选项) 
 *
 */ 
            modifyChatGroupAnnounce(option: mtl_modifyChatGroupAnnounce_Params ):void;
            /**
 * `添加群成员`
 * ========params==========
 *
 * `chatId` :string : (可选项) 
 *
 * `userIds` :obj : (可选项) 
 *
 */ 
            inviteRosterIntoChatGroup(option: mtl_inviteRosterIntoChatGroup_Params ):void;
            /**
 * `删除群成员`
 * ========params==========
 *
 * `chatId` :string : (可选项) 
 *
 * `userIds` :obj : (可选项) 
 *
 */ 
            kickGroupMember(option: mtl_kickGroupMember_Params ):void;
            /**
 * `删除并退出群聊`
 * ========params==========
 *
 * `chatId` :string : (可选项) 
 *
 */ 
            leaveChatGroup(option: mtl_leaveChatGroup_Params ):void;
            /**
 * `转让群组`
 * ========params==========
 *
 * `chatId` :string : (可选项) 
 *
 * `userId` :string : (可选项) 
 *
 */ 
            changeChatGroupAdmin(option: mtl_changeChatGroupAdmin_Params ):void;
            /**
 * `解散群组`
 * ========params==========
 *
 * `chatId` :string : (可选项) 
 *
 */ 
            dismissChatGroup(option: mtl_dismissChatGroup_Params ):void;
            /**
 * `消息置顶`
 * ========params==========
 *
 * `chatId` :string : (可选项) 
 *
 * `chatType` :string : (可选项) 
 *
 * `stickTop` :boolean : (可选项) 
 *
 */ 
            updateStickTop(option: mtl_updateStickTop_Params ):void;
            /**
 * `消息免打扰`
 * ========params==========
 *
 * `chatId` :string : (可选项) 
 *
 * `chatType` :string : (可选项) 
 *
 * `noDisturb` :boolean : (可选项) 
 *
 */ 
            updateNoDisturb(option: mtl_updateNoDisturb_Params ):void;
            /**
 * `删除消息`
 * ========params==========
 *
 * `chatId` :string : (可选项) 
 *
 * `chatType` :string : (可选项) 
 *
 */ 
            deleteMessage(option: mtl_deleteMessage_Params ):void;
            /**
 * `转发消息`
 * ========params==========
 *
 * `chatId` :string : (可选项) 
 *
 * `chatType` :string : (可选项) 
 *
 * `messagePid` :string : (可选项) 
 *
 */ 
            forwardMessage(option: mtl_forwardMessage_Params ):void;
            /**
 * `获取用户、群组信息`
 * ========params==========
 *
 * `chatId` :string : (可选项) 
 *
 * `chatType` :string : (可选项) 
 *
 */ 
            getContactInfo(option: mtl_getContactInfo_Params ):void;
        }
        

            interface mtl_startPDAScan_Params extends commonFun{
            
                        /**监听事件回调名称'*/
                        callback: string
            }
            
        interface mobile {
            
            /**
 * `pda开启扫描监听`
 * ========params==========
 *
 * `callback` :string : (可选项) 
 *
 */ 
            startPDAScan(option: mtl_startPDAScan_Params ):void;
            /**
 * `pda停止扫描监听`
 */ 
            stopPDAScan(option: commonFun ):void;
        }
        

        interface wifi {
            
            /**
 * `获取设备当前连接的wifi`
 */ 
            currentWifi(option: commonFun ):void;
            /**
 * `打开wifi`
 */ 
            openWifi(option: commonFun ):void;
            /**
 * `关闭wifi`
 */ 
            closeWifi(option: commonFun ):void;
            /**
 * `获取当前wifi状态`
 */ 
            getWifiState(option: commonFun ):void;
            /**
 * `扫描获取附近的wifi列表`
 */ 
            scanWifiList(option: commonFun ):void;
            /**
 * `获取已经配置过的wifi列表`
 */ 
            getConfiguredNetworks(option: commonFun ):void;
        }
        

            interface mtl_initXiaoYou_Params extends commonFun{
            
                        /**body中的领域区分标识'*/
                        appcode: string,
                        /**租户ID'*/
                        tenantid: string,
                        /**VPA服务地址'*/
                        domain: string,
                        /**VPA机器人token'*/
                        token: string,
                        /**机器人ID，指定意图'*/
                        robotid: string,
                        /**用户ID'*/
                        userid: string,
                        /**友互通token'*/
                        yhtAccessToken: string,
                        /**极速版APP标识'*/
                        domainid: string,
                        /**机器人版本'*/
                        robotVersion: string,
                        /**是否半屏显示'*/
                        isDialog: boolean,
                        /**语种'*/
                        locale: string,
                        /**会话id'*/
                        sessionid: string,
                        /**消息类型'*/
                        msgtype: string,
                        /**设备类型'*/
                        devicetype: string,
                        /**用户所处位置说明'*/
                        location: any,
                        /**'*/
                        type: number,
                        /**是否移动端适配的卡片格式返回数据'*/
                        showModel: boolean,
                        /**标记是否是测试状态'*/
                        testFlag: boolean,
                        /**是否使用输入框'*/
                        isShowInputBox: boolean,
                        /**是否显示帮助入口'*/
                        isShowHelpBox: boolean,
                        /**静音超时时间（1--10000ms）'*/
                        bosTime: number,
                        /**停止说话检测时间（1--10000ms）'*/
                        eosTime: number
            }

            interface mtl_openXiaoYou_Params extends commonFun{
            
                        /**数据回调方法'*/
                        registerCallback():void ,
                        /**方法名称'*/
                        callbackName: any
            }
            
        interface vui {
            
            /**
 * `初始化`
 * ========params==========
 *
 * `appcode` :string : (可选项) 
 *
 * `tenantid` :string : (可选项) 
 *
 * `domain` :string : (可选项) 
 *
 * `token` :string : (可选项) 
 *
 * `robotid` :string : (可选项) 
 *
 * `userid` :string : (可选项) 
 *
 * `yhtAccessToken` :string : (可选项) 
 *
 * `domainid` :string : (可选项) 
 *
 * `robotVersion` :string : (可选项) 
 *
 * `isDialog` :boolean : (可选项) 
 *
 * `locale` :string : (可选项) 
 *
 * `sessionid` :string : (可选项) 
 *
 * `msgtype` :string : (可选项) 
 *
 * `devicetype` :string : (可选项) 
 *
 * `location` :obj : (可选项) 
 *
 * `type` :number : (可选项) 
 *
 * `showModel` :boolean : (可选项) 
 *
 * `testFlag` :boolean : (可选项) 
 *
 * `isShowInputBox` :boolean : (可选项) 
 *
 * `isShowHelpBox` :boolean : (可选项) 
 *
 * `bosTime` :number : (可选项) 
 *
 * `eosTime` :number : (可选项) 
 *
 */ 
            initXiaoYou(option: mtl_initXiaoYou_Params ):void;
            /**
 * `打开小友页面`
 * ========params==========
 *
 * `registerCallback` :function : (可选项) 
 *
 * `callbackName` :stirng : (可选项) 
 *
 */ 
            openXiaoYou(option: mtl_openXiaoYou_Params ):void;
            /**
 * `关闭小友页面`
 */ 
            closeXY(option: commonFun ):void;
        }
        

            interface mtl_isAppInstalled_Params extends commonFun{
            
                        /**应用包名'*/
                        paths: Array
            }
            
        interface apkCheck {
            
            /**
 * `检测设备是否root`
 */ 
            isRoot(option: commonFun ):void;
            /**
 * `应用是否运行在模拟器中`
 */ 
            isEmulator(option: commonFun ):void;
            /**
 * `是否存在应用多开`
 */ 
            hasDoubleApK(option: commonFun ):void;
            /**
 * `检测某个应用是否安装`
 * ========params==========
 *
 * `paths` :array : (可选项) 
 *
 */ 
            isAppInstalled(option: mtl_isAppInstalled_Params ):void;
        }
        

            interface mtl_setDeviceToken_Params extends commonFun{
            
                        /**应用key'*/
                        appkey: string,
                        /**应用secret'*/
                        appSecret: string,
                        /**用户名'*/
                        userid: string,
                        /**证书名称'*/
                        certificateName: any,
                        /**域名'*/
                        baseUrl: any
            }

            interface mtl_removePush_Params extends commonFun{
            
                        /**应用key'*/
                        appkey: string,
                        /**用户名'*/
                        userid: string
            }

            interface mtl_receiveNotice_Params extends commonFun{
            
                        /**数据回调方法'*/
                        registerCallback():void ,
                        /**方法名称'*/
                        callbaseName: any
            }

            interface mtl_setBadgeNumber_Params extends commonFun{
            
                        /**角标数量'*/
                        count: number
            }
            
        interface push {
            
            /**
 * `设置deviceToken`
 * ========params==========
 *
 * `appkey` :string : (可选项) 
 *
 * `appSecret` :string : (可选项) 
 *
 * `userid` :string : (可选项) 
 *
 * `certificateName` :stirng : (可选项) 
 *
 * `baseUrl` :stirng : (可选项) 
 *
 */ 
            setDeviceToken(option: mtl_setDeviceToken_Params ):void;
            /**
 * `删除用户推送`
 * ========params==========
 *
 * `appkey` :string : (可选项) 
 *
 * `userid` :string : (可选项) 
 *
 */ 
            removePush(option: mtl_removePush_Params ):void;
            /**
 * `获取点击通知消息`
 */ 
            getNotice(option: commonFun ):void;
            /**
 * `在线消息`
 * ========params==========
 *
 * `registerCallback` :function : (可选项) 
 *
 * `callbaseName` :stirng : (可选项) 
 *
 */ 
            receiveNotice(option: mtl_receiveNotice_Params ):void;
            /**
 * `设置角标数`
 * ========params==========
 *
 * `count` :int : (可选项) 
 *
 */ 
            setBadgeNumber(option: mtl_setBadgeNumber_Params ):void;
        }
        

            interface mtl_alipayPayment_Params extends commonFun{
            
                        /**包含支付信息，后台生成，包含参数orderInfo(支付的详细信息)'*/
                        parameters: any
            }

            interface mtl_wxpayPayment_Params extends commonFun{
            
                        /**包含支付信息，后台生成(支付的详细信息)'*/
                        parameters: any
            }
            
        interface pay {
            
            /**
 * `阿里支付`
 * ========params==========
 *
 * `parameters` :obj : (可选项) 
 *
 */ 
            alipayPayment(option: mtl_alipayPayment_Params ):void;
            /**
 * `微信支付`
 * ========params==========
 *
 * `parameters` :obj : (可选项) 
 *
 */ 
            wxpayPayment(option: mtl_wxpayPayment_Params ):void;
        }
        

            interface mtl_addEvent_Params extends commonFun{
            
                        /**标题'*/
                        title: string,
                        /**描述'*/
                        description: string,
                        /**地点'*/
                        location: string,
                        /**开始时间。格式：2016-10-01 13:20:30'*/
                        startTime: string,
                        /**结束时间'*/
                        endTime: string
            }

            interface mtl_removeEvent_Params extends commonFun{
            
                        /**提醒ID'*/
                        eventId: string
            }

            interface mtl_updateEvent_Params extends commonFun{
            
                        /**提醒ID'*/
                        eventId: string,
                        /**标题'*/
                        title: string,
                        /**描述'*/
                        description: string,
                        /**地点'*/
                        location: string,
                        /**开始时间。格式：2016-10-01 13:20:30'*/
                        startTime: string,
                        /**结束时间'*/
                        endTime: string
            }

            interface mtl_getAllEvent_Params extends commonFun{
            
                        /**开始时间'*/
                        startTime: any,
                        /**结束时间'*/
                        finishTime: any
            }

            interface mtl_getEventById_Params extends commonFun{
            
                        /**提醒ID'*/
                        eventId: string
            }
            
        interface calendar {
            
            /**
 * `判断是否有访问提醒事项的权限`
 */ 
            remindersAuth(option: commonFun ):void;
            /**
 * `添加提醒`
 * ========params==========
 *
 * `title` :string : (可选项) 
 *
 * `description` :string : (可选项) 
 *
 * `location` :string : (可选项) 
 *
 * `startTime` :string : (可选项) 
 *
 * `endTime` :string : (可选项) 
 *
 */ 
            addEvent(option: mtl_addEvent_Params ):void;
            /**
 * `删除提醒`
 * ========params==========
 *
 * `eventId` :string : (可选项) 
 *
 */ 
            removeEvent(option: mtl_removeEvent_Params ):void;
            /**
 * `更新提醒`
 * ========params==========
 *
 * `eventId` :string : (可选项) 
 *
 * `title` :string : (可选项) 
 *
 * `description` :string : (可选项) 
 *
 * `location` :string : (可选项) 
 *
 * `startTime` :string : (可选项) 
 *
 * `endTime` :string : (可选项) 
 *
 */ 
            updateEvent(option: mtl_updateEvent_Params ):void;
            /**
 * `获取所有提醒`
 * ========params==========
 *
 * `startTime` :obj : (可选项) 
 *
 * `finishTime` :obj : (可选项) 
 *
 */ 
            getAllEvent(option: mtl_getAllEvent_Params ):void;
            /**
 * `通过id获取提醒`
 * ========params==========
 *
 * `eventId` :string : (可选项) 
 *
 */ 
            getEventById(option: mtl_getEventById_Params ):void;
        }
        

            interface mtl_initManager_Params extends commonFun{
            
                        /**true 为单例模式,false为非单例模式;默认为false'*/
                        single: boolean
            }

            interface mtl_scan_Params extends commonFun{
            
                        /**要扫描的蓝牙设备的服务（service）的 UUID（字符串） 组成的数组，若不传则扫描附近的所有支持蓝牙的设备'*/
                        serviceUUIDs: Array,
                        /**扫描前是否清空已搜索到的记录在本地的外围设备信息'*/
                        clean: boolean
            }
            
        interface ble {
            
            /**
 * `初始化蓝牙`
 * ========params==========
 *
 * `single` :boolean : (可选项) 
 *
 */ 
            initManager(option: mtl_initManager_Params ):void;
            /**
 * `开始搜索蓝牙设备`
 * ========params==========
 *
 * `serviceUUIDs` :array : (可选项) 
 *
 * `clean` :boolean : (可选项) 
 *
 */ 
            scan(option: mtl_scan_Params ):void;
            /**
 * `判断是否正在扫描`
 */ 
            isScanning(option: commonFun ):void;
            /**
 * `停止搜索附近的蓝牙设备`
 */ 
            stopScan(option: commonFun ):void;
            /**
 * `获取当前扫描到的所有外围设备信息`
 */ 
            getPeripheral(option: commonFun ):void;
            /**
 * `打开蓝牙`
 */ 
            openBluetooth(option: commonFun ):void;
        }
        

            interface mtl_receivePush_Params extends commonFun{
            
                        /**数据回调方法'*/
                        registerCallback():void ,
                        /**方法名称'*/
                        callbaseName: any
            }

            interface mtl_getOffLinePush_Params extends commonFun{
            
                        /**离线消息：0，离线通知：1，所有离线数据：2'*/
                        type: number
            }

            interface mtl_setBadgeAutoIncrement_Params extends commonFun{
            
                        /**badge数，取值范围[0,99999]'*/
                        badgeNum: number
            }
            
        interface aliPush {
            
            /**
 * `阿里云推送`
 * ========params==========
 *
 * `registerCallback` :function : (可选项) 
 *
 * `callbaseName` :stirng : (可选项) 
 *
 */ 
            receivePush(option: mtl_receivePush_Params ):void;
            /**
 * `获取离线推送数据`
 * ========params==========
 *
 * `type` :int : (可选项) 
 *
 */ 
            getOffLinePush(option: mtl_getOffLinePush_Params ):void;
            /**
 * `获取deviceId`
 */ 
            getDeviceId(option: commonFun ):void;
            /**
 * `获取deviceToken`
 */ 
            getDeviceToken(option: commonFun ):void;
            /**
 * `同步角标数`
 * ========params==========
 *
 * `badgeNum` :int : (可选项) 
 *
 */ 
            setBadgeAutoIncrement(option: mtl_setBadgeAutoIncrement_Params ):void;
        }
        
}