// import * as path from "path";
// import * as fs from 'fs';
// import { Uri } from 'vscode';
const path = require('path');
const fs = require('fs');
const vscode = require('vscode');

// 加载本地资源
module.exports.getExtensionFileVscodeResource = (context, relativePath) => {
	const diskPath = vscode.Uri.file(path.join(context.extensionPath, relativePath));
	return diskPath.with({ scheme: 'vscode-resource' }).toString();
};

// 加载html文件
module.exports.getWebViewContent = (context, templatePath) => {
	try {
		const resourcePath = path.join(context.extensionPath, templatePath);
		const dirPath = path.dirname(resourcePath);
		let html = fs.readFileSync(resourcePath, 'utf-8');
		// 对HTML文件进行重写，把link链接的资源通过对应形式重新写入文件，再进行下列操作；
		// html = rewriteHTML(html);
		// vscode不支持直接加载本地资源，需要替换成其专有路径格式，这里只是简单的将样式和JS的路径替换
		html = html.replace(/(<link.+?href="|<script.+?src="|<img.+?src=")(.+?)"/g, (m, $1, $2) => {
			return $1 + vscode.Uri.file(path.resolve(dirPath, $2)).with({ scheme: 'vscode-resource' }).toString() + '"';
		});
		return html;
	} catch (err) {
		console.log(err);
	}
};


// 获取当前项目所在目录
module.exports.getWorkspaceFolder = (fielPath) => {
	let workspaceFolders = vscode.workspace.workspaceFolders;
	let workspaceFolder;
	workspaceFolders.forEach(item => {
		if (fielPath.includes(item.uri.fsPath)) {
			workspaceFolder = item;
		}
	});
	return workspaceFolder;
};

function rewriteHTML(code) {
	let html = code;
	// 首先对html链接资源的路径获取；
	let cssList = '',jsList='', result;
	const recss = /link href=\s*['"](.*?css)['"] rel="prefetch"/g;
	const rejs = /link href=\s*['"](.*?js)['"] rel="prefetch"/g;
	// 组织新的标签
	while (result = recss.exec(html)) {
		cssList += `<link href="${result[1]}" rel="stylesheet" type="text/css">`
	}
	while (result = rejs.exec(html)) {
		jsList += `<script src="${result[1]}" charset="utf-8"></script>`
	}
	html = html.replace('</head>',cssList+'</head>').replace('</head>',jsList +'</head>');
	console.log('html<<<<<<<<<<<<<<<<<<<',html)
	return html;

}

module.exports.basename = (fsPath, text) => {
	let pathstr = fsPath.replace(text,'').replaceAll(path.sep,'/').split('/');
 	let filename = pathstr[pathstr.length - 1].split('.')[0];
	return filename;
}