// packages/avm-ui/src/utils/tree.ts
function getTreeDeep(treeData, childrenName = "children") {
  const walker = (tree) => {
    let deep = 0;
    tree.forEach((item) => {
      if (item[childrenName]) {
        deep = Math.max(deep, walker(item[childrenName]) + 1);
      } else {
        deep = Math.max(deep, 1);
      }
    });
    return deep;
  };
  return walker(treeData);
}

// packages/avm-ui/src/utils/classnames.ts
function classNames(...args) {
  const cls = [];
  args.forEach((arg) => {
    if (typeof arg === "string") {
      cls.push(arg);
    } else if (Object.prototype.toString.call(arg) === "[object Object]") {
      for (const argKey in arg) {
        arg[argKey] && cls.push(argKey);
      }
    } else if (arg) {
      console.log(`arg ${arg} type not support`);
    }
  });
  return cls.join(" ");
}

// packages/avm-ui/src/components/icon/icon.config.json
var fontName = "avm-icon";
var startUnicode = 6e4;
var defaultCode = 8;

// packages/avm-ui/src/components/icon/icon.json
var props = [
  {
    name: "name",
    tip: "\u56FE\u6807\u540D\u79F0",
    type: "string",
    enum: [
      "AaOutline",
      "AddCircleOutline",
      "AddOutline",
      "AddSquareOutline",
      "AddressBookFill",
      "AlipayCircleFill",
      "AlipaySquareFill",
      "AntOutline",
      "ApiCloudlogo",
      "AppOutline",
      "AppstoreOutline",
      "ArrowDownCircleOutline",
      "ArrowsAltOutline",
      "AudioFill",
      "AudioMutedOutline",
      "AudioOutline",
      "BankcardOutline",
      "BellMuteOutline",
      "BellOutline",
      "BillOutline",
      "CalculatorOutline",
      "CalendarOutline",
      "CameraOutline",
      "ChatAddOutline",
      "ChatCheckOutline",
      "ChatWrongOutline",
      "CheckCircleFill",
      "CheckCircleOutline",
      "CheckOutline",
      "CheckShieldFill",
      "CheckShieldOutline",
      "ClockCircleFill",
      "ClockCircleOutline",
      "CloseCircleFill",
      "CloseCircleOutline",
      "CloseOutline",
      "CloseShieldOutline",
      "CollectMoneyOutline",
      "CompassOutline",
      "ContentOutline",
      "CouponOutline",
      "DeleteOutline",
      "DownCircleOutline",
      "DownFill",
      "DownOutline",
      "DownlandOutline",
      "EditFill",
      "EditSFill",
      "EditSOutline",
      "EnvironmentOutline",
      "ExclamationCircleFill",
      "ExclamationCircleOutline",
      "ExclamationOutline",
      "ExclamationShieldFill",
      "ExclamationShieldOutline",
      "ExclamationTriangleOutline",
      "EyeFill",
      "EyeInvisibleFill",
      "EyeInvisibleOutline",
      "EyeOutline",
      "FaceRecognitionOutline",
      "FileOutline",
      "FileWrongOutline",
      "FillinOutline",
      "FilterOutline",
      "FingerdownOutline",
      "FireFill",
      "FlagOutline",
      "FolderOutline",
      "ForbidFill",
      "FrownFill",
      "FrownOutline",
      "GiftOutline",
      "GlobalOutline",
      "HandPayCircleOutline",
      "HeartFill",
      "HeartOutline",
      "HistogramOutline",
      "InformationCircleFill",
      "InformationCircleOutline",
      "KeyOutline",
      "KoubeiFill",
      "KoubeiOutline",
      "LeftOutline",
      "LikeOutline",
      "LinkOutline",
      "LocationFill",
      "LocationOutline",
      "LockFill",
      "LockOutline",
      "LoopOutline",
      "MailFill",
      "MailOpenOutline",
      "MailOutline",
      "MessageFill",
      "MessageOutline",
      "MinusCircleOutline",
      "MinusOutline",
      "MoreOutline",
      "MovieOutline",
      "PayCircleOutline",
      "PhoneFill",
      "PhonebookFill",
      "PhonebookOutline",
      "PictureOutline",
      "PictureWrongOutline",
      "PicturesOutline",
      "PieOutline",
      "PlayOutline",
      "QuestionCircleFill",
      "QuestionCircleOutline",
      "ReceiptOutline",
      "ReceivePaymentOutline",
      "RedoOutline",
      "RightOutline",
      "ScanCodeOutline",
      "ScanningFaceOutline",
      "ScanningOutline",
      "SearchOutline",
      "SendOutline",
      "SetOutline",
      "ShopbagOutline",
      "ShrinkOutline",
      "SmileFill",
      "SmileOutline",
      "SoundMuteFill",
      "SoundMuteOutline",
      "SoundOutline",
      "StarFill",
      "StarOutline",
      "StopOutline",
      "SystemQRcodeOutline",
      "TagOutline",
      "TeamFill",
      "TeamOutline",
      "TextDeletionOutline",
      "TextOutline",
      "TransportQRcodeOutline",
      "TravelOutline",
      "TruckOutline",
      "Uiwinbox",
      "UndoOutline",
      "UnlockOutline",
      "UnorderedListOutline",
      "UpCircleOutline",
      "UpOutline",
      "UploadOutline",
      "UserAddOutline",
      "UserCircleOutline",
      "UserContactOutline",
      "UserOutline",
      "UserSetOutline",
      "VideoOutline",
      "Y1",
      "Y10",
      "Y11",
      "Y12",
      "Y13",
      "Y14",
      "Y15",
      "Y16",
      "Y17",
      "Y18",
      "Y19",
      "Y2",
      "Y20",
      "Y21",
      "Y22",
      "Y23",
      "Y24",
      "Y25",
      "Y26",
      "Y27",
      "Y28",
      "Y29",
      "Y3",
      "Y30",
      "Y31",
      "Y32",
      "Y33",
      "Y34",
      "Y35",
      "Y36",
      "Y37",
      "Y38",
      "Y39",
      "Y4",
      "Y40",
      "Y41",
      "Y42",
      "Y43",
      "Y44",
      "Y45",
      "Y46",
      "Y47",
      "Y48",
      "Y49",
      "Y5",
      "Y50",
      "Y51",
      "Y52",
      "Y53",
      "Y54",
      "Y55",
      "Y56",
      "Y57",
      "Y58",
      "Y59",
      "Y6",
      "Y60",
      "Y61",
      "Y62",
      "Y63",
      "Y64",
      "Y65",
      "Y66",
      "Y67",
      "Y68",
      "Y69",
      "Y7",
      "Y70",
      "Y71",
      "Y72",
      "Y73",
      "Y74",
      "Y75",
      "Y76",
      "Y77",
      "Y78",
      "Y79",
      "Y8",
      "Y80",
      "Y81",
      "Y82",
      "Y83",
      "Y84",
      "Y85",
      "Y86",
      "Y87",
      "Y88",
      "Y89",
      "Y9",
      "Y90",
      "ZCheck",
      "ZCheckBox",
      "ZCheckFilling",
      "ZCheckHalf"
    ],
    default: "ApiCloudlogo"
  },
  {
    name: "color",
    tip: "\u989C\u8272",
    type: "string",
    propType: "color",
    default: "#666"
  },
  {
    name: "size",
    tip: "\u5C3A\u5BF8",
    type: "number",
    default: 32
  }
];

// packages/avm-ui/src/components/icon/icon.tsx
var classPrefix = `adm-icon`;
var name = "avm-icon";
var Icon = class extends Component {
  css = () => {
    return `
    @font-face {
      font-family: "${fontName}"; 
      src: url('https://avm-ui-icon-1313265164.cos.ap-beijing.myqcloud.com/avm-icon.ttf') format('truetype'), url('../../components/avm-ui/icon/avm-icon.ttf') format('truetype');
    }
    .${classPrefix} {font-family: ${fontName};font-size:32px;color:#666;align-self: center;}`;
  };
  render = (props2) => {
    let name2 = props2.name || props2.type;
    if (/\d/.test(name2)) {
      name2.replace(/(\d)/);
    }
    if (props2.size) {
      props2.fontSize = typeof props2.size === "number" ? props2.size + "px" : props2.size.replace("px", "") + "px";
    }
    let { code = defaultCode } = props2;
    if (name2) {
      const [{ enum: icons }] = props;
      code = icons.indexOf(name2);
      if (code === -1) {
        code = -4644;
      }
    }
    code += startUnicode;
    return <text role={classPrefix} char={name2} style={{ ...props2 }} class={`${classPrefix} ${classPrefix}-font-icon-text ${props2.class || props2.className || ""}`}>{String.fromCharCode(code) || props2.children}</text>;
  };
};
avm.define(name, Icon);

// packages/avm-ui/src/components/icon/index.ts
var Icon_default = Icon;

// packages/avm-ui/src/components/tree-select/tree-select.less
var tree_select_default = ".adm-tree-select {\n  height: 100%;\n  display: flex;\n  flex-direction: row;\n}\n.adm-tree-select-column {\n  overflow-y: auto;\n  transform: translateZ(0);\n  -webkit-transform: translateZ(0);\n}\n.adm-tree-select-column0 {\n  background: #f2f3f4;\n}\n.adm-tree-select-column1 {\n  background: #f9fafb;\n}\n.adm-tree-select-column2 {\n  background: #fff;\n}\n.adm-tree-select-item {\n  padding: 10px 0;\n  text-align: center;\n  display: flex;\n  flex-direction: row;\n  align-items: center;\n  justify-content: center;\n}\n.adm-tree-select-item-active {\n  background: #fff;\n}\n.adm-tree-select-item-normal {\n  background: transparent;\n}\n.adm-tree-select-item-text-active {\n  font-size: 15px;\n  color: #9AC200;\n  background: none;\n}\n.adm-tree-select-item-text-noactive {\n  font-size: 15px;\n  color: #333;\n  background: none;\n}\n.adm-tree-select-item-line-active {\n  height: 16px;\n  width: 3px;\n  background: #9AC200;\n  position: absolute;\n  left: 0;\n}\n.adm-tree-select-item-line-none {\n  display: none;\n}\n.adm-tree-select-checked {\n  position: absolute;\n  right: 15px;\n}\n";

// packages/avm-ui/src/components/tree-select/tree-select.tsx
var classPrefix2 = `adm-tree-select`;
var defaultProps = {
  options: [],
  fieldNames: {},
  defaultValue: []
};
var TreeSelect = class extends Component {
  data = {
    value: "",
    defaultValue: ""
  };
  setValue = (value) => {
    this.data.value = value;
  };
  render = (props2) => {
    props2 = Object.assign({}, defaultProps, props2);
    this.data.defaultValue = props2.defaultValue;
    const labelName = props2.fieldNames.label || "label";
    const valueName = props2.fieldNames.value || "value";
    const childrenName = props2.fieldNames.children || "children";
    const [deep, optionsMap, optionsParentMap] = (() => {
      const deep2 = getTreeDeep(props2.options, childrenName);
      const optionsMap2 = /* @__PURE__ */ new Map();
      const optionsParentMap2 = /* @__PURE__ */ new Map();
      function traverse(current, children) {
        children.forEach((item) => {
          optionsParentMap2.set(item[valueName], current);
          optionsMap2.set(item[valueName], item);
          if (item[childrenName]) {
            traverse(item, item[childrenName]);
          }
        });
      }
      traverse(void 0, props2.options);
      return [deep2, optionsMap2, optionsParentMap2];
    })();
    const onItemSelect = (node) => {
      const parentNodes = [];
      let current = node;
      while (current) {
        parentNodes.unshift(current);
        const next = optionsParentMap.get(current[valueName]);
        current = next;
      }
      const values = parentNodes.map((i) => i[valueName]);
      this.setValue(values);
      props2.onChange?.(values, {
        options: parentNodes
      });
    };
    const renderItems = (columnOptions = [], index) => {
      return columnOptions.map((item) => {
        const isActive = item[valueName] === this.data.value[index];
        return <div key={item[valueName]} className={classNames(isActive ? `${classPrefix2}-item-active` : `${classPrefix2}-item-normal`, `${classPrefix2}-item`)} onClick={() => {
          if (!isActive) {
            onItemSelect(item);
          }
        }}>
          {index === 0 && isActive ? <div className={`${classPrefix2}-item-line-active`} /> : null}
          <text className={classNames(isActive ? `${classPrefix2}-item-text-active` : `${classPrefix2}-item-text-noactive`)}>{item[labelName]}</text>
          {isActive && deep === 2 && index + 1 === deep ? <div className="adm-tree-select-checked"><Icon_default name="CheckOutline" size="18" color="#9AC200" /></div> : null}
        </div>;
      });
    };
    const renderColumns = () => {
      const columns = [];
      for (let i = 0; i < deep; i++) {
        let width = `${100 / deep}%`;
        if (deep === 2 && i === 0) {
          width = `33.33%`;
        }
        if (deep === 2 && i === 1) {
          width = `66.67%`;
        }
        const column = <div key={i} className={classNames(`adm-tree-select-column${i}`, `adm-tree-select-column`)} style={{ width }}>{renderItems(i === 0 ? props2.options : optionsMap?.get(this.data.value[i - 1])?.[childrenName], i)}</div>;
        columns.push(column);
      }
      return columns;
    };
    return <div className={classPrefix2}>{renderColumns()}</div>;
  };
  css = () => tree_select_default;
};

// packages/avm-ui/src/utils/attach-properties-to-component.ts
function attachPropertiesToComponent(component, properties) {
  const ret = component;
  for (const key in properties) {
    if (properties.hasOwnProperty(key)) {
      ret[key] = properties[key];
    }
  }
  return ret;
}

// packages/avm-ui/src/components/tree-select/index.ts
var tree_select_default2 = attachPropertiesToComponent(TreeSelect, {});
avm.define("avm-tree-select", TreeSelect);
export {
  tree_select_default2 as default
};
