// packages/avm-ui/src/utils/classnames.ts
function classNames(...args) {
  const cls = [];
  args.forEach((arg) => {
    if (typeof arg === "string") {
      cls.push(arg);
    } else if (Object.prototype.toString.call(arg) === "[object Object]") {
      for (const argKey in arg) {
        arg[argKey] && cls.push(argKey);
      }
    } else if (arg) {
      console.log(`arg ${arg} type not support`);
    }
  });
  return cls.join(" ");
}

// packages/avm-ui/src/utils/with-default-props.tsx
function mergeProps(defaultProps2, props) {
  return Object.assign({}, defaultProps2, props);
}

// packages/avm-ui/src/components/tabs/tabs.less
var tabs_default = ".adm-tabs {\n  position: relative;\n}\n.adm-tabs-header {\n  position: relative;\n  border-bottom: solid 1px #eee;\n}\n.adm-tabs-tab-list {\n  display: flex !important;\n  flex-wrap: nowrap;\n  justify-content: flex-start;\n  flex-direction: row;\n  align-items: center;\n  position: relative;\n  overflow-x: scroll;\n  scrollbar-width: none;\n}\n.adm-tabs-tab-list::-webkit-scrollbar {\n  display: none;\n}\n.adm-tabs-tab-wrapper {\n  flex: auto;\n  padding: 0 12px;\n}\n.adm-tabs-content {\n  padding: 12px;\n}\n.adm-tabs-header-mask {\n  position: absolute;\n  top: 0;\n  bottom: 0;\n  z-index: 1;\n  width: 30px;\n  height: 100%;\n  pointer-events: none;\n}\n.adm-tabs-header-mask-left {\n  left: 0;\n  background: linear-gradient(to right, #fff, rgba(255, 255, 255, 0));\n}\n.adm-tabs-header-mask-right {\n  right: 0;\n  background: linear-gradient(to left, #fff, rgba(255, 255, 255, 0));\n}\n.adm-tabs-tab {\n  white-space: nowrap;\n  padding: 8px 0 10px;\n  margin: 0 auto;\n  position: relative;\n  cursor: pointer;\n  color: #333;\n}\n.adm-tabs-tab-active {\n  color: #9AC200;\n}\n.adm-tabs-tab-none {\n  color: #333;\n}\n.adm-tabs-tab-disabled {\n  opacity: 0.5;\n  cursor: not-allowed;\n}\n.adm-tabs-tab-line {\n  position: absolute;\n  bottom: 0;\n  height: 2px;\n  transition: all 0.3s;\n  color: #9AC200;\n  background: #9AC200;\n}\n";

// packages/avm-ui/src/components/tabs/tabs.tsx
var classPrefix = `adm-tabs`;
var Tab = class extends Component {
};
var defaultProps = {
  activeLineMode: "auto"
};
var Tabs = class extends Component {
  data = {
    activeKey: "",
    width: 0,
    left: 0,
    scrollLeft: 0
  };
  ele = [];
  scrollEle = [];
  installed() {
    const keys = this.props.children.map((child) => child.attributes.key);
    const key = this.props.defaultActiveKey || keys[0];
    let index = keys.indexOf(key);
    if (key) {
      this.props.children?.forEach((child) => {
        if (child.key === key) {
          return;
        }
      });
    }
    this.data.activeKey = key || this.props.children[0].key;
    setTimeout(() => {
      const width = this.ele[index].getBoundingClientRect().width;
      const left = this.ele[index].getBoundingClientRect().left;
      this.data.width = width;
      this.data.left = left;
    }, 5);
  }
  scroll(e) {
    console.log(JSON.stringify(e));
    const { scrollLeft } = e.detail;
    this.data.scrollLeft = scrollLeft;
  }
  render = (p) => {
    const props = mergeProps(defaultProps, p);
    const leftMaskOpacity = 0;
    const rightMaskOpacity = 0;
    const breakPoint = props.breakPoint || 5;
    const panes = [];
    props.children.forEach((child) => {
      panes.push(child);
    });
    let allNode = panes.map((pane, index) => {
      if (!pane.attributes) {
        pane.attributes = { key: String(index) };
      }
      if (typeof pane.attributes.title === "string") {
        return <div key={pane.attributes.key} className={`${classPrefix}-tab-wrapper`}><div onClick={() => {
          const { key } = pane.attributes;
          if (pane.attributes.disabled)
            return;
          if (key === void 0 || key === null) {
            return;
          }
          this.data.width = this.ele[index].getBoundingClientRect().width;
          this.data.left = this.ele[index].getBoundingClientRect().left;
          this.data.activeKey = key.toString();
          props.onChange?.(this.data.activeKey);
        }}><span className={classNames(classNames(`${classPrefix}-tab`), {
          [`${classPrefix}-tab-active`]: pane.attributes.key === this.data.activeKey,
          [`${classPrefix}-tab-none`]: pane.attributes.key !== this.data.activeKey,
          [`${classPrefix}-tab-disabled`]: pane.attributes?.disabled || false
        })} ref={(e) => {
          this.ele.push(e);
        }} style={{ fontSize: props.titleFontSize || "17px" }}>{pane.attributes.title}</span></div></div>;
      } else {
        return <div key={pane.attributes.key} className={`${classPrefix}-tab-wrapper`}><div onClick={() => {
          const { key } = pane.attributes;
          if (pane.attributes.disabled)
            return;
          if (key === void 0 || key === null) {
            return;
          }
          this.data.width = this.ele[index].getBoundingClientRect().width;
          this.data.left = this.ele[index].getBoundingClientRect().left;
          this.data.activeKey = key.toString();
          props.onChange?.(this.data.activeKey);
        }}><div className={classNames(classNames(`${classPrefix}-tab`), {
          [`${classPrefix}-tab-active`]: pane.attributes.key === this.data.activeKey,
          [`${classPrefix}-tab-none`]: pane.attributes.key !== this.data.activeKey,
          [`${classPrefix}-tab-disabled`]: pane.attributes?.disabled || false
        })} ref={(e) => {
          this.ele.push(e);
        }} style={{ fontSize: props.titleFontSize || "17px" }}>{pane.attributes.title}</div></div></div>;
      }
    });
    return <div className={classPrefix}>
      <div className={`${classPrefix}-header`}>
        <div className={classNames(`${classPrefix}-header-mask`, `${classPrefix}-header-mask-left`)} style={{
          opacity: leftMaskOpacity
        }} />
        <div className={classNames(`${classPrefix}-header-mask`, `${classPrefix}-header-mask-right`)} style={{
          opacity: rightMaskOpacity
        }} />
        {props.children.length > breakPoint ? <scroll-view ref={(e) => {
          this.scrollEle.push(e);
        }} className={`${classPrefix}-tab-list`} scroll-x scroll-left={this.data.scrollLeft} scroll-y="false" show-scrollbar={false} onscroll={this.scroll.bind(this)}>
          <div className={`${classPrefix}-tab-line`} style={{
            width: props.activeLineMode === "fixed" ? `${props.fixedLineWidth || 30}px` : this.data.width,
            transform: props.activeLineMode === "fixed" ? `translate(${(this.data.width - (props.fixedLineWidth || 30)) / 2 + this.data.left}px, 0px)` : `translate(${this.data.left}px, 0px)`
          }} />
          {allNode}
        </scroll-view> : <div className={`${classPrefix}-tab-list`}>
          <div className={`${classPrefix}-tab-line`} style={{
            width: props.activeLineMode === "fixed" ? `${props.fixedLineWidth || 30}px` : this.data.width,
            transform: props.activeLineMode === "fixed" ? `translate(${(this.data.width - (props.fixedLineWidth || 30)) / 2 + this.data.left}px, 0px)` : `translate(${this.data.left}px, 0px)`
          }} />
          {allNode}
        </div>}
      </div>
      {panes.map((pane, index) => {
        if (pane.children === void 0) {
          return null;
        }
        if (!pane.attributes) {
          pane.attributes = { key: String(index) };
        }
        if (pane.attributes.key === this.data.activeKey) {
          return <div key={pane.attributes.key} className={`${classPrefix}-content`}><span>{pane.children}</span></div>;
        }
        if (pane.attributes.forceRender) {
          return <div key={pane.attributes.key} style={{ display: "none" }}><span>{pane.children}</span></div>;
        }
        return null;
      })}
    </div>;
  };
  css = () => tabs_default;
};

// packages/avm-ui/src/utils/attach-properties-to-component.ts
function attachPropertiesToComponent(component, properties) {
  const ret = component;
  for (const key in properties) {
    if (properties.hasOwnProperty(key)) {
      ret[key] = properties[key];
    }
  }
  return ret;
}

// packages/avm-ui/src/components/tabs/index.ts
var tabs_default2 = attachPropertiesToComponent(Tabs, {
  Tab
});
avm.define("avm-tabs", Tabs);
avm.define("avm-tabs-tab", Tab);
export {
  tabs_default2 as default
};
