// packages/avm-ui/src/utils/format-label.tsx
var checkLabelType = (ele) => {
  return Object.prototype.toString.call(ele);
};
var formatLabel = (ele, cls, style = {}) => {
  if (checkLabelType(ele) === "[object Array]") {
    return ele.map((el) => {
      return formatLabel(el, cls, style);
    });
  }
  return checkLabelType(ele) === "[object String]" ? <span className={cls} style={style}>{ele}</span> : <div className={cls} style={style}>{ele}</div>;
};

// packages/avm-ui/src/components/swiper/swiper-item.tsx
var SwiperItem = class extends Component {
  render = (props) => {
    return <swiper-item className="adm-swiper-item" onClick={() => props.handleClick && props.handleClick(props.index)} style={props.style}>{formatLabel(props.children, "adm-swiper-item-child")}</swiper-item>;
  };
};

// packages/avm-ui/src/utils/classnames.ts
function classNames(...args) {
  const cls = [];
  args.forEach((arg) => {
    if (typeof arg === "string") {
      cls.push(arg);
    } else if (Object.prototype.toString.call(arg) === "[object Object]") {
      for (const argKey in arg) {
        arg[argKey] && cls.push(argKey);
      }
    } else if (arg) {
      console.log(`arg ${arg} type not support`);
    }
  });
  return cls.join(" ");
}

// packages/avm-ui/src/components/page-indicator/page-indicator.tsx
var classPrefix = `adm-page-indicator`;
var defaultProps = {
  direction: "horizontal",
  style: {},
  color: "primary",
  total: 5,
  current: 0
};
var colorMapping = {
  primary: "#9AC200",
  white: "#fff"
};
var PageIndicator = class extends Component {
  render = (props) => {
    props = Object.assign({}, defaultProps, props);
    const {
      direction,
      dotColor = "#ddd",
      activeDotColor = ["primary", "white"].includes(props.color) ? colorMapping[props.color] : props.color,
      dotSize = "6px",
      activeDotSize = "6px",
      dotBorderRadius = "3px",
      activeDotBorderRadius = "3px",
      dotSpacing = "8px"
    } = props;
    const isHorizontal = direction === "horizontal";
    const dots = [];
    for (let i = 0; i < props.total; i++) {
      dots.push(<div key={i} className={classNames(`${classPrefix}-dot`, {
        [`${classPrefix}-dot-active`]: props.current === i
      })} style={{
        background: props.current === i ? activeDotColor : dotColor,
        width: props.current === i ? isHorizontal ? activeDotSize : dotSize : dotSize,
        height: props.current === i ? !isHorizontal ? activeDotSize : dotSize : dotSize,
        borderRadius: props.current === i ? activeDotBorderRadius : dotBorderRadius,
        marginRight: isHorizontal ? dotSpacing : 0,
        marginBottom: !isHorizontal ? dotSpacing : 0
      }} />);
    }
    return <div className={classNames(classPrefix, props.className, `${classPrefix}-${props.direction}`, `${classPrefix}-color-${props.color}`)} style={props.style}>{dots}</div>;
  };
  css = () => {
    return `
      .adm-page-indicator {
        display: flex;
        width: fit-content;
        padding:12px;
      }
      .adm-page-indicator-dot {
        display: block;
      }
      .adm-page-indicator-dot:last-child {
        margin-right: 0;
      }
      .adm-page-indicator-color-white .adm-page-indicator-dot-active {
        background: #fff;
      }
      .adm-page-indicator-horizontal {
        flex-direction: row;
      }
      .adm-page-indicator-vertical {
        flex-direction: column;
      }
    `;
  };
};

// packages/avm-ui/src/components/swiper/swiper.less
var swiper_default = ".adm-swiper-wrapper {\n  position: relative;\n}\n.adm-swiper-title {\n  padding-bottom: 12px;\n  display: flex;\n  align-items: center;\n  flex-direction: row;\n  justify-content: space-between;\n}\n.adm-swiper-title-text {\n  font-size: 16px;\n  color: #333;\n  font-weight: 500;\n}\n.adm-swiper-title-pageindicator {\n  display: flex;\n  flex-direction: row;\n  align-items: center;\n}\n.adm-swiper-title-pageindicator-current {\n  font-size: 16px;\n  color: #333;\n  font-weight: 500;\n  padding-right: 4px;\n}\n.adm-swiper-title-pageindicator-total {\n  font-size: 14px;\n  color: #999;\n}\n.adm-swiper-item {\n  align-items: center;\n  justify-content: center;\n}\n.adm-swiper-item-child {\n  width: 100%;\n  height: 100%;\n}\n.adm-swiper-pageindicator {\n  position: absolute;\n}\n.adm-swiper-pageindicator-horizontal {\n  left: 50%;\n  transform: translateX(-50%);\n}\n.adm-swiper-pageindicator-vertical {\n  left: 90%;\n  top: 50%;\n}\n.adm-swiper-wrapper {\n  height: 100%;\n}\n";

// packages/avm-ui/src/components/swiper/swiper.tsx
var classPrefix2 = `adm-swiper`;
var defaultProps2 = {
  defaultIndex: 0,
  allowTouchMove: true,
  autoplay: false,
  autoplayInterval: 3e3,
  loop: false,
  direction: "horizontal",
  slideSize: 100,
  trackOffset: 0,
  stuckAtBoundary: false
};
var Swiper = class extends Component {
  data = {
    current: this.props.defaultIndex || 0,
    timer: null
  };
  render = (props) => {
    this.props = Object.assign({}, defaultProps2, props);
    const {
      height = "120px",
      width = "100%",
      borderRadius = "0",
      autoplay,
      autoplayInterval,
      loop,
      direction,
      indexChange,
      indicatorProps,
      indicatorBottom = 0
    } = this.props;
    const swiperStyle = {
      height,
      width,
      borderRadius
    };
    let indicatorStyle = {};
    direction === "horizontal" && (indicatorStyle["bottom"] = indicatorBottom);
    const pageIndicatorEle = props.indicator === void 0 ? <div className={classNames(`${classPrefix2}-pageindicator`, `${classPrefix2}-pageindicator-${direction}`)} style={indicatorStyle}><PageIndicator {...indicatorProps} total={props.children.length} direction={direction} current={this.data.current} /></div> : props.indicator({ total: props.children.length, current: this.data.current });
    return <div className={`${classPrefix2}-wrapper`}>
      {props.title && <view className={`${classPrefix2}-title`}>
        <text className={`${classPrefix2}-title-text`}>{props.title}</text>
        <view className={`${classPrefix2}-title-pageindicator`}>
          <text className={`${classPrefix2}-title-pageindicator-current`}>{this.data.current}</text>
          <text className={`${classPrefix2}-title-pageindicator-total`}>
            {"/ "}
            {props.children.length}
          </text>
        </view>
      </view>}
      <swiper className={classPrefix2} autoplay={autoplay} interval={autoplayInterval} style={swiperStyle} circular={loop} vertical={direction === "vertical"} current={this.data.current} onChange={(e) => {
        this.data.current = e.detail.current;
        indexChange?.(this.data.current);
      }}>{props.children.map((item, index) => {
        return <SwiperItem {...item.attributes} index={index}>{item.children}</SwiperItem>;
      })}</swiper>
      {!!!props.title && pageIndicatorEle}
    </div>;
  };
  css = () => swiper_default;
};

// packages/avm-ui/src/utils/attach-properties-to-component.ts
function attachPropertiesToComponent(component, properties) {
  const ret = component;
  for (const key in properties) {
    if (properties.hasOwnProperty(key)) {
      ret[key] = properties[key];
    }
  }
  return ret;
}

// packages/avm-ui/src/components/swiper/index.ts
var swiper_default2 = attachPropertiesToComponent(Swiper, {
  Item: SwiperItem
});
avm.define("avm-swiper", Swiper);
avm.define("avm-swiper-item", SwiperItem);
export {
  swiper_default2 as default
};
