// packages/avm-ui/src/utils/to-css-length.ts
function toCSSLength(val) {
  return typeof val === "number" ? `${val}px` : val;
}

// packages/avm-ui/src/components/progress-bar/progress-bar.less
var progress_bar_default = ".adm-progress-bar {\n  width: 100%;\n  padding: 20px 15px;\n}\n.adm-progress-bar-trail {\n  width: 100%;\n}\n.adm-progress-bar-fill {\n  transition: width 0.3s;\n  height: 100%;\n}\n";

// packages/avm-ui/src/components/progress-bar/progress-bar.tsx
var classPrefix = `adm-progress-bar`;
var ProgressBar = class extends Component {
  render = (props) => {
    const back = {};
    back["height"] = toCSSLength(props.trackWidth) || "2px";
    back["borderRadius"] = toCSSLength(props.borderRadius) || "3px";
    back["backgroundColor"] = props.fillColor || "rgb(229, 229, 229)";
    const styles = {};
    styles["width"] = `${props.percent}%`;
    styles["width"] = props.percent == "0" || 0 ? `0%` : props.percent ? `${props.percent}%` : "30%";
    styles["background"] = props.trackColor || "#7FA000";
    styles["borderRadius"] = toCSSLength(props.borderRadius) || "3px";
    return <div className={classPrefix}><div className={`${classPrefix}-trail`} style={back}><div className={`${classPrefix}-fill`} style={styles} /></div></div>;
  };
  css = () => progress_bar_default;
};

// packages/avm-ui/src/components/progress-bar/index.ts
var progress_bar_default2 = ProgressBar;
avm.define("avm-progress-bar", ProgressBar);
export {
  progress_bar_default2 as default
};
