// packages/avm-ui/src/utils/shuffle.ts
function shuffle(array) {
  const result = [...array];
  for (let i = result.length; i > 0; i--) {
    const j = Math.floor(Math.random() * i);
    [result[i - 1], result[j]] = [result[j], result[i - 1]];
  }
  return result;
}

// packages/avm-ui/src/utils/with-default-props.tsx
function mergeProps(defaultProps4, props2) {
  return Object.assign({}, defaultProps4, props2);
}

// packages/avm-ui/src/utils/use-should-render.tsx
function useShouldRender(active, forceRender, destroyOnClose) {
  const initialized = active;
  if (forceRender)
    return true;
  if (active)
    return true;
  if (!initialized)
    return false;
  return !destroyOnClose;
}

// packages/avm-ui/src/components/mask/mask.tsx
var classPrefix = `adm-mask`;
var opacityRecord = {
  default: 0.55,
  thin: 0.35,
  thick: 0.75
};
var defaultProps = {
  visible: true,
  destroyOnClose: false,
  forceRender: false,
  color: "black",
  opacity: "default",
  disableBodyScroll: true,
  getContainer: null,
  stopPropagation: ["click"]
};
var Mask = class extends Component {
  render = (p) => {
    const props2 = mergeProps(defaultProps, p);
    const opacity = opacityRecord[props2.opacity] ?? props2.opacity;
    const rgb = props2.color === "white" ? "255, 255, 255" : "0, 0, 0";
    const background = `rgba(${rgb}, ${opacity})`;
    const shouldRender = useShouldRender(props2.visible, props2.forceRender, props2.destroyOnClose);
    return <div className={classPrefix} style={{
      ...props2.style,
      background,
      display: props2.visible ? "flex" : "none"
    }}>
      {props2.onMaskClick && <div className={`${classPrefix}-aria-button`} role="button" aria-label="Mask" onClick={props2.onMaskClick} />}
      <div className={`${classPrefix}-content`} onClick={props2.onMaskClick}>{shouldRender && props2.children}</div>
    </div>;
  };
  css = () => {
    return `:root {
      --adm-color-primary: #9AC200;
      --adm-color-success: #7FA000;
      --adm-color-warning: #FFA600;
      --adm-color-danger: #FA6400;
      --adm-color-white: #ffffff;
      --adm-color-weak: #999999;
      --adm-color-light: #cccccc;
      --adm-border-color: #eeeeee;
      --adm-font-size-main: 13px;
      --adm-color-text: #333333;
      --adm-font-family:
        -apple-system,
        blinkmacsystemfont,
        "Helvetica Neue",
        helvetica,
        segoe ui,
        arial,
        roboto,
        "PingFang SC",
        "miui",
        "Hiragino Sans GB",
        "Microsoft Yahei",
        sans-serif;
    }
    .adm-mask {
      --z-index: var(--adm-mask-z-index, 1000);
      position: absolute;
      top: 0;
      left: 0;
      bottom: 0;
      right: 0;
      z-index: var(--z-index);
      display: block;
      width: 100%;
      height: 100%;
    }
    .adm-mask-aria-button {
      position: absolute;
      top: 0;
      left: 0;
      z-index: 0;
      width: 100%;
      height: 100%;
    }
    .adm-mask-content {
      height: 100%;
      z-index: 1;
    }`;
  };
};

// packages/avm-ui/src/components/mask/index.ts
var Mask_default = Mask;
avm.define("avm-mask", Mask);

// packages/avm-ui/src/utils/format-label.tsx
var checkLabelType = (ele) => {
  return Object.prototype.toString.call(ele);
};
var formatLabel = (ele, cls, style = {}) => {
  if (checkLabelType(ele) === "[object Array]") {
    return ele.map((el) => {
      return formatLabel(el, cls, style);
    });
  }
  return checkLabelType(ele) === "[object String]" ? <span className={cls} style={style}>{ele}</span> : <div className={cls} style={style}>{ele}</div>;
};

// packages/avm-ui/src/utils/classnames.ts
function classNames(...args) {
  const cls = [];
  args.forEach((arg) => {
    if (typeof arg === "string") {
      cls.push(arg);
    } else if (Object.prototype.toString.call(arg) === "[object Object]") {
      for (const argKey in arg) {
        arg[argKey] && cls.push(argKey);
      }
    } else if (arg) {
      console.log(`arg ${arg} type not support`);
    }
  });
  return cls.join(" ");
}

// packages/avm-ui/src/components/icon/icon.config.json
var fontName = "avm-icon";
var startUnicode = 6e4;
var defaultCode = 8;

// packages/avm-ui/src/components/icon/icon.json
var props = [
  {
    name: "name",
    tip: "\u56FE\u6807\u540D\u79F0",
    type: "string",
    enum: [
      "AaOutline",
      "AddCircleOutline",
      "AddOutline",
      "AddSquareOutline",
      "AddressBookFill",
      "AlipayCircleFill",
      "AlipaySquareFill",
      "AntOutline",
      "ApiCloudlogo",
      "AppOutline",
      "AppstoreOutline",
      "ArrowDownCircleOutline",
      "ArrowsAltOutline",
      "AudioFill",
      "AudioMutedOutline",
      "AudioOutline",
      "BankcardOutline",
      "BellMuteOutline",
      "BellOutline",
      "BillOutline",
      "CalculatorOutline",
      "CalendarOutline",
      "CameraOutline",
      "ChatAddOutline",
      "ChatCheckOutline",
      "ChatWrongOutline",
      "CheckCircleFill",
      "CheckCircleOutline",
      "CheckOutline",
      "CheckShieldFill",
      "CheckShieldOutline",
      "ClockCircleFill",
      "ClockCircleOutline",
      "CloseCircleFill",
      "CloseCircleOutline",
      "CloseOutline",
      "CloseShieldOutline",
      "CollectMoneyOutline",
      "CompassOutline",
      "ContentOutline",
      "CouponOutline",
      "DeleteOutline",
      "DownCircleOutline",
      "DownFill",
      "DownOutline",
      "DownlandOutline",
      "EditFill",
      "EditSFill",
      "EditSOutline",
      "EnvironmentOutline",
      "ExclamationCircleFill",
      "ExclamationCircleOutline",
      "ExclamationOutline",
      "ExclamationShieldFill",
      "ExclamationShieldOutline",
      "ExclamationTriangleOutline",
      "EyeFill",
      "EyeInvisibleFill",
      "EyeInvisibleOutline",
      "EyeOutline",
      "FaceRecognitionOutline",
      "FileOutline",
      "FileWrongOutline",
      "FillinOutline",
      "FilterOutline",
      "FingerdownOutline",
      "FireFill",
      "FlagOutline",
      "FolderOutline",
      "ForbidFill",
      "FrownFill",
      "FrownOutline",
      "GiftOutline",
      "GlobalOutline",
      "HandPayCircleOutline",
      "HeartFill",
      "HeartOutline",
      "HistogramOutline",
      "InformationCircleFill",
      "InformationCircleOutline",
      "KeyOutline",
      "KoubeiFill",
      "KoubeiOutline",
      "LeftOutline",
      "LikeOutline",
      "LinkOutline",
      "LocationFill",
      "LocationOutline",
      "LockFill",
      "LockOutline",
      "LoopOutline",
      "MailFill",
      "MailOpenOutline",
      "MailOutline",
      "MessageFill",
      "MessageOutline",
      "MinusCircleOutline",
      "MinusOutline",
      "MoreOutline",
      "MovieOutline",
      "PayCircleOutline",
      "PhoneFill",
      "PhonebookFill",
      "PhonebookOutline",
      "PictureOutline",
      "PictureWrongOutline",
      "PicturesOutline",
      "PieOutline",
      "PlayOutline",
      "QuestionCircleFill",
      "QuestionCircleOutline",
      "ReceiptOutline",
      "ReceivePaymentOutline",
      "RedoOutline",
      "RightOutline",
      "ScanCodeOutline",
      "ScanningFaceOutline",
      "ScanningOutline",
      "SearchOutline",
      "SendOutline",
      "SetOutline",
      "ShopbagOutline",
      "ShrinkOutline",
      "SmileFill",
      "SmileOutline",
      "SoundMuteFill",
      "SoundMuteOutline",
      "SoundOutline",
      "StarFill",
      "StarOutline",
      "StopOutline",
      "SystemQRcodeOutline",
      "TagOutline",
      "TeamFill",
      "TeamOutline",
      "TextDeletionOutline",
      "TextOutline",
      "TransportQRcodeOutline",
      "TravelOutline",
      "TruckOutline",
      "Uiwinbox",
      "UndoOutline",
      "UnlockOutline",
      "UnorderedListOutline",
      "UpCircleOutline",
      "UpOutline",
      "UploadOutline",
      "UserAddOutline",
      "UserCircleOutline",
      "UserContactOutline",
      "UserOutline",
      "UserSetOutline",
      "VideoOutline",
      "Y1",
      "Y10",
      "Y11",
      "Y12",
      "Y13",
      "Y14",
      "Y15",
      "Y16",
      "Y17",
      "Y18",
      "Y19",
      "Y2",
      "Y20",
      "Y21",
      "Y22",
      "Y23",
      "Y24",
      "Y25",
      "Y26",
      "Y27",
      "Y28",
      "Y29",
      "Y3",
      "Y30",
      "Y31",
      "Y32",
      "Y33",
      "Y34",
      "Y35",
      "Y36",
      "Y37",
      "Y38",
      "Y39",
      "Y4",
      "Y40",
      "Y41",
      "Y42",
      "Y43",
      "Y44",
      "Y45",
      "Y46",
      "Y47",
      "Y48",
      "Y49",
      "Y5",
      "Y50",
      "Y51",
      "Y52",
      "Y53",
      "Y54",
      "Y55",
      "Y56",
      "Y57",
      "Y58",
      "Y59",
      "Y6",
      "Y60",
      "Y61",
      "Y62",
      "Y63",
      "Y64",
      "Y65",
      "Y66",
      "Y67",
      "Y68",
      "Y69",
      "Y7",
      "Y70",
      "Y71",
      "Y72",
      "Y73",
      "Y74",
      "Y75",
      "Y76",
      "Y77",
      "Y78",
      "Y79",
      "Y8",
      "Y80",
      "Y81",
      "Y82",
      "Y83",
      "Y84",
      "Y85",
      "Y86",
      "Y87",
      "Y88",
      "Y89",
      "Y9",
      "Y90",
      "ZCheck",
      "ZCheckBox",
      "ZCheckFilling",
      "ZCheckHalf"
    ],
    default: "ApiCloudlogo"
  },
  {
    name: "color",
    tip: "\u989C\u8272",
    type: "string",
    propType: "color",
    default: "#666"
  },
  {
    name: "size",
    tip: "\u5C3A\u5BF8",
    type: "number",
    default: 32
  }
];

// packages/avm-ui/src/components/icon/icon.tsx
var classPrefix2 = `adm-icon`;
var name = "avm-icon";
var Icon = class extends Component {
  css = () => {
    return `
    @font-face {
      font-family: "${fontName}"; 
      src: url('https://avm-ui-icon-1313265164.cos.ap-beijing.myqcloud.com/avm-icon.ttf') format('truetype'), url('../../components/avm-ui/icon/avm-icon.ttf') format('truetype');
    }
    .${classPrefix2} {font-family: ${fontName};font-size:32px;color:#666;align-self: center;}`;
  };
  render = (props2) => {
    let name2 = props2.name || props2.type;
    if (/\d/.test(name2)) {
      name2.replace(/(\d)/);
    }
    if (props2.size) {
      props2.fontSize = typeof props2.size === "number" ? props2.size + "px" : props2.size.replace("px", "") + "px";
    }
    let { code = defaultCode } = props2;
    if (name2) {
      const [{ enum: icons }] = props;
      code = icons.indexOf(name2);
      if (code === -1) {
        code = -4644;
      }
    }
    code += startUnicode;
    return <text role={classPrefix2} char={name2} style={{ ...props2 }} class={`${classPrefix2} ${classPrefix2}-font-icon-text ${props2.class || props2.className || ""}`}>{String.fromCharCode(code) || props2.children}</text>;
  };
};
avm.define(name, Icon);

// packages/avm-ui/src/components/icon/index.ts
var Icon_default = Icon;

// packages/avm-ui/src/components/popup/popup.tsx
var classPrefix3 = `adm-popup`;
var defaultProps2 = {
  position: "bottom",
  visible: false,
  getContainer: () => document.body,
  mask: true,
  stopPropagation: ["click"],
  bodyStyle: {},
  isTitle: false,
  titleText: "\u6807\u9898"
};
var Popup = class extends Component {
  data = {
    visible: this.props.visible
  };
  setVisible = (visible) => {
    if (visible) {
      this.props.afterShow && this.props.afterShow();
    }
    this.data.visible = visible;
  };
  render = (props2) => {
    this.props = Object.assign({}, defaultProps2, props2);
    this.data.visible = props2.visible;
    let {
      zIndex = 1e3,
      bodyClassName,
      position,
      forceRender = false,
      destroyOnClose = false,
      stopPropagation,
      handleClick,
      mask,
      maskClick,
      maskClassName,
      maskStyle,
      bodyStyle,
      children,
      isTitle,
      titleText,
      isBack,
      handleClose,
      handleBack,
      tipText,
      isFooterBtn,
      footBtnClick,
      bodyHeight,
      bodyWidth
    } = this.props;
    if (["bottom"].includes(position)) {
      !bodyHeight && (bodyHeight = "375px");
      bodyStyle = { ...bodyStyle, height: bodyHeight };
    }
    if (["top"].includes(position)) {
      !bodyHeight && (bodyHeight = "375px");
      let safeArea = `${JSON.parse(JSON.stringify(api.safeArea)).top - 16}px`;
      bodyStyle = { ...bodyStyle, height: bodyHeight, paddingTop: safeArea };
    }
    if (["left", "right"].includes(position)) {
      !bodyWidth && (bodyWidth = "311px");
      bodyStyle = { ...bodyStyle, width: bodyWidth };
    }
    if (["middle"].includes(position)) {
      !bodyWidth && !bodyHeight && (bodyWidth = "80%") && (bodyHeight = "50%");
      bodyStyle = { ...bodyStyle, width: bodyWidth, height: bodyHeight, top: "25%", left: "10%", borderRadius: "8px" };
    }
    if (["auto"].includes(position)) {
      bodyStyle = { ...bodyStyle, width: "100%", height: "auto" };
    }
    const bodyCls = classNames(`${classPrefix3}-body`, bodyClassName, `${classPrefix3}-body-position-${position}`);
    const shouldRender = useShouldRender(this.data.visible, forceRender, destroyOnClose);
    return <div className={classNames(classPrefix3, props2.className)} onClick={() => {
      handleClick && handleClick();
    }} style={{ display: this.data.visible ? "flex" : "none", zIndex }}>
      {mask && <Mask_default visible={props2.visible} onMaskClick={() => {
        maskClick && maskClick();
      }} className={maskClassName} style={maskStyle} disableBodyScroll={false} stopPropagation={stopPropagation} />}
      <div className={bodyCls} style={{
        ...bodyStyle,
        zIndex: zIndex + 10
      }}>
        {isTitle && <div className={`${classPrefix3}-title`}>
          {isBack && <div className={`${classPrefix3}-title-back`} onClick={() => {
            handleBack && handleBack();
          }}>
            <Icon_default name="LeftOutline" size="18" color="#bbb" />
            <span className={`${classPrefix3}-title-back-text`}>{"\u8FD4\u56DE"}</span>
          </div>}
          <div className={`${classPrefix3}-title-con`}>
            <span className={`${classPrefix3}-title-text`}>{titleText}</span>
            {tipText && <div title={tipText}><Icon_default name="CloseOutline" size="18" color="#bbb" /></div>}
          </div>
          <div onClick={() => {
            handleClose && handleClose();
          }}><Icon_default name="CloseOutline" size="18" color="#bbb" /></div>
        </div>}
        {shouldRender && formatLabel(children)}
        {isFooterBtn && <div className={`${classPrefix3}-footer`}><button onClick={() => {
          footBtnClick && footBtnClick();
        }} className={`${classPrefix3}-footer-btn`}>{"\u786E\u5B9A"}</button></div>}
      </div>
    </div>;
  };
  css = () => {
    return `
      .adm-popup {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
      }
      .adm-popup-body {
        position: absolute;
        background-color: #fff;
      }
      .adm-popup-body-position-bottom {
        width: 100%;
        bottom: 0;
        left: 0;
        border-radius: 12px 12px 0 0;
      }
      .adm-popup-body-position-top {
        width: 100%;
        top: 0;
        left: 0;
        border-radius: 0 0 12px 12px;
      }
      .adm-popup-body-position-left {
        height: 100%;
        top: 0;
        left: 0;
      }
      .adm-popup-body-position-right {
        height: 100%;
        top: 0;
        right: 0;
      }
      .adm-popup-title {
        display: flex;
        flex-direction: row;
        height: 50px;
        align-items: center;
        padding: 0 16px;
      }
      .adm-popup-title-con {
        flex: 1;
        display: flex;
        flex-direction: row;
        align-items: center;
        justify-content: center;
      }
      .adm-popup-title-text {
        text-align: center;
        font-size: 16px;
        color: #333330;
        font-weight: 500;
        margin-right: 6px;
      }
      .adm-popup-title-back {
        display: flex;
        flex-direction: row;
        align-items: center;
      }
      .adm-popup-title-back-text {
        font-size: 15px;
        color: #BBBBBB;
        padding-left: 8px;
      }
      .adm-popup-footer {
        position: absolute;
        bottom: 8px;
        width: 100%;
        height: 44px;
        display: flex;
        align-items: center;
        justify-content: center;
      }
      .adm-popup-footer-btn {
        width: 95%;
        height: 44px;
        background: #9AC200;
        border-radius: 4px;
        color: #fff;
        border: none;
      }
    `;
  };
};

// packages/avm-ui/src/components/popup/index.ts
var Popup_default = Popup;
avm.define("avm-popup", Popup);

// packages/avm-ui/src/components/number-keyboard/number-keyboard.tsx
var classPrefix4 = "adm-number-keyboard";
var defaultProps3 = {
  defaultVisible: false,
  randomOrder: false,
  showCloseButton: true,
  closeOnConfirm: true,
  isShowClearBtn: true,
  type: "default"
};
var NumberKeyboard = class extends Component {
  data = {
    popupBodyStyle: {
      background: "#f5f5f5"
    }
  };
  render = (props2) => {
    props2 = Object.assign({}, defaultProps3, props2);
    let {
      visible,
      title,
      getContainer,
      maskClick,
      randomOrder,
      showCloseButton,
      handleInput,
      handleDelete,
      isShowClearBtn,
      type
    } = props2;
    let confirmText;
    const keys = () => {
      const defaultKeys = ["1", "2", "3", "4", "5", "6", "7", "8", "9"];
      const keyList = randomOrder ? shuffle(defaultKeys) : defaultKeys;
      if (type === "default") {
        keyList.push("0");
        keyList.splice(9, 0, "CLOSE_KEYBOARD");
        keyList.push("BACKSPACE");
      } else if (type === "ID") {
        keyList.push("0");
        keyList.splice(9, 0, "X");
        keyList.push("BACKSPACE");
      } else if (type === "custom") {
        confirmText = "\u786E\u8BA4";
      }
      return keyList;
    };
    const onKeyPress = (key) => {
      switch (key) {
        case "BACKSPACE":
          handleDelete?.();
          break;
        case "OK":
          props2.handleConfirm?.();
          if (props2.closeOnConfirm) {
            props2.handleClose?.();
          }
          break;
        case "CLEAR":
          props2.clearAll?.();
          break;
        case "CLOSE_KEYBOARD":
          props2.handleClose?.();
          break;
        default:
          handleInput?.(key);
          break;
      }
    };
    const renderHeader = () => {
      if (!showCloseButton && !title)
        return null;
      return <div className={classNames({
        [`${classPrefix4}-header`]: !!title,
        [`${classPrefix4}-header-with-title`]: !!title,
        [`${classPrefix4}-header-no-title`]: !title
      })}>
        {title && <span> </span>}
        {title && <span className={`${classPrefix4}-title`}>{title}</span>}
        {showCloseButton && <div className={classNames(`${classPrefix4}-header-close-button`, {
          [`${classPrefix4}-header-with-title-close-button`]: !!title
        })} onClick={() => {
          props2.handleClose?.();
        }} role="button" title="CLOSE"><Icon name="DownOutline" size={22} /></div>}
      </div>;
    };
    const renderKey = (key, index) => {
      const isNumberKey = /^\d$/.test(key);
      const keyCls = classNames(`${classPrefix4}-key`, {
        [`${classPrefix4}-key-number`]: isNumberKey,
        [`${classPrefix4}-key-sign`]: !isNumberKey && key,
        [`${classPrefix4}-key-mid`]: index === 9 && !!confirmText
      });
      return <div key={key} className={keyCls} onClick={() => key && onKeyPress(key)} title={key} role="button" style={{ marginRight: (index + 1) % 3 !== 0 ? "8px" : 0 }}>{key === "BACKSPACE" ? <Icon name="TextDeletionOutline" size={22} /> : key === "CLOSE_KEYBOARD" ? <view className={`${classPrefix4}-key-text`} onClick={() => {
        props2.handleClose?.();
      }}><Icon name="CloseOutline" size={22} /></view> : <span className={`${classPrefix4}-key-text`}>{key}</span>}</div>;
    };
    return <Popup_default visible={visible} getContainer={getContainer} mask={true} bodyHeight="auto" afterClose={props2.afterClose} afterShow={props2.afterShow} className={`${classPrefix4}-popup`} bodyStyle={this.data.popupBodyStyle} maskClick={() => {
      maskClick && maskClick();
    }}><div className={classPrefix4}>
      {renderHeader()}
      <div className={`${classPrefix4}-wrapper`}>
        <div className={classNames(`${classPrefix4}-main`, {
          [`${classPrefix4}-confirmed-style`]: !!confirmText
        })}>
          {keys().map((key, index) => renderKey(key, index))}
          {type === "custom" && <div className={`${classPrefix4}-custom-keys`}>
            <span onClick={() => onKeyPress("0")} className={`${classPrefix4}-key-text-span2`}>0</span>
            {showCloseButton ? <view className={`${classPrefix4}-key-text-span1`} onClick={() => {
              props2.handleClose?.();
            }}><Icon name="CloseOutline" size={22} /></view> : <span className={`${classPrefix4}-key-text-span1`} onClick={() => onKeyPress(".")}>.</span>}
          </div>}
        </div>
        {!!confirmText && <div className={`${classPrefix4}-confirm`}>
          {isShowClearBtn && <div className={`${classPrefix4}-key-extra ${classPrefix4}-key-clear`} onClick={() => onKeyPress("CLEAR")} title="CLEAR" role="button"><text className={`${classPrefix4}-key-clear-text`}>{"\u6E05\u7A7A"}</text></div>}
          <div className={classNames(`${classPrefix4}-key-extra`, `${classPrefix4}-key-bs`, {
            [`${classPrefix4}-key-bs-hasclear`]: isShowClearBtn
          })} onClick={() => onKeyPress("BACKSPACE")} title="BACKSPACE" role="button"><Icon name="TextDeletionOutline" size={22} /></div>
          <div className={classNames(`${classPrefix4}-key-extra`, `${classPrefix4}-key-ok`, {
            [`${classPrefix4}-key-ok-hasclear`]: isShowClearBtn
          })} onClick={() => onKeyPress("OK")} role="button"><span className={`${classPrefix4}-key-ok-text`}>{confirmText}</span></div>
        </div>}
      </div>
    </div></Popup_default>;
  };
  css = () => {
    return `
      .adm-number-keyboard {
        padding: 0 0 8px 8px;
        background: #f2f3f5;
        width: 100%;
        border-radius:10px
      }
      .adm-number-keyboard-main {
        display: flex;
        flex-direction: row;
        flex-wrap: wrap;
        width: 100%;
      }
      .adm-number-keyboard-confirmed-style {
        width: 75%;
      }
      .adm-number-keyboard-popup {
        width: 100%;
        user-select: none;
        z-index: 1050;
      }
      .adm-number-keyboard-wrapper {
        display: flex;
        flex-direction: row;
        width: 100%;
      }
      .adm-number-keyboard-header {
        height: 20px;
        line-height: 20px;
        border-top: 1px solid #f5f5f5;
        display: flex;
        flex-direction: row;
        align-items: center;
        color: #999;
        padding:0 16px 0 38px;
        margin-top:10px
      }
      .adm-number-keyboard-header-close-button {
        padding: 0 12px;
        height: 34px;
        align-items: center;
        justify-content: center;
      }
      .adm-number-keyboard-header-with-title {
        font-size:16px;
        justify-content: space-between;
      }
      .adm-number-keyboard-header-no-title {
        height: 20px;
        line-height: 20px;
        border-top: 1px solid #f5f5f5;
        display: flex;
        align-items: center;
        flex-direction:column;
        color: #999;
        padding:0 16px;
        margin-top:10px
      }
      .adm-number-keyboard-header-with-title-close-button {
        padding-right: 0;
      }
      .adm-number-keyboard-title {
        color: #999;
        font-size: 16px;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
      }
      .adm-number-keyboard-confirm {
        width: 25%;
        display: flex;
        flex-direction: column;
        height: 100%;
      }
      .adm-number-keyboard-key {
        width: 31.5%;
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        height: 48px;
        box-sizing: border-box;
        border-top: 1px solid #f5f5f5;
        border-right: 1px solid #f5f5f5;
        background: #f5f5f5;
        margin-top: 8px;
      }
      .adm-number-keyboard-key-text {
        font-size: 22px;
        align-items: center;
        justify-content: center;
      }
      .adm-number-keyboard-key-mid {
        width: 63%;
      }
      .adm-number-keyboard-key-sign {
        background: #fff;
        align-items: center;
        justify-content: center;
      }
      .adm-number-keyboard-key-sign:active {
        background-color: #f2f2f2;
      }
      .adm-number-keyboard-key-extra {
        background-color: #fff;
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: 8px;
        margin-top: 8px;
        margin-left: 8px;
        margin-right: 8px;
      }
      .adm-number-keyboard-key-number {
        background-color: #fff;
      }
      .adm-number-keyboard-key-number:active {
        background-color: #f2f2f2;
      }
      .adm-number-keyboard-key-ok {
        display: flex;
        background-color: #9AC200;
        text-align: center;
        margin-top: 8px;
        align-items: center;
        justify-content: center;
        height: 104px;
      }
      .adm-number-keyboard-key-ok-text {
        color: #fff;
        font-size: 16px;
      }
      .adm-number-keyboard-key-bs {
        border-top: 1px solid #f5f5f5;
        border-bottom: 1px solid #f5f5f5;
        height: 104px;
      }
      .adm-number-keyboard-key-bs-hasclear {
        height: 48px;
      }
      .adm-number-keyboard-key-clear {
        height: 48px;
      }
      .adm-number-keyboard-key-clear-text {
        color: #333;
        font-size: 16px;
      }
      .adm-number-keyboard-custom-keys {
        flex-direction: row;
        width: 100%;
        height: auto;
      }
      .adm-number-keyboard-key-text-span2 {
        flex: 2;
        border-radius: 8px;
        height: 48px;
        background: #fff;
        margin-top: 8px;
        text-align: center;
        line-height: 48px;
        color: #333;
        font-size: 16px;
        margin-right: 8px;
      }
      .adm-number-keyboard-key-text-span1 {
        flex: 1;
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        height: 48px;
        background: #fff;
        margin-top: 8px;
        line-height: 48px;
        text-align: center;
        color: #333;
        font-size: 16px;
        margin-right: 5px;
        margin-left: 1px;
      }
    `;
  };
};

// packages/avm-ui/src/components/number-keyboard/index.ts
var number_keyboard_default = NumberKeyboard;
avm.define("avm-number-keyboard", NumberKeyboard);
export {
  number_keyboard_default as default
};
