// packages/avm-ui/src/components/loading/loading.less
var loading_default = ".adm-loading {\n  display: flex;\n  flex-direction: row;\n  align-items: center;\n}\n";

// packages/avm-ui/src/components/loading/loading.tsx
var classPrefix = `adm-loading`;
var Loading = class extends Component {
  render = (props) => {
    const { color = "#333", size = 20, iconSrc, loadingText } = props;
    const fontSize = `${size - 6}px`;
    return <div className={classPrefix}>
      {iconSrc && <img src={iconSrc} style={{ width: size, height: size, marginRight: "8px" }} />}
      {loadingText && <span style={{ color, fontSize }}>{loadingText}</span>}
    </div>;
  };
  css = () => loading_default;
};

// packages/avm-ui/src/components/loading/index.ts
var loading_default2 = Loading;
avm.define("avm-loading", Loading);
export {
  loading_default2 as default
};
