// packages/avm-ui/src/components/infinite-scroll/infinite-scroll.less
var infinite_scroll_default = ".adm-infinite-scroll {\n  width: 100%;\n  height: 100%;\n  display: flex;\n}\n.adm-infinite-scroll-loading-icon {\n  width: 16px;\n  height: 16px;\n  margin-right: 8px;\n}\n.adm-infinite-scroll-tip {\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  padding: 20px 0;\n}\n.adm-infinite-scroll-tip-con {\n  display: flex;\n  flex-direction: row;\n  align-items: center;\n  justify-content: center;\n}\n.adm-infinite-scroll-tip-text {\n  color: #999;\n  font-size: 12px;\n}\n";

// packages/avm-ui/src/components/infinite-scroll/infinite-scroll.tsx
var classPrefix = `adm-infinite-scroll`;
var InfiniteScrollContent = class extends Component {
  render = (props) => {
    return <view className={`${classPrefix}-tip`}>{props.hasMore ? <view className={`${classPrefix}-tip-con`}>
      {props.loadingIconSrc && <img src={props.loadingIconSrc} className={`${classPrefix}-loading-icon`} />}
      <span className={`${classPrefix}-tip-text`}>{props.hasMoreText || "\u52A0\u8F7D\u4E2D"}</span>
    </view> : <span className={`${classPrefix}-tip-text`}>{props.notHasMoreText || "\u6CA1\u6709\u66F4\u591A\u4E86"}</span>}</view>;
  };
};
var InfiniteScroll = class extends Component {
  render = (props) => {
    props = Object.assign({}, { threshold: 250 }, props);
    const doLoadMore = () => {
      props.hasMore && props.loadMore();
    };
    return <scroll-view scroll-y show-scrollbar={false} bounces className={classPrefix} lower-threshold={props.threshold} onscrolltolower={doLoadMore}>
      {props.children}
      <InfiniteScrollContent hasMore={props.hasMore} {...props} />
    </scroll-view>;
  };
  css = () => infinite_scroll_default;
};

// packages/avm-ui/src/components/infinite-scroll/index.ts
var infinite_scroll_default2 = InfiniteScroll;
avm.define("avm-infinite-scroll", InfiniteScroll);
export {
  infinite_scroll_default2 as default
};
