// packages/avm-ui/src/utils/attach-properties-to-component.ts
function attachPropertiesToComponent(component, properties) {
  const ret = component;
  for (const key in properties) {
    if (properties.hasOwnProperty(key)) {
      ret[key] = properties[key];
    }
  }
  return ret;
}

// packages/avm-ui/src/utils/with-default-props.tsx
function mergeProps(defaultProps5, props2) {
  return Object.assign({}, defaultProps5, props2);
}

// packages/avm-ui/src/utils/use-should-render.tsx
function useShouldRender(active, forceRender, destroyOnClose) {
  const initialized = active;
  if (forceRender)
    return true;
  if (active)
    return true;
  if (!initialized)
    return false;
  return !destroyOnClose;
}

// packages/avm-ui/src/components/mask/mask.tsx
var classPrefix = `adm-mask`;
var opacityRecord = {
  default: 0.55,
  thin: 0.35,
  thick: 0.75
};
var defaultProps = {
  visible: true,
  destroyOnClose: false,
  forceRender: false,
  color: "black",
  opacity: "default",
  disableBodyScroll: true,
  getContainer: null,
  stopPropagation: ["click"]
};
var Mask = class extends Component {
  render = (p) => {
    const props2 = mergeProps(defaultProps, p);
    const opacity = opacityRecord[props2.opacity] ?? props2.opacity;
    const rgb = props2.color === "white" ? "255, 255, 255" : "0, 0, 0";
    const background = `rgba(${rgb}, ${opacity})`;
    const shouldRender = useShouldRender(props2.visible, props2.forceRender, props2.destroyOnClose);
    return <div className={classPrefix} style={{
      ...props2.style,
      background,
      display: props2.visible ? "flex" : "none"
    }}>
      {props2.onMaskClick && <div className={`${classPrefix}-aria-button`} role="button" aria-label="Mask" onClick={props2.onMaskClick} />}
      <div className={`${classPrefix}-content`} onClick={props2.onMaskClick}>{shouldRender && props2.children}</div>
    </div>;
  };
  css = () => {
    return `:root {
      --adm-color-primary: #9AC200;
      --adm-color-success: #7FA000;
      --adm-color-warning: #FFA600;
      --adm-color-danger: #FA6400;
      --adm-color-white: #ffffff;
      --adm-color-weak: #999999;
      --adm-color-light: #cccccc;
      --adm-border-color: #eeeeee;
      --adm-font-size-main: 13px;
      --adm-color-text: #333333;
      --adm-font-family:
        -apple-system,
        blinkmacsystemfont,
        "Helvetica Neue",
        helvetica,
        segoe ui,
        arial,
        roboto,
        "PingFang SC",
        "miui",
        "Hiragino Sans GB",
        "Microsoft Yahei",
        sans-serif;
    }
    .adm-mask {
      --z-index: var(--adm-mask-z-index, 1000);
      position: absolute;
      top: 0;
      left: 0;
      bottom: 0;
      right: 0;
      z-index: var(--z-index);
      display: block;
      width: 100%;
      height: 100%;
    }
    .adm-mask-aria-button {
      position: absolute;
      top: 0;
      left: 0;
      z-index: 0;
      width: 100%;
      height: 100%;
    }
    .adm-mask-content {
      height: 100%;
      z-index: 1;
    }`;
  };
};

// packages/avm-ui/src/components/mask/index.ts
var Mask_default = Mask;
avm.define("avm-mask", Mask);

// packages/avm-ui/src/utils/get-container.ts
function resolveContainer(getContainer) {
  const container = typeof getContainer === "function" ? getContainer() : getContainer;
  return container || document.body;
}

// packages/avm-ui/src/utils/can-use-dom.ts
var canUseDom = !!(typeof window !== "undefined" && typeof document !== "undefined" && window.document && window.document.createElement);

// packages/avm-ui/src/utils/render-to-container.ts
function renderToContainer(getContainer, node) {
  if (canUseDom && getContainer) {
    const container = resolveContainer(getContainer);
    avm.render(node, container);
    return;
  }
  return node;
}

// packages/avm-ui/src/components/image-viewer/slide.tsx
var classPrefix2 = `adm-image-viewer`;
var Slide = class extends Component {
  data = {
    zoom: this.props.zoom || 1,
    touchTime: new Date()
  };
  touchEnd() {
    const delayTime = new Date().getTime() - this.data.touchTime.getTime();
    if (delayTime < 300) {
      this.props.onTap();
    }
  }
  render = (props2) => {
    const { zoom } = this.data;
    return <div className={`${classPrefix2}-slide`} onTouchMove={(e) => {
      e.stopPropagation ? e.stopPropagation() : e.cancelBubble = true;
    }}><div className={`${classPrefix2}-control`}><div className={`${classPrefix2}-image-wrapper`} style={`transform: scale(${zoom});`} ontouchstart={() => {
      this.data.touchTime = new Date();
    }} ontouchend={this.touchEnd.bind(this)}><img src={props2.image} draggable={false} /></div></div></div>;
  };
};

// packages/avm-ui/src/components/image-viewer/slides.tsx
var classPrefix3 = `adm-image-viewer`;
var Slides = class extends Component {
  data = {
    zoom: this.props.zoom || 1,
    touchTime: new Date()
  };
  touchEnd() {
    const delayTime = new Date().getTime() - this.data.touchTime.getTime();
    if (delayTime < 300) {
      this.props.onTap();
    }
  }
  render = (props2) => {
    return <swiper className={`${classPrefix3}-swiper`} onchange={(e) => {
      props2.onIndexChange({ index: e.detail.current });
    }}>{props2.images.map((image) => <swiper-item onClick={props2.onTap} className={`${classPrefix3}-swiper-item`}><img style="display: block;max-width: 100%;max-height: 100%;" src={image} draggable={false} /></swiper-item>)}</swiper>;
  };
};

// packages/avm-ui/src/components/image-viewer/image-viewer.tsx
var classPrefix4 = `adm-image-viewer`;
var defaultProps2 = {
  maxZoom: 3,
  getContainer: null,
  visible: false
};
var ImageViewer = class extends Component {
  data = {
    visible: this.props.visible || defaultProps2.visible
  };
  render = (p) => {
    const props2 = mergeProps(defaultProps2, p);
    const node = <Mask_default visible={props2.visible} disableBodyScroll={false} opacity="1"><div className={`${classPrefix4}-content`}>{props2.image && <Slide image={props2.image} onTap={() => {
      props2.onClose?.();
      props2.afterClose?.();
    }} maxZoom={props2.maxZoom} />}</div></Mask_default>;
    return renderToContainer(props2.getContainer, node);
  };
  css = () => {
    return `.adm-image-viewer-container {
      height: 100%;
      width: 100%;
      position: absolute;
    }
    .adm-image-viewer-content {
      width: 100%;
      height: 100%;
      max-height: -webkit-fill-available;
      touch-action: none;
      user-select: none;
    }
    .adm-image-viewer-slides {
      height: 100%;
      position: relative;
      z-index: 1;
      cursor: grab;
    }
    .adm-image-viewer-slides-inner {
      height: 100%;
      white-space: nowrap;
    }
    .adm-image-viewer-slide {
      position: relative;
      width: 100%;
      height: 100%;
      display: inline-block;
    }
    .adm-image-viewer-control {
      position: absolute;
      z-index: 1;
      left: 0;
      top: 0;
      width: 100%;
      height: 100%;
      cursor: grab;
    }
    .adm-image-viewer-image-wrapper {
      width: 100%;
      height: 100%;
      display: flex;
      justify-content: center;
      align-items: center;
    }
    .adm-image-viewer-image-wrapper img {
      display: block;
      max-width: 100%;
      max-height: 100%;
    }
    .adm-image-viewer-indicator {
      position: absolute;
      z-index: 2;
      left: 50%;
      top: 12px;
      transform: translateX(-50%);
      color: #e6e6e6;
      font-size: 14px;
    }
    .adm-image-viewer-swiper {
      display: flex !important;
      width: 100%;
      height: 100%;
      justify-content: center;
      align-items: center;
    }
    .adm-image-viewer-swiper-item {
      display: flex !important;
      height: 100%;
      justify-content: center;
      align-items: center;
    }`;
  };
};
var multiDefaultProps = {
  ...defaultProps2,
  defaultIndex: 0
};
var MultiImageViewer = class extends Component {
  render = (p) => {
    const props2 = mergeProps(multiDefaultProps, p);
    const node = <Mask_default visible={props2.visible} disableBodyScroll={false} opacity="thick" afterClose={props2.afterClose}><div className={`${classPrefix4}-content`}>{props2.images && <Slides images={props2.images} onTap={() => {
      props2.onClose?.();
    }} onIndexChange={(e) => {
      props2.onIndexChange?.(e);
    }} maxZoom={props2.maxZoom} />}</div></Mask_default>;
    return renderToContainer(props2.getContainer, node);
  };
  css = () => {
    return `.adm-image-viewer-container {
      height: 100%;
      width: 100%;
      position: absolute;
    }
    .adm-image-viewer-content {
      width: 100%;
      height: 100%;
      max-height: -webkit-fill-available;
      touch-action: none;
      user-select: none;
    }
    .adm-image-viewer-slides {
      height: 100%;
      position: relative;
      z-index: 1;
      cursor: grab;
    }
    .adm-image-viewer-slides-inner {
      height: 100%;
      white-space: nowrap;
    }
    .adm-image-viewer-slide {
      position: relative;
      width: 100%;
      height: 100%;
      display: inline-block;
    }
    .adm-image-viewer-control {
      position: absolute;
      z-index: 1;
      left: 0;
      top: 0;
      width: 100%;
      height: 100%;
      cursor: grab;
    }
    .adm-image-viewer-image-wrapper {
      width: 100%;
      height: 100%;
      display: flex;
      justify-content: center;
      align-items: center;
    }
    .adm-image-viewer-image-wrapper img {
      display: block;
      max-width: 100%;
      max-height: 100%;
    }
    .adm-image-viewer-indicator {
      position: absolute;
      z-index: 2;
      left: 50%;
      top: 12px;
      transform: translateX(-50%);
      color: #e6e6e6;
      font-size: 14px;
    }
    .adm-image-viewer-swiper {
      display: flex !important;
      width: 100%;
      height: 100%;
      justify-content: center;
      align-items: center;
    }
    .adm-image-viewer-swiper-item {
      display: flex !important;
      height: 100%;
      justify-content: center;
      align-items: center;
    }`;
  };
};
var Wrapper = class extends Component {
  data = {
    visible: true
  };
  render = (props2) => {
    const node = <ImageViewer {...props2} visible={this.data.visible} onClose={() => {
      props2.onClose?.();
      this.data.visible = false;
    }} />;
    return node;
  };
};
function showImageViewer(props2) {
  avm.render(<Wrapper {...props2} />, "#toast-box");
}
var MultiWrapper = class extends Component {
  data = {
    visible: true
  };
  render = (props2) => {
    const node = <MultiImageViewer {...props2} visible={this.data.visible} onClose={() => {
      props2.onClose?.();
      this.data.visible = false;
    }} onChange={(e) => {
      console.log(e);
    }} />;
    return node;
  };
};
function showMultiImageViewer(props2) {
  const imageViewerContainer = document.getElementById("image-viewer-container");
  if (!imageViewerContainer) {
    const node = <div id="image-viewer-container" className={`${classPrefix4}-container`} />;
    avm.render(node, "body");
  }
  avm.render(<MultiWrapper {...props2} />, "#image-viewer-container");
}

// packages/avm-ui/src/components/image-viewer/index.ts
var Multi = attachPropertiesToComponent(MultiImageViewer, {
  show: showMultiImageViewer
});
var image_viewer_default = attachPropertiesToComponent(ImageViewer, {
  Multi,
  show: showImageViewer
});
avm.define("avm-image-viewer", ImageViewer);
avm.define("avm-image-viewer-multi", MultiImageViewer);

// packages/avm-ui/src/utils/to-css-length.ts
function toCSSLength(val) {
  return typeof val === "number" ? `${val}px` : val;
}

// packages/avm-ui/src/utils/format-label.tsx
var checkLabelType = (ele) => {
  return Object.prototype.toString.call(ele);
};
var formatLabel = (ele, cls, style = {}) => {
  if (checkLabelType(ele) === "[object Array]") {
    return ele.map((el) => {
      return formatLabel(el, cls, style);
    });
  }
  return checkLabelType(ele) === "[object String]" ? <span className={cls} style={style}>{ele}</span> : <div className={cls} style={style}>{ele}</div>;
};

// packages/avm-ui/src/components/icon/icon.config.json
var fontName = "avm-icon";
var startUnicode = 6e4;
var defaultCode = 8;

// packages/avm-ui/src/components/icon/icon.json
var props = [
  {
    name: "name",
    tip: "\u56FE\u6807\u540D\u79F0",
    type: "string",
    enum: [
      "AaOutline",
      "AddCircleOutline",
      "AddOutline",
      "AddSquareOutline",
      "AddressBookFill",
      "AlipayCircleFill",
      "AlipaySquareFill",
      "AntOutline",
      "ApiCloudlogo",
      "AppOutline",
      "AppstoreOutline",
      "ArrowDownCircleOutline",
      "ArrowsAltOutline",
      "AudioFill",
      "AudioMutedOutline",
      "AudioOutline",
      "BankcardOutline",
      "BellMuteOutline",
      "BellOutline",
      "BillOutline",
      "CalculatorOutline",
      "CalendarOutline",
      "CameraOutline",
      "ChatAddOutline",
      "ChatCheckOutline",
      "ChatWrongOutline",
      "CheckCircleFill",
      "CheckCircleOutline",
      "CheckOutline",
      "CheckShieldFill",
      "CheckShieldOutline",
      "ClockCircleFill",
      "ClockCircleOutline",
      "CloseCircleFill",
      "CloseCircleOutline",
      "CloseOutline",
      "CloseShieldOutline",
      "CollectMoneyOutline",
      "CompassOutline",
      "ContentOutline",
      "CouponOutline",
      "DeleteOutline",
      "DownCircleOutline",
      "DownFill",
      "DownOutline",
      "DownlandOutline",
      "EditFill",
      "EditSFill",
      "EditSOutline",
      "EnvironmentOutline",
      "ExclamationCircleFill",
      "ExclamationCircleOutline",
      "ExclamationOutline",
      "ExclamationShieldFill",
      "ExclamationShieldOutline",
      "ExclamationTriangleOutline",
      "EyeFill",
      "EyeInvisibleFill",
      "EyeInvisibleOutline",
      "EyeOutline",
      "FaceRecognitionOutline",
      "FileOutline",
      "FileWrongOutline",
      "FillinOutline",
      "FilterOutline",
      "FingerdownOutline",
      "FireFill",
      "FlagOutline",
      "FolderOutline",
      "ForbidFill",
      "FrownFill",
      "FrownOutline",
      "GiftOutline",
      "GlobalOutline",
      "HandPayCircleOutline",
      "HeartFill",
      "HeartOutline",
      "HistogramOutline",
      "InformationCircleFill",
      "InformationCircleOutline",
      "KeyOutline",
      "KoubeiFill",
      "KoubeiOutline",
      "LeftOutline",
      "LikeOutline",
      "LinkOutline",
      "LocationFill",
      "LocationOutline",
      "LockFill",
      "LockOutline",
      "LoopOutline",
      "MailFill",
      "MailOpenOutline",
      "MailOutline",
      "MessageFill",
      "MessageOutline",
      "MinusCircleOutline",
      "MinusOutline",
      "MoreOutline",
      "MovieOutline",
      "PayCircleOutline",
      "PhoneFill",
      "PhonebookFill",
      "PhonebookOutline",
      "PictureOutline",
      "PictureWrongOutline",
      "PicturesOutline",
      "PieOutline",
      "PlayOutline",
      "QuestionCircleFill",
      "QuestionCircleOutline",
      "ReceiptOutline",
      "ReceivePaymentOutline",
      "RedoOutline",
      "RightOutline",
      "ScanCodeOutline",
      "ScanningFaceOutline",
      "ScanningOutline",
      "SearchOutline",
      "SendOutline",
      "SetOutline",
      "ShopbagOutline",
      "ShrinkOutline",
      "SmileFill",
      "SmileOutline",
      "SoundMuteFill",
      "SoundMuteOutline",
      "SoundOutline",
      "StarFill",
      "StarOutline",
      "StopOutline",
      "SystemQRcodeOutline",
      "TagOutline",
      "TeamFill",
      "TeamOutline",
      "TextDeletionOutline",
      "TextOutline",
      "TransportQRcodeOutline",
      "TravelOutline",
      "TruckOutline",
      "Uiwinbox",
      "UndoOutline",
      "UnlockOutline",
      "UnorderedListOutline",
      "UpCircleOutline",
      "UpOutline",
      "UploadOutline",
      "UserAddOutline",
      "UserCircleOutline",
      "UserContactOutline",
      "UserOutline",
      "UserSetOutline",
      "VideoOutline",
      "Y1",
      "Y10",
      "Y11",
      "Y12",
      "Y13",
      "Y14",
      "Y15",
      "Y16",
      "Y17",
      "Y18",
      "Y19",
      "Y2",
      "Y20",
      "Y21",
      "Y22",
      "Y23",
      "Y24",
      "Y25",
      "Y26",
      "Y27",
      "Y28",
      "Y29",
      "Y3",
      "Y30",
      "Y31",
      "Y32",
      "Y33",
      "Y34",
      "Y35",
      "Y36",
      "Y37",
      "Y38",
      "Y39",
      "Y4",
      "Y40",
      "Y41",
      "Y42",
      "Y43",
      "Y44",
      "Y45",
      "Y46",
      "Y47",
      "Y48",
      "Y49",
      "Y5",
      "Y50",
      "Y51",
      "Y52",
      "Y53",
      "Y54",
      "Y55",
      "Y56",
      "Y57",
      "Y58",
      "Y59",
      "Y6",
      "Y60",
      "Y61",
      "Y62",
      "Y63",
      "Y64",
      "Y65",
      "Y66",
      "Y67",
      "Y68",
      "Y69",
      "Y7",
      "Y70",
      "Y71",
      "Y72",
      "Y73",
      "Y74",
      "Y75",
      "Y76",
      "Y77",
      "Y78",
      "Y79",
      "Y8",
      "Y80",
      "Y81",
      "Y82",
      "Y83",
      "Y84",
      "Y85",
      "Y86",
      "Y87",
      "Y88",
      "Y89",
      "Y9",
      "Y90",
      "ZCheck",
      "ZCheckBox",
      "ZCheckFilling",
      "ZCheckHalf"
    ],
    default: "ApiCloudlogo"
  },
  {
    name: "color",
    tip: "\u989C\u8272",
    type: "string",
    propType: "color",
    default: "#666"
  },
  {
    name: "size",
    tip: "\u5C3A\u5BF8",
    type: "number",
    default: 32
  }
];

// packages/avm-ui/src/components/icon/icon.tsx
var classPrefix5 = `adm-icon`;
var name = "avm-icon";
var Icon = class extends Component {
  css = () => {
    return `
    @font-face {
      font-family: "${fontName}"; 
      src: url('https://avm-ui-icon-1313265164.cos.ap-beijing.myqcloud.com/avm-icon.ttf') format('truetype'), url('../../components/avm-ui/icon/avm-icon.ttf') format('truetype');
    }
    .${classPrefix5} {font-family: ${fontName};font-size:32px;color:#666;align-self: center;}`;
  };
  render = (props2) => {
    let name2 = props2.name || props2.type;
    if (/\d/.test(name2)) {
      name2.replace(/(\d)/);
    }
    if (props2.size) {
      props2.fontSize = typeof props2.size === "number" ? props2.size + "px" : props2.size.replace("px", "") + "px";
    }
    let { code = defaultCode } = props2;
    if (name2) {
      const [{ enum: icons }] = props;
      code = icons.indexOf(name2);
      if (code === -1) {
        code = -4644;
      }
    }
    code += startUnicode;
    return <text role={classPrefix5} char={name2} style={{ ...props2 }} class={`${classPrefix5} ${classPrefix5}-font-icon-text ${props2.class || props2.className || ""}`}>{String.fromCharCode(code) || props2.children}</text>;
  };
};
avm.define(name, Icon);

// packages/avm-ui/src/components/icon/index.ts
var Icon_default = Icon;

// packages/avm-ui/src/components/image/image.less
var image_default = ".adm-image {\n  display: inline-block;\n  overflow: hidden;\n}\n.adm-image-wrapper {\n  width: 100%;\n  height: 100%;\n  align-items: center;\n  justify-content: center;\n}\n.adm-image-img {\n  z-index: 1;\n}\n.adm-image-tip {\n  position: relative;\n  background-color: #f3f3f3;\n  width: 100%;\n  height: 100%;\n  align-items: center;\n  justify-content: center;\n}\n.adm-image-placeholder-wrapper {\n  width: 100%;\n  height: 100%;\n  position: absolute;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  top: 0;\n}\n";

// packages/avm-ui/src/components/image/image.tsx
var classPrefix6 = `adm-image`;
var defaultProps3 = {
  fit: "fill",
  placeholder: <div className={`${classPrefix6}-tip`}><Icon_default name="PictureOutline" color="#ddd" /></div>,
  fallback: <div className={`${classPrefix6}-tip`}><Icon_default name="PicturesOutline" color="#ddd" /></div>
};
var Image = class extends Component {
  data = {
    loaded: false,
    failed: false
  };
  setLoaded = (status) => {
    this.data.loaded = status;
  };
  setFailed = (status) => {
    this.data.failed = status;
  };
  render = (props2) => {
    props2 = Object.assign({}, defaultProps3, props2);
    const { width = "238px", height = "165px", src, srcSet, isRound = false, isSquare = false } = props2;
    const style = {};
    style["width"] = toCSSLength(width);
    style["height"] = toCSSLength(height);
    if (isRound) {
      style["borderRadius"] = "50%";
      style["width"] = "120px";
      style["height"] = "120px";
    }
    if (isSquare) {
      style["borderRadius"] = "4px";
      style["width"] = "120px";
      style["height"] = "120px";
    }
    const renderInner = () => {
      if (this.data.failed) {
        return formatLabel(props2.fallback);
      }
      const imgs = () => <img className={`${classPrefix6}-img`} src={src} alt={props2.alt} onClick={() => {
        props2.handleClick && props2.handleClick();
      }} onLoad={() => {
        this.setLoaded(true);
      }} onError={(e) => {
        this.setFailed(true);
        props2.handleError?.(e);
      }} style={{
        objectFit: props2.fit,
        ...props2.style,
        ...style
      }} crossOrigin={props2.crossOrigin} decoding={props2.decoding} loading={props2.loading} referrerPolicy={props2.referrerPolicy} sizes={props2.sizes} srcSet={srcSet} useMap={props2.useMap} />;
      return <view className={`${classPrefix6}-wrapper`}>
        {imgs()}
        <div className={!this.data.loaded ? `${classPrefix6}-placeholder-wrapper` : ""}>{!this.data.loaded && props2.placeholder}</div>
      </view>;
    };
    return <div className={classPrefix6} style={style}>{renderInner()}</div>;
  };
  css = () => image_default;
};

// packages/avm-ui/src/components/image/index.ts
var Image_default = Image;
avm.define("avm-image", Image);

// packages/avm-ui/src/components/loading/loading.less
var loading_default = ".adm-loading {\n  display: flex;\n  flex-direction: row;\n  align-items: center;\n}\n";

// packages/avm-ui/src/components/loading/loading.tsx
var classPrefix7 = `adm-loading`;
var Loading = class extends Component {
  render = (props2) => {
    const { color = "#333", size = 20, iconSrc, loadingText } = props2;
    const fontSize = `${size - 6}px`;
    return <div className={classPrefix7}>
      {iconSrc && <img src={iconSrc} style={{ width: size, height: size, marginRight: "8px" }} />}
      {loadingText && <span style={{ color, fontSize }}>{loadingText}</span>}
    </div>;
  };
  css = () => loading_default;
};

// packages/avm-ui/src/components/loading/index.ts
var Loading_default = Loading;
avm.define("avm-loading", Loading);

// packages/avm-ui/src/utils/classnames.ts
function classNames(...args) {
  const cls = [];
  args.forEach((arg) => {
    if (typeof arg === "string") {
      cls.push(arg);
    } else if (Object.prototype.toString.call(arg) === "[object Object]") {
      for (const argKey in arg) {
        arg[argKey] && cls.push(argKey);
      }
    } else if (arg) {
      console.log(`arg ${arg} type not support`);
    }
  });
  return cls.join(" ");
}

// packages/avm-ui/src/components/image-uploader/preview-item.tsx
var classPrefix8 = `adm-image-uploader`;
var PreviewItem = class extends Component {
  render = (props2) => {
    const { url, deletable, onDelete, cellSizeStyle } = props2;
    const renderLoading = () => {
      return props2.status === "pending" && <div className={`${classPrefix8}-cell-mask`}><span className={`${classPrefix8}-cell-loading`}>
        <Loading_default color="#fff" />
        <span className={`${classPrefix8}-cell-mask-message`}>{"\u4E0A\u4F20\u4E2D"}</span>
      </span></div>;
    };
    const renderDelete = () => {
      return deletable && <div className={`${classPrefix8}-cell-delete-wrap`} onClick={onDelete}><text className={`${classPrefix8}-cell-delete-wrap-inner`}>{"\u2715"}</text></div>;
    };
    return <div className={classNames(`${classPrefix8}-cell`, {
      [`${classPrefix8}-cell-fail`]: props2.status === "fail"
    })} style={cellSizeStyle}>
      <Image_default mode="aspectFill" width={cellSizeStyle.width} height={cellSizeStyle.height} className={`${classPrefix8}-cell-image`} src={url} onClick={() => {
        props2.onClick?.();
      }} />
      {renderLoading()}
      {renderDelete()}
    </div>;
  };
};

// packages/avm-ui/src/components/image-uploader/image-uploader.tsx
var classPrefix9 = `adm-image-uploader`;
var defaultProps4 = {
  disableUpload: false,
  deletable: true,
  showUpload: true,
  multiple: false,
  defaultValue: [],
  accept: "jpg",
  capture: "library"
};
var ImageUploader = class extends Component {
  data = {
    imgList: this.props.value || this.props.defaultValue || [],
    previewUrls: null,
    defaultPreviewIndex: 0,
    imageViewvisible: false,
    uploadError: false
  };
  setValue = (v) => {
    this.data.imgList = [].concat(v);
    this.props.handleChange?.(this.data.imgList);
  };
  saveImg = (imgSrc) => {
    const { maxCount } = this.props;
    const { imgList } = this.data;
    if (!maxCount || maxCount && imgList.length <= maxCount) {
      const newData = [...this.data.imgList, { url: imgSrc }];
      this.setValue(newData);
    } else {
      this.props.countExceed?.();
    }
  };
  selectPicture = () => {
    try {
      api.getPicture({
        sourceType: this.props.capture,
        encodingType: this.props.accept,
        mediaValue: "pic",
        destinationType: "url",
        quality: 50,
        targetWidth: 100,
        targetHeight: 100
      }, (ret, err) => {
        if (ret) {
          if (this.props.beforeUpload) {
            new Promise((resolve, reject) => {
              const status = this.props.beforeUpload(ret.data);
              if (status) {
                resolve(status);
              } else {
                reject(status);
              }
            }).then((res) => {
              if (res) {
                this.data.uploadError = false;
                ret.data && ret.data !== "" && this.saveImg(ret.data);
              }
            });
          } else {
            this.data.uploadError = false;
            ret.data && ret.data !== "" && this.saveImg(ret.data);
          }
        } else {
          api.toast({
            msg: "\u4E0A\u4F20\u5931\u8D25" + err
          });
          this.data.uploadError = true;
        }
      });
    } catch (err) {
      api.toast({
        msg: JSON.stringify(err)
      });
      this.data.uploadError = true;
    }
  };
  render = (props2) => {
    props2 = Object.assign({}, defaultProps4, props2);
    this.data.previewUrls = this.data.imgList.map((fileItem) => fileItem.url);
    const { maxCount, onPreview, cellSize = "109px", gap = "8px", isSureDelete } = props2;
    const cellSizeStyle = {
      width: cellSize,
      height: cellSize,
      marginRight: gap,
      marginBottom: gap
    };
    const previewImage = (index) => {
      this.data.defaultPreviewIndex = index;
      onPreview?.(index);
    };
    const showUpload = props2.showUpload && (!maxCount || maxCount && this.data.imgList.length < maxCount);
    return <div className={classPrefix9}>
      <div className={`${classPrefix9}-wrapper`}>
        {this.data.imgList.map((fileItem, index) => <PreviewItem cellSizeStyle={cellSizeStyle} url={fileItem.url} deletable={props2.deletable} onClick={() => previewImage(index)} onDelete={() => {
          if (isSureDelete) {
            api.confirm({
              title: "\u63D0\u793A",
              msg: "\u662F\u5426\u8981\u786E\u8BA4\u5220\u9664?",
              buttons: ["\u786E\u5B9A", "\u53D6\u6D88"]
            }, (ret) => {
              if (ret.buttonIndex === 1) {
                const canDelete = props2.handleDelete?.(fileItem);
                if (canDelete === false)
                  return;
                this.setValue(this.data.imgList.filter((x) => x.url !== fileItem.url));
              }
            });
          } else {
            const canDelete = props2.handleDelete?.(fileItem);
            if (canDelete === false)
              return;
            this.setValue(this.data.imgList.filter((x) => x.url !== fileItem.url));
          }
        }} />)}
        {showUpload && <div className={classNames(`${classPrefix9}-cell ${classPrefix9}-btn-wrap`, {
          [`${classPrefix9}-btn-wrap-disabled`]: props2.disableUpload,
          [`${classPrefix9}-btn-wrap-upload-error`]: this.data.uploadError
        })} style={cellSizeStyle} onClick={() => {
          !props2.disableUpload && this.selectPicture();
        }}>{!this.data.uploadError ? props2.uploadIcon ? props2.uploadIcon.children ? props2.uploadIcon : <img src={props2.uploadIcon} width={32} height={32} /> : <view className={`${classPrefix9}-btn-wrap-img`} style={{ width: cellSizeStyle.width, height: cellSizeStyle.height }}><Icon name="AddSquareOutline" color="#ddd" size={32} width="32px" height="32px" /></view> : <div className={`${classPrefix9}-error-wrapper`} style={{ width: cellSizeStyle.width, height: cellSizeStyle.height }}>
          <span className={`${classPrefix9}-error-wrapper-close`}>{"\u2715"}</span>
          <span className={`${classPrefix9}-error-wrapper-text`}>{"\u4E0A\u4F20\u5931\u8D25"}</span>
          <span className={`${classPrefix9}-error-wrapper-text`}>{"\u91CD\u65B0\u4E0A\u4F20"}</span>
        </div>}</div>}
      </div>
      <image_viewer_default.Multi images={this.data.previewUrls} visible={this.data.imageViewvisible} onClose={() => this.data.imageViewvisible = false} />
      <text className={`${classPrefix9}-tip-desc`}>{props2.tipDesc}</text>
    </div>;
  };
  css = () => {
    return `
    .adm-image-uploader-wrapper {
      display: flex;
      flex-wrap: wrap;
      flex-direction: row;
      width: auto;
      height: auto;
    }
    .adm-image-uploader-cell {
      border-radius: 4px;
      overflow: hidden;
      width: auto;
      height: auto;
    }
    .adm-image-uploader-cell-fail {
      border: 1px solid #f00;
      box-sizing: border-box;
    }
    .adm-image-uploader-cell-delete-wrap {
      width: 14.5px;
      height: 14.5px;
      position: absolute;
      top: 4.8px;
      right: 4.8px;
      z-index: 7;
      background: rgba(0, 0, 0, 0.5);
      border-radius: 50%;
      align-items: center;
      justify-content: center;
    }
    .adm-image-uploader-cell-delete-wrap-inner {
      font-size: 8px;
      color: #fff;
    }
    .adm-image-uploader-cell-mask {
      position: absolute;
      top: 0;
      right: 0;
      bottom: 0;
      left: 0;
      color: #fff;
      background-color: rgba(50, 50, 51, 0.88);
    }
    .adm-image-uploader-cell-loading {
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      height: 100%;
      font-size: 16px;
    }
    .adm-image-uploader-cell-mask-message {
      display: inline-block;
      padding: 6px 4px;
      font-size: 12px;
    }
    .adm-image-uploader-btn-wrap {
      background-color: #f5f5f5;
      text-align: center;
      align-items: center;
      justify-content: center;
    }
    .adm-image-uploader-btn-wrap-img {
      align-items: center;
      justify-content: center;
    }
    .adm-image-uploader-btn-wrap-disabled {
      opacity: 0.6;
    }
    .adm-image-uploader-btn-wrap-upload-error {
      background: rgba(0, 0, 0, 0.3);
    }
    .adm-image-uploader-tip-desc {
      font-size: 12px;
      color: #999;
      padding-top: 16px;
    }
    .adm-image-uploader-error-wrapper {
      align-items: center;
      justify-content: center;
    }
    .adm-image-uploader-error-wrapper-close {
      width: 14px;
      height: 14px;
      border-radius: 50%;
      color: #fff;
      border: 1px solid #fff;
      text-align: center;
      line-height: 14px;
      font-size: 6px;
    }
    .adm-image-uploader-error-wrapper-text {
      font-size: 12px;
      color: #fff;
      padding-top: 8px;
    }
    `;
  };
};

// packages/avm-ui/src/components/image-uploader/index.ts
var image_uploader_default = ImageUploader;
avm.define("avm-image-uploader", ImageUploader);
export {
  image_uploader_default as default
};
