// packages/avm-ui/src/components/floating-panel/floating-panel.less
var floating_panel_default = ".adm-floating-panel {\n  box-shadow: -10px 0 10px 0 #f9f9f9;\n  border-radius: 8px 8px 0 0;\n  position: absolute;\n  z-index: 900;\n  top: 100%;\n  left: 0;\n  width: 100%;\n  display: flex;\n  flex-direction: column;\n}\n.adm-floating-panel-mask {\n  display: block;\n  width: 100%;\n  height: 100%;\n  position: absolute;\n  left: 0;\n  top: -100%;\n  background: transparent;\n}\n.adm-floating-panel-header {\n  flex: none;\n  height: 28px;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  cursor: grab;\n  user-select: none;\n}\n.adm-floating-panel-bar {\n  height: 3px;\n  width: 20px;\n  border-radius: 10px;\n  background: #ccc;\n}\n.adm-floating-panel-content {\n  flex: 1;\n  overflow-y: scroll;\n}\n";

// packages/avm-ui/src/components/floating-panel/floating-panel.tsx
var FloatingPanel = class extends Component {
  data = {
    y: -200,
    startY: 0
  };
  height = this.props.height || 300;
  touchMove(e) {
    const moveY = api.platform === "mp" ? e.$_touches[0].pageY : e.detail.y;
    if (Math.abs(this.data.y) > this.height) {
      this.data.y = this.data.y - (this.data.startY - moveY) * 0.08;
    } else {
      this.data.y = this.data.y - (this.data.startY - moveY);
    }
    this.data.startY = moveY;
  }
  touchEnd() {
    let sectionArr = [];
    this.props.anchors.sort((a, b) => {
      return a - b;
    });
    try {
      this.props.anchors.forEach((item) => {
        if (item < Math.abs(this.data.y)) {
          sectionArr[0] = item;
        } else {
          sectionArr[1] = item > this.height ? this.height : item;
          throw "\u4E2D\u65AD";
        }
      });
    } catch (e) {
      if (!sectionArr[0]) {
        sectionArr[0] = -100;
      }
    }
    const medianValue = (sectionArr[1] - sectionArr[0]) / 2 + sectionArr[0];
    const y = this.data.y < -medianValue ? sectionArr[1] : sectionArr[0];
    this.data.y = -y > -100 ? -100 : -y;
  }
  render = (props) => {
    return <div ontouchstart={(e) => {
      this.data.startY = api.platform === "mp" ? e.$_touches[0].pageY : e.detail.y;
    }} ontouchmove={this.touchMove.bind(this)} ontouchend={this.touchEnd.bind(this)} ontouchcancel={this.touchEnd.bind(this)} className="adm-floating-panel" style={{
      background: `${props.background || "#fff"}`,
      height: `${props.height || 300}px`,
      transform: `translateY(${this.data.y}px)`
    }}>
      <div className="adm-floating-panel-mask" style={{
        display: "flex"
      }} />
      <div className="adm-floating-panel-header"><div className="adm-floating-panel-bar" /></div>
      <scroll-view show-scrollbar={false} bounces={false} scroll-y className="adm-floating-panel-content">{props.children}</scroll-view>
    </div>;
  };
  css = () => floating_panel_default;
};

// packages/avm-ui/src/components/floating-panel/index.ts
var floating_panel_default2 = FloatingPanel;
avm.define("avm-floating-panel", FloatingPanel);
export {
  floating_panel_default2 as default
};
