// packages/avm-ui/src/components/error-block/error-block.less
var error_block_default = ".adm-error-block {\n  box-sizing: border-box;\n  text-align: center;\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  padding-bottom: 16px;\n  background: #fff;\n}\n.adm-error-block-image {\n  max-width: 100%;\n  align-items: center;\n  justify-content: center;\n}\n.adm-error-block-description {\n  margin-top: 12px;\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n}\n.adm-error-block-description-title {\n  line-height: 1.4;\n  font-size: 15px;\n  color: #999;\n}\n.adm-error-block-description-subtitle {\n  line-height: 1.4;\n  font-size: 12px;\n  color: #999;\n  margin-top: 8px;\n  line-height: 50px;\n}\n.adm-error-block-content {\n  margin-top: 12px;\n}\n.adm-error-block-full-page {\n  margin-top: 50px;\n}\n.adm-error-block-full-page-description {\n  margin-top: 20px;\n  font-size: 13px;\n}\n.adm-error-block-full-page-description-title {\n  font-size: 20px;\n  color: #333;\n  height: 50px;\n  line-height: 50px;\n}\n";

// packages/avm-ui/src/utils/format-label.tsx
var checkLabelType = (ele) => {
  return Object.prototype.toString.call(ele);
};
var formatLabel = (ele, cls, style = {}) => {
  if (checkLabelType(ele) === "[object Array]") {
    return ele.map((el) => {
      return formatLabel(el, cls, style);
    });
  }
  return checkLabelType(ele) === "[object String]" ? <span className={cls} style={style}>{ele}</span> : <div className={cls} style={style}>{ele}</div>;
};

// packages/avm-ui/src/components/icon/icon.config.json
var fontName = "avm-icon";
var startUnicode = 6e4;
var defaultCode = 8;

// packages/avm-ui/src/components/icon/icon.json
var props = [
  {
    name: "name",
    tip: "\u56FE\u6807\u540D\u79F0",
    type: "string",
    enum: [
      "AaOutline",
      "AddCircleOutline",
      "AddOutline",
      "AddSquareOutline",
      "AddressBookFill",
      "AlipayCircleFill",
      "AlipaySquareFill",
      "AntOutline",
      "ApiCloudlogo",
      "AppOutline",
      "AppstoreOutline",
      "ArrowDownCircleOutline",
      "ArrowsAltOutline",
      "AudioFill",
      "AudioMutedOutline",
      "AudioOutline",
      "BankcardOutline",
      "BellMuteOutline",
      "BellOutline",
      "BillOutline",
      "CalculatorOutline",
      "CalendarOutline",
      "CameraOutline",
      "ChatAddOutline",
      "ChatCheckOutline",
      "ChatWrongOutline",
      "CheckCircleFill",
      "CheckCircleOutline",
      "CheckOutline",
      "CheckShieldFill",
      "CheckShieldOutline",
      "ClockCircleFill",
      "ClockCircleOutline",
      "CloseCircleFill",
      "CloseCircleOutline",
      "CloseOutline",
      "CloseShieldOutline",
      "CollectMoneyOutline",
      "CompassOutline",
      "ContentOutline",
      "CouponOutline",
      "DeleteOutline",
      "DownCircleOutline",
      "DownFill",
      "DownOutline",
      "DownlandOutline",
      "EditFill",
      "EditSFill",
      "EditSOutline",
      "EnvironmentOutline",
      "ExclamationCircleFill",
      "ExclamationCircleOutline",
      "ExclamationOutline",
      "ExclamationShieldFill",
      "ExclamationShieldOutline",
      "ExclamationTriangleOutline",
      "EyeFill",
      "EyeInvisibleFill",
      "EyeInvisibleOutline",
      "EyeOutline",
      "FaceRecognitionOutline",
      "FileOutline",
      "FileWrongOutline",
      "FillinOutline",
      "FilterOutline",
      "FingerdownOutline",
      "FireFill",
      "FlagOutline",
      "FolderOutline",
      "ForbidFill",
      "FrownFill",
      "FrownOutline",
      "GiftOutline",
      "GlobalOutline",
      "HandPayCircleOutline",
      "HeartFill",
      "HeartOutline",
      "HistogramOutline",
      "InformationCircleFill",
      "InformationCircleOutline",
      "KeyOutline",
      "KoubeiFill",
      "KoubeiOutline",
      "LeftOutline",
      "LikeOutline",
      "LinkOutline",
      "LocationFill",
      "LocationOutline",
      "LockFill",
      "LockOutline",
      "LoopOutline",
      "MailFill",
      "MailOpenOutline",
      "MailOutline",
      "MessageFill",
      "MessageOutline",
      "MinusCircleOutline",
      "MinusOutline",
      "MoreOutline",
      "MovieOutline",
      "PayCircleOutline",
      "PhoneFill",
      "PhonebookFill",
      "PhonebookOutline",
      "PictureOutline",
      "PictureWrongOutline",
      "PicturesOutline",
      "PieOutline",
      "PlayOutline",
      "QuestionCircleFill",
      "QuestionCircleOutline",
      "ReceiptOutline",
      "ReceivePaymentOutline",
      "RedoOutline",
      "RightOutline",
      "ScanCodeOutline",
      "ScanningFaceOutline",
      "ScanningOutline",
      "SearchOutline",
      "SendOutline",
      "SetOutline",
      "ShopbagOutline",
      "ShrinkOutline",
      "SmileFill",
      "SmileOutline",
      "SoundMuteFill",
      "SoundMuteOutline",
      "SoundOutline",
      "StarFill",
      "StarOutline",
      "StopOutline",
      "SystemQRcodeOutline",
      "TagOutline",
      "TeamFill",
      "TeamOutline",
      "TextDeletionOutline",
      "TextOutline",
      "TransportQRcodeOutline",
      "TravelOutline",
      "TruckOutline",
      "Uiwinbox",
      "UndoOutline",
      "UnlockOutline",
      "UnorderedListOutline",
      "UpCircleOutline",
      "UpOutline",
      "UploadOutline",
      "UserAddOutline",
      "UserCircleOutline",
      "UserContactOutline",
      "UserOutline",
      "UserSetOutline",
      "VideoOutline",
      "Y1",
      "Y10",
      "Y11",
      "Y12",
      "Y13",
      "Y14",
      "Y15",
      "Y16",
      "Y17",
      "Y18",
      "Y19",
      "Y2",
      "Y20",
      "Y21",
      "Y22",
      "Y23",
      "Y24",
      "Y25",
      "Y26",
      "Y27",
      "Y28",
      "Y29",
      "Y3",
      "Y30",
      "Y31",
      "Y32",
      "Y33",
      "Y34",
      "Y35",
      "Y36",
      "Y37",
      "Y38",
      "Y39",
      "Y4",
      "Y40",
      "Y41",
      "Y42",
      "Y43",
      "Y44",
      "Y45",
      "Y46",
      "Y47",
      "Y48",
      "Y49",
      "Y5",
      "Y50",
      "Y51",
      "Y52",
      "Y53",
      "Y54",
      "Y55",
      "Y56",
      "Y57",
      "Y58",
      "Y59",
      "Y6",
      "Y60",
      "Y61",
      "Y62",
      "Y63",
      "Y64",
      "Y65",
      "Y66",
      "Y67",
      "Y68",
      "Y69",
      "Y7",
      "Y70",
      "Y71",
      "Y72",
      "Y73",
      "Y74",
      "Y75",
      "Y76",
      "Y77",
      "Y78",
      "Y79",
      "Y8",
      "Y80",
      "Y81",
      "Y82",
      "Y83",
      "Y84",
      "Y85",
      "Y86",
      "Y87",
      "Y88",
      "Y89",
      "Y9",
      "Y90",
      "ZCheck",
      "ZCheckBox",
      "ZCheckFilling",
      "ZCheckHalf"
    ],
    default: "ApiCloudlogo"
  },
  {
    name: "color",
    tip: "\u989C\u8272",
    type: "string",
    propType: "color",
    default: "#666"
  },
  {
    name: "size",
    tip: "\u5C3A\u5BF8",
    type: "number",
    default: 32
  }
];

// packages/avm-ui/src/components/icon/icon.tsx
var classPrefix = `adm-icon`;
var name = "avm-icon";
var Icon = class extends Component {
  css = () => {
    return `
    @font-face {
      font-family: "${fontName}"; 
      src: url('https://avm-ui-icon-1313265164.cos.ap-beijing.myqcloud.com/avm-icon.ttf') format('truetype'), url('../../components/avm-ui/icon/avm-icon.ttf') format('truetype');
    }
    .${classPrefix} {font-family: ${fontName};font-size:32px;color:#666;align-self: center;}`;
  };
  render = (props2) => {
    let name2 = props2.name || props2.type;
    if (/\d/.test(name2)) {
      name2.replace(/(\d)/);
    }
    if (props2.size) {
      props2.fontSize = typeof props2.size === "number" ? props2.size + "px" : props2.size.replace("px", "") + "px";
    }
    let { code = defaultCode } = props2;
    if (name2) {
      const [{ enum: icons }] = props;
      code = icons.indexOf(name2);
      if (code === -1) {
        code = -4644;
      }
    }
    code += startUnicode;
    return <text role={classPrefix} char={name2} style={{ ...props2 }} class={`${classPrefix} ${classPrefix}-font-icon-text ${props2.class || props2.className || ""}`}>{String.fromCharCode(code) || props2.children}</text>;
  };
};
avm.define(name, Icon);

// packages/avm-ui/src/utils/classnames.ts
function classNames(...args) {
  const cls = [];
  args.forEach((arg) => {
    if (typeof arg === "string") {
      cls.push(arg);
    } else if (Object.prototype.toString.call(arg) === "[object Object]") {
      for (const argKey in arg) {
        arg[argKey] && cls.push(argKey);
      }
    } else if (arg) {
      console.log(`arg ${arg} type not support`);
    }
  });
  return cls.join(" ");
}

// packages/avm-ui/src/components/error-block/error-block.tsx
var classPrefix2 = `adm-error-block`;
var ErrorBlockText = {
  default: {
    title: "\u9875\u9762\u9047\u5230\u4E00\u4E9B\u5C0F\u95EE\u9898",
    description: "\u5F85\u4F1A\u6765\u8BD5\u8BD5"
  },
  busy: {
    title: "\u524D\u65B9\u62E5\u5835",
    description: "\u5237\u65B0\u8BD5\u8BD5"
  },
  disconnected: {
    title: "\u7F51\u7EDC\u6709\u70B9\u5FD9",
    description: "\u52A8\u52A8\u624B\u6307\u5E2E\u5FD9\u4FEE\u590D"
  },
  empty: {
    title: "\u6CA1\u6709\u627E\u5230\u4F60\u9700\u8981\u7684\u4E1C\u897F",
    description: "\u627E\u627E\u5176\u4ED6\u7684\u5427"
  }
};
var defaultProps = {
  status: "default",
  imageWidth: "100px",
  imageHeight: "100px",
  imageWidthFullPage: "200px",
  imageHeightFullPage: "200px"
};
var ErrorBlock = class extends Component {
  render = (props2) => {
    this.props = Object.assign({}, defaultProps, props2);
    const {
      status,
      description,
      title,
      image,
      fullPage,
      children,
      imageWidth,
      imageHeight,
      imageHeightFullPage,
      imageWidthFullPage
    } = this.props;
    const contentPack = ErrorBlockText[status];
    const des = "description" in this.props ? description : contentPack.description;
    const errTitle = "title" in props2 ? title : contentPack.title;
    const imageStyles = {
      width: fullPage ? imageWidthFullPage : imageWidth,
      height: fullPage ? imageHeightFullPage : imageHeight
    };
    let imageNode = <Icon name="FrownOutline" size="80px" className={`${classPrefix2}-image-img`} color="rgb(221, 221, 221)" />;
    if (image) {
      if (typeof image === "string") {
        imageNode = <img src={image} className={`${classPrefix2}-image-img`} style={{ width: imageStyles.width, height: imageStyles.height }} />;
      } else {
        imageNode = image;
      }
    }
    const errTitleCls = classNames(`${classPrefix2}-description-title`, {
      [`${classPrefix2}-full-page-description-title`]: fullPage
    });
    return <div className={classNames(classPrefix2, {
      [`${classPrefix2}-full-page`]: fullPage
    })} style={{}}>
      <div className={`${classPrefix2}-image`} style={imageStyles}>{imageNode}</div>
      <div className={classNames(`${classPrefix2}-description`, {
        [`${classPrefix2}-full-page-description`]: fullPage
      })}>
        {formatLabel(errTitle, errTitleCls)}
        {formatLabel(des, `${classPrefix2}-description-subtitle`)}
      </div>
      {children && formatLabel(children, `${classPrefix2}-content`)}
    </div>;
  };
  css = () => error_block_default;
};

// packages/avm-ui/src/components/error-block/index.ts
var error_block_default2 = ErrorBlock;
avm.define("avm-error-block", ErrorBlock);
export {
  error_block_default2 as default
};
