// packages/avm-ui/src/utils/attach-properties-to-component.ts
function attachPropertiesToComponent(component, properties) {
  const ret = component;
  for (const key in properties) {
    if (properties.hasOwnProperty(key)) {
      ret[key] = properties[key];
    }
  }
  return ret;
}

// packages/avm-ui/src/utils/format-label.tsx
var checkLabelType = (ele) => {
  return Object.prototype.toString.call(ele);
};
var formatLabel = (ele, cls, style = {}) => {
  if (checkLabelType(ele) === "[object Array]") {
    return ele.map((el) => {
      return formatLabel(el, cls, style);
    });
  }
  return checkLabelType(ele) === "[object String]" ? <span className={cls} style={style}>{ele}</span> : <div className={cls} style={style}>{ele}</div>;
};

// packages/avm-ui/src/components/icon/icon.config.json
var fontName = "avm-icon";
var startUnicode = 6e4;
var defaultCode = 8;

// packages/avm-ui/src/components/icon/icon.json
var props = [
  {
    name: "name",
    tip: "\u56FE\u6807\u540D\u79F0",
    type: "string",
    enum: [
      "AaOutline",
      "AddCircleOutline",
      "AddOutline",
      "AddSquareOutline",
      "AddressBookFill",
      "AlipayCircleFill",
      "AlipaySquareFill",
      "AntOutline",
      "ApiCloudlogo",
      "AppOutline",
      "AppstoreOutline",
      "ArrowDownCircleOutline",
      "ArrowsAltOutline",
      "AudioFill",
      "AudioMutedOutline",
      "AudioOutline",
      "BankcardOutline",
      "BellMuteOutline",
      "BellOutline",
      "BillOutline",
      "CalculatorOutline",
      "CalendarOutline",
      "CameraOutline",
      "ChatAddOutline",
      "ChatCheckOutline",
      "ChatWrongOutline",
      "CheckCircleFill",
      "CheckCircleOutline",
      "CheckOutline",
      "CheckShieldFill",
      "CheckShieldOutline",
      "ClockCircleFill",
      "ClockCircleOutline",
      "CloseCircleFill",
      "CloseCircleOutline",
      "CloseOutline",
      "CloseShieldOutline",
      "CollectMoneyOutline",
      "CompassOutline",
      "ContentOutline",
      "CouponOutline",
      "DeleteOutline",
      "DownCircleOutline",
      "DownFill",
      "DownOutline",
      "DownlandOutline",
      "EditFill",
      "EditSFill",
      "EditSOutline",
      "EnvironmentOutline",
      "ExclamationCircleFill",
      "ExclamationCircleOutline",
      "ExclamationOutline",
      "ExclamationShieldFill",
      "ExclamationShieldOutline",
      "ExclamationTriangleOutline",
      "EyeFill",
      "EyeInvisibleFill",
      "EyeInvisibleOutline",
      "EyeOutline",
      "FaceRecognitionOutline",
      "FileOutline",
      "FileWrongOutline",
      "FillinOutline",
      "FilterOutline",
      "FingerdownOutline",
      "FireFill",
      "FlagOutline",
      "FolderOutline",
      "ForbidFill",
      "FrownFill",
      "FrownOutline",
      "GiftOutline",
      "GlobalOutline",
      "HandPayCircleOutline",
      "HeartFill",
      "HeartOutline",
      "HistogramOutline",
      "InformationCircleFill",
      "InformationCircleOutline",
      "KeyOutline",
      "KoubeiFill",
      "KoubeiOutline",
      "LeftOutline",
      "LikeOutline",
      "LinkOutline",
      "LocationFill",
      "LocationOutline",
      "LockFill",
      "LockOutline",
      "LoopOutline",
      "MailFill",
      "MailOpenOutline",
      "MailOutline",
      "MessageFill",
      "MessageOutline",
      "MinusCircleOutline",
      "MinusOutline",
      "MoreOutline",
      "MovieOutline",
      "PayCircleOutline",
      "PhoneFill",
      "PhonebookFill",
      "PhonebookOutline",
      "PictureOutline",
      "PictureWrongOutline",
      "PicturesOutline",
      "PieOutline",
      "PlayOutline",
      "QuestionCircleFill",
      "QuestionCircleOutline",
      "ReceiptOutline",
      "ReceivePaymentOutline",
      "RedoOutline",
      "RightOutline",
      "ScanCodeOutline",
      "ScanningFaceOutline",
      "ScanningOutline",
      "SearchOutline",
      "SendOutline",
      "SetOutline",
      "ShopbagOutline",
      "ShrinkOutline",
      "SmileFill",
      "SmileOutline",
      "SoundMuteFill",
      "SoundMuteOutline",
      "SoundOutline",
      "StarFill",
      "StarOutline",
      "StopOutline",
      "SystemQRcodeOutline",
      "TagOutline",
      "TeamFill",
      "TeamOutline",
      "TextDeletionOutline",
      "TextOutline",
      "TransportQRcodeOutline",
      "TravelOutline",
      "TruckOutline",
      "Uiwinbox",
      "UndoOutline",
      "UnlockOutline",
      "UnorderedListOutline",
      "UpCircleOutline",
      "UpOutline",
      "UploadOutline",
      "UserAddOutline",
      "UserCircleOutline",
      "UserContactOutline",
      "UserOutline",
      "UserSetOutline",
      "VideoOutline",
      "Y1",
      "Y10",
      "Y11",
      "Y12",
      "Y13",
      "Y14",
      "Y15",
      "Y16",
      "Y17",
      "Y18",
      "Y19",
      "Y2",
      "Y20",
      "Y21",
      "Y22",
      "Y23",
      "Y24",
      "Y25",
      "Y26",
      "Y27",
      "Y28",
      "Y29",
      "Y3",
      "Y30",
      "Y31",
      "Y32",
      "Y33",
      "Y34",
      "Y35",
      "Y36",
      "Y37",
      "Y38",
      "Y39",
      "Y4",
      "Y40",
      "Y41",
      "Y42",
      "Y43",
      "Y44",
      "Y45",
      "Y46",
      "Y47",
      "Y48",
      "Y49",
      "Y5",
      "Y50",
      "Y51",
      "Y52",
      "Y53",
      "Y54",
      "Y55",
      "Y56",
      "Y57",
      "Y58",
      "Y59",
      "Y6",
      "Y60",
      "Y61",
      "Y62",
      "Y63",
      "Y64",
      "Y65",
      "Y66",
      "Y67",
      "Y68",
      "Y69",
      "Y7",
      "Y70",
      "Y71",
      "Y72",
      "Y73",
      "Y74",
      "Y75",
      "Y76",
      "Y77",
      "Y78",
      "Y79",
      "Y8",
      "Y80",
      "Y81",
      "Y82",
      "Y83",
      "Y84",
      "Y85",
      "Y86",
      "Y87",
      "Y88",
      "Y89",
      "Y9",
      "Y90",
      "ZCheck",
      "ZCheckBox",
      "ZCheckFilling",
      "ZCheckHalf"
    ],
    default: "ApiCloudlogo"
  },
  {
    name: "color",
    tip: "\u989C\u8272",
    type: "string",
    propType: "color",
    default: "#666"
  },
  {
    name: "size",
    tip: "\u5C3A\u5BF8",
    type: "number",
    default: 32
  }
];

// packages/avm-ui/src/components/icon/icon.tsx
var classPrefix = `adm-icon`;
var name = "avm-icon";
var Icon = class extends Component {
  css = () => {
    return `
    @font-face {
      font-family: "${fontName}"; 
      src: url('https://avm-ui-icon-1313265164.cos.ap-beijing.myqcloud.com/avm-icon.ttf') format('truetype'), url('../../components/avm-ui/icon/avm-icon.ttf') format('truetype');
    }
    .${classPrefix} {font-family: ${fontName};font-size:32px;color:#666;align-self: center;}`;
  };
  render = (props2) => {
    let name2 = props2.name || props2.type;
    if (/\d/.test(name2)) {
      name2.replace(/(\d)/);
    }
    if (props2.size) {
      props2.fontSize = typeof props2.size === "number" ? props2.size + "px" : props2.size.replace("px", "") + "px";
    }
    let { code = defaultCode } = props2;
    if (name2) {
      const [{ enum: icons }] = props;
      code = icons.indexOf(name2);
      if (code === -1) {
        code = -4644;
      }
    }
    code += startUnicode;
    return <text role={classPrefix} char={name2} style={{ ...props2 }} class={`${classPrefix} ${classPrefix}-font-icon-text ${props2.class || props2.className || ""}`}>{String.fromCharCode(code) || props2.children}</text>;
  };
};
avm.define(name, Icon);

// packages/avm-ui/src/utils/classnames.ts
function classNames(...args) {
  const cls = [];
  args.forEach((arg) => {
    if (typeof arg === "string") {
      cls.push(arg);
    } else if (Object.prototype.toString.call(arg) === "[object Object]") {
      for (const argKey in arg) {
        arg[argKey] && cls.push(argKey);
      }
    } else if (arg) {
      console.log(`arg ${arg} type not support`);
    }
  });
  return cls.join(" ");
}

// packages/avm-ui/src/components/checkbox/myCheckbox.tsx
var classPrefix2 = `adm-checkbox`;
var MyCheckbox = class extends Component {
  data = {
    checked: this.props.checked
  };
  setChecked = () => {
    if (!this.props.indeterminate) {
      this.data.checked = !this.data.checked;
      this.props.onChange?.(this.data.checked);
    }
  };
  render = (props2) => {
    const {
      iconSize = "22px",
      fontSize = "16px",
      gap = "8px",
      disabled = false,
      id,
      block = false,
      isLastEle,
      isGroup,
      descIsOneLineShow,
      isTwoHeadArrange
    } = this.props;
    const boxCls = classNames(classPrefix2, {
      [`${classPrefix2}-checked`]: this.data.checked && !disabled,
      [`${classPrefix2}-disabled`]: disabled,
      [`${classPrefix2}-block`]: block,
      [`${classPrefix2}-two-headarrange`]: isTwoHeadArrange,
      [`${classPrefix2}-text-has-bottomborder`]: isTwoHeadArrange
    });
    const iconStyle = {
      width: iconSize,
      height: iconSize
    };
    const childStyles = {
      fontSize,
      paddingLeft: isTwoHeadArrange ? 0 : gap
    };
    const checkedColor = disabled ? "#ddd" : "#9AC200";
    const unCheckedColor = disabled ? "#ddd" : "#666";
    const defaultEleIcons = this.data.checked ? <Icon type="ZCheckFilling" size={iconSize} color={checkedColor} /> : props2.indeterminate ? <Icon type="ZCheckHalf" size={iconSize} color={checkedColor} /> : <Icon type="ZCheckBox" size={iconSize} color={unCheckedColor} />;
    let iconEles = defaultEleIcons;
    if (props2.icon || props2.selectedIcon) {
      iconEles = this.data.checked ? <Icon type={props2.selectedIcon || "ZCheckFilling"} size={iconSize} color={checkedColor} /> : props2.indeterminate ? <Icon type="ZCheckHalf" size={iconSize} color={checkedColor} /> : <Icon type={props2.icon || "ZCheckBox"} size={iconSize} color={unCheckedColor} />;
    }
    const textCls = classNames(`${classPrefix2}-text`, {
      [`${classPrefix2}-text-has-bottomborder`]: !isTwoHeadArrange && isGroup && !isLastEle,
      [`${classPrefix2}-desc-onelineshow`]: descIsOneLineShow
    });
    const labelContent = <view className={textCls}>
      {formatLabel(props2.children, classNames(`${classPrefix2}-text-content`, {
        [`${classPrefix2}-desc-onelineshow-content`]: descIsOneLineShow
      }), childStyles)}
      {props2.description && <span className={classNames(`${classPrefix2}-text-description`, {
        [`${classPrefix2}-desc-onelineshow-desc`]: descIsOneLineShow
      })} style={{ paddingLeft: isTwoHeadArrange ? 0 : gap }}>{props2.description}</span>}
    </view>;
    return <label className={boxCls} style={{ ...props2.style }} onClick={() => {
      !disabled && this.setChecked();
    }} id={id}>
      {!isTwoHeadArrange && iconEles}
      {props2.children && labelContent}
      {isTwoHeadArrange && iconEles}
    </label>;
  };
};

// packages/avm-ui/src/components/checkbox/checkbox.less
var checkbox_default = ".adm-checkbox {\n  display: inline-flex;\n  flex-direction: row;\n  vertical-align: text-bottom;\n  justify-content: flex-start;\n  align-items: center;\n  cursor: pointer;\n  padding: 0 16px;\n}\n.adm-checkbox-two-headarrange {\n  justify-content: space-between;\n}\n.adm-checkbox-icon {\n  border-radius: 2px;\n  color: #fff;\n  background: #fff;\n  text-align: center;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n}\n.adm-checkbox-icon-checked {\n  background: #9AC200;\n  border: 1px solid #9AC200;\n}\n.adm-checkbox-icon-disabled {\n  background: #f2f2f2;\n}\n.adm-checkbox-icon-disabled-checked {\n  background: #ddd;\n  color: #fefefe;\n}\n.adm-checkbox-icon-indeterminate {\n  border-color: #9AC200;\n}\n.adm-checkbox-block {\n  display: flex;\n}\n.adm-checkbox-content {\n  flex: none;\n}\n.adm-checkbox-text {\n  flex: 1;\n  padding-top: 15px;\n  padding-bottom: 15px;\n  display: flex;\n  flex-direction: column;\n}\n.adm-checkbox-text-has-bottomborder {\n  border-bottom: 1px solid #e8e8e8;\n}\n.adm-checkbox-text-content {\n  flex: 1;\n  flex-wrap: wrap;\n}\n.adm-checkbox-text-description {\n  flex: 1;\n  flex-wrap: wrap;\n  font-size: 12px;\n  color: #999;\n  padding-top: 8px;\n}\n.adm-checkbox-desc-onelineshow {\n  flex-direction: row;\n  align-items: center;\n  justify-content: space-between;\n}\n.adm-checkbox-desc-onelineshow-content {\n  flex: 1;\n}\n.adm-checkbox-desc-onelineshow-desc {\n  flex: none;\n  padding-top: 0;\n  font-size: 14px;\n  max-width: 100px;\n  text-align: right;\n}\n.adm-checkbox-indeterminate-text {\n  width: 10px;\n  height: 10px;\n  background: #9AC200;\n}\n";

// packages/avm-ui/src/components/checkbox/checkbox.tsx
var Checkbox = class extends Component {
  data = {
    checked: !!(this.props.defaultChecked || this.props.checked || this.props.defaultValue && this.props.defaultValue.includes(this.props.value))
  };
  setChecked = (val) => {
    if (!!!this.props.indeterminate) {
      this.data.checked = val;
      if (this.data.checked) {
        this.props.check?.(this.props.value);
      } else {
        this.props.uncheck?.(this.props.value);
      }
      this.props.handleChange?.(this.data.checked);
    }
  };
  render = (props2) => {
    const {
      label,
      disabled,
      block,
      icon,
      selectedIcon,
      value,
      id,
      iconSize,
      fontSize,
      gap,
      indeterminate,
      isLastEle = false,
      isGroup = false,
      description,
      descIsOneLineShow = false,
      isTwoHeadArrange = false
    } = props2;
    return <MyCheckbox descIsOneLineShow={descIsOneLineShow} isTwoHeadArrange={isTwoHeadArrange} description={description} indeterminate={indeterminate} isLastEle={isLastEle} isGroup={isGroup} icon={icon} selectedIcon={selectedIcon} checked={this.data.checked} value={value} onChange={(checked) => this.setChecked(checked)} disabled={disabled} id={id} iconSize={iconSize} fontSize={fontSize} gap={gap} block={block}>{props2.children.length && props2.children[0] ? props2.children : label || "\u9009\u9879"}</MyCheckbox>;
  };
  css = () => checkbox_default;
};

// packages/avm-ui/src/components/checkbox/checkboxGroup.tsx
var defaultProps = {
  disabled: false
};
var CheckboxGroup = class extends Component {
  data = {
    checkList: [],
    hasChecked: false
  };
  setCheckList = (val, props2) => {
    this.data.checkList = val;
    this.data.hasChecked = true;
    props2.handleChange?.(val);
  };
  render = (props2) => {
    props2 = Object.assign({}, defaultProps, props2);
    const { defaultValue, disabled } = props2;
    const list = props2.children.map((item) => {
      return {
        ...item.attributes,
        children: item.children
      };
    });
    if (defaultValue && !this.data.hasChecked) {
      this.data.checkList = defaultValue;
    }
    const listEle = list.map((item, index) => {
      return <Checkbox {...item} isGroup={true} isLastEle={index === list.length - 1} defaultValue={defaultValue} checkedList={this.data.checkList} disabled={item.disabled || disabled} check={(val) => {
        this.setCheckList([...this.data.checkList, val], props2);
      }} uncheck={(val) => {
        this.setCheckList(this.data.checkList.filter((v) => v !== val), props2);
      }}>{item.label}</Checkbox>;
    });
    return <div>{listEle}</div>;
  };
};

// packages/avm-ui/src/components/checkbox/index.ts
var checkbox_default2 = attachPropertiesToComponent(Checkbox, {
  Group: CheckboxGroup
});
avm.define("avm-checkbox", Checkbox);
avm.define("avm-checkbox-group", CheckboxGroup);
export {
  checkbox_default2 as default
};
