const { Uri } = require('vscode')
const vuecompiler = require('./lib/node_modules/vue-template-compiler');
const { jsFaultTolerant } = require('./lib/sfc-to-dsl/src/utils');
const { readFileSync } = require('fs');
const babylon = require('@babel/parser');
const babelTraverse = require('@babel/traverse').default;
const t = require('@babel/types');


function parseStml(uri, stat) {
	const data = readFileSync(uri.fsPath, { encoding: 'utf-8' });
	const component = formatContent(data);

	const vast = babylon.parse(component.js, {
		sourceType: 'module',
		plugins: []
	});

	collectProps(vast, uri, stat);
}

function formatContent(source) {
	const res = vuecompiler.parseComponent(source, { pad: 'space' });
	const j = res.script ? jsFaultTolerant(res.script.content) : '';
	return {
		js: j
	};

}

function collectProps(ast, uri, stat) {
	babelTraverse(ast, {
		ObjectProperty(path) {
			const parent = path.parentPath.parent;
			const name = path.node.key.name;
			if (parent && t.isExportDefaultDeclaration(parent)) {
				if (name === 'name') {
					if (t.isStringLiteral(path.node.value)) {
						const value = path.node.value.value;
						if (value && value.trim()) { // 在组件name不能为空。add by moral.li 2019/12/06
							stat[value] = uri.fsPath;
							// console.log('>>>>>>>>>>> name : ' + value + ' --- uri : ' + uri.fsPath)
						}
					}
				} else if (name === 'props') {
					path.stop();
				}
			}
		}
	});
};

exports.parseStml = parseStml;
