/* Copyright 2020 APICloud Inc. All Rights Reserved.
 

 */

'use strict';

/* Trans APICloud Tablayout to miniapp tabbar.

*/

const { 
	warn
} = require('./client');

// RGB转换为16进制.小程序只支持16进制
function colorHex(color) {
	// RGB颜色值的正则
	var reg = /^(rgb|RGB)/;
	if (reg.test(color)) {
		var strHex = "#";
		var colorArr = color.replace(/(?:\(|\)|rgba|RGBA|rgb|RGB)*/g, "").split(",");
		// 转成16进制
		for (var i = 0; i < colorArr.length; i++) {
			var hex = Number(colorArr[i]).toString(16);
			if (hex === "0") {
				hex += hex;
			}
			strHex += hex;
		}
		return strHex;
	} else {
		return color;
	}
}

// '/目录1/目录2/文件.stml' './目录1/目录2/文件.stml' 等路径格式化为 '目录1/目录2/文件'
function normalizePath(str){
	if('.' === str.charAt(0)){
		var i = str.indexOf('/');
		if(i >= 0){
			str = str.substr(i + 1);
		}
	}else if('/' === str.charAt(0)){
		str = str.substr(1);
	}
	str = str.replace('.stml', '');
	return str;
}

// 获取tablayout json中的list和frames并合成为小程序的list
function findList(tabbar) {
	if(!tabbar){
		return null;
	}
	const frames = tabbar.frames;
	const list = tabbar.list;
	if(!frames || !list || (frames.length != list.length)){
		return null;
	}
	const length = list.length;
	const LIST = [];
	for(var i = 0; i < length; ++i){
		var pagePath = normalizePath(frames[i].url);
        var iconPath = normalizePath(list[i].iconPath);
        var selectedIconPath = normalizePath(list[i].selectedIconPath);
        var text = list[i].text;
		LIST.push({pagePath, iconPath, selectedIconPath, text});
	}
	return LIST;
}

// 获取tablayout json中的tabbar公共属性对应为小程序tabbar公共属性
function findTabbar(tabbar) {
	const TABBAR = {};
	if(!tabbar){
		return TABBAR;
	}
	var color = tabbar["color"];
	var selectedColor = tabbar["selectedColor"];
	var backgroundColor = tabbar["background"];
	var borderStyle = tabbar["shadow"];
	var position = tabbar["position"];
	if(color){
		TABBAR.color = colorHex(color);
	}
	if(selectedColor){
		TABBAR.selectedColor = colorHex(selectedColor);
	}
	if(backgroundColor){
		TABBAR.backgroundColor = colorHex(backgroundColor);
	}
	if(borderStyle){
		// 小程序仅支持black和white
		if('black' != borderStyle && 'white' != borderStyle){
			borderStyle = 'black';
		}
		TABBAR.borderStyle = borderStyle;
	}
	position = 'bottom';  // app引擎目前仅支持 bottom
    TABBAR.position = position;
	return TABBAR;
}

// 获取config中所有所需信息
function makeTabbarInfo(data) {
	if(!data){
		return null;
	}
	const json = JSON.parse(data);
	if(!json || !json.tabBar){
		return null;
	}
	const Tabbar = findTabbar(json.tabBar);
	const list = findList(json.tabBar);
	if(!list){
		return null;
	}
	Tabbar.list = list;
	return Tabbar;
}

exports.makeTabbarInfo = makeTabbarInfo;