/* Copyright 2020 APICloud Inc. All Rights Reserved.
 

 */

'use strict';

const { 
	warn
} = require('./client');

// 获取config中的content src字段信息
function findContent(data) {
	if(!data){
		return null;
	}
	const PATTERN_SRC = /src="([^"]*)"/gi;
	var src = PATTERN_SRC.exec(data);
	if(src && src.length){
		var content = src[1].trim();
		if('.' === content.charAt(0)){
			var i = content.indexOf('/');
			if(i >= 0){
				return content.substr(i + 1);
			}
			return content;
		}
		if('/' === content.charAt(0)){
			return content.substr(1);
		}
		return content;
	}
	return null;
}

// 获取config中的name字段信息
function findName(data) {
	if(!data){
		return null;
	}
	const PATTERN_NAME = /<name>(.*)<\/name>/gi;
	var name = PATTERN_NAME.exec(data);
	if(name && name.length){
		return name[1].trim();
	}
	return null;
}

// 获取config中所有所需信息
function findAll(data) {
	if(!data){
		return {};
	}
	return {
		name: findName(data),
		src: findContent(data)
	};
}

exports.findAll = findAll;
exports.findContent = findContent;
exports.findName = findName;