/* Copyright 2020 APICloud Inc. All Rights Reserved.
 

 */

const path = require('path');

const { 
	extname,
	resolve,
	dirname,
	basename
} = require('path');

/**
* stml中样式和引入的外部样式，单独抽出，在build.js中处理为小程序对应页面的wxss
*/
function emitAssetFile(rollup, code, filename, isimport){
	const fname = (isimport ? 'cssimport-' : 'cssdata-') + basename(filename) + (isimport ? `[${code}]` : '');
	return rollup.emitFile({
		type: 'asset',
		source: code,
		//name: 'name',
		fileName: fname
	});
}

const importRegex = new RegExp('@import([^;]*);', 'g');

/**
* 剥离通过
	<style>
		@import '../../static/global.css';
		...
	</style>
  方式引入的外部样式
*/
function excludeImport(rollup, code, filename){
	let uniquePaths = [];
	let transformed = code.replace(importRegex, (match, p1) => {
		const paths = p1.split(/[,]/).map(p => {
				const orgName = p.trim();
				let name = orgName;
				if (name[0] === name[name.length - 1] && (name[0] === '"' || name[0] === "'")) {
					name = name.substring(1, name.length - 1);  // string quotes
				}
				// Exclude CSS @import: http://sass-lang.com/documentation/file.SASS_REFERENCE.html#import
				if (extname(name) === '.css') { 
					return name;
				}
				if (name.startsWith('http://')) {
					return name;
				}
				if (name.startsWith('url(')) { 
					return name;
				}
				return name;
		});
		uniquePaths = uniquePaths.concat(paths.filter(p => p !== null));
		if (uniquePaths.length) {
			return '';
		}
		return p1;
	});
	if (uniquePaths.length) {
		uniquePaths.reverse();// 保持import顺序
		for(var path of uniquePaths){
			const code = path;
			emitAssetFile(rollup, code, filename, true);
		}
	}
	return transformed;
}

function emitStyle(rollup, styles, filename){
	let cssStr = '';
	let cssLink = new Array();
	if(styles && styles.length > 0){	
		styles.forEach((style) => {
			if(style.content){
				const content = style.content.trim();
				const css = excludeImport(rollup, content, filename);
				cssStr += css;
			}else if(!style.content && style.src){
				// 剥离通过<style src='../../static/global.css'>方式引入的样式
				const code = style.src;
				emitAssetFile(rollup, code, filename, true);
			}
			if(style.scoped){
				// TODO 支持处理 scoped
			}
		});
	}
	if(cssStr){
		emitAssetFile(rollup, cssStr, filename, false);
	}
}

module.exports = {
	emitStyle,
	emitAssetFile
}