/* Copyright 2020 APICloud Inc. All Rights Reserved.


 */

const cssToJSON = require('./css-json');
const rollupPluginutils = require('rollup-pluginutils');
const { 
	log
} = require('./utils');

const { emitAssetFile } = require('./style-emit');

/*
* 只处理.css文件
*/
function createFilter(include = [/\.css$/i], exclude = []) {
    const filter = rollupPluginutils.createFilter(include, exclude);
    return id => filter(id);
}

/**/
function compilerToJson(options = {include: [/\.css$/i]}){

	const isCss = createFilter(options.include, options.exclude);
	const indent = 'indent' in options ? options.indent : '\t';
	const miniapp = 'miniapp' === options.platform;

	return {

		name: 'style-to-json',

		resolveId(id, importer) {
			if (!isCss(id)) {
				return;
			}
			if(miniapp && importer){
				// 
				emitAssetFile(this, id, importer, true);
			}
        },

        load(id) {

        },

		async transform(source, filename) {
			if (!isCss(filename)) {
				return null;
			}
			if(miniapp){
				// 小程序不编译引入的css，通过emitAssetFile，最后统一拷贝为wxss
				return {code: "export default '';"};
			}
			const json = cssToJSON(source);
			return {
				code: rollupPluginutils.dataToEsm(json, {
					preferConst: options.preferConst,
					compact: options.compact,
					namedExports: options.namedExports,
					indent
				}),
				map: { mappings: '' }
			};
		}
	};
}

module.exports = compilerToJson;
