/* Copyright 2020 APICloud Inc. All Rights Reserved.


 */

const t = require('@babel/types');
const { 
	log, 
	logast, 
	getIdentifier, 
	replaceThisExpression, 
	getParams, 
	getBody
} = require('./utils');

function traverseComputed(path, state, name){
	const blocks = [];
    let params = getParams(path, state);
	path.traverse({
		ThisExpression (memPath) {
			replaceThisExpression(memPath, this.state);
		}
	}, { state: state });
	const body = getBody(path, state);
	if(t.isBlockStatement(body)){
		const block = body.body;
		if(block){
			for(var i in block){
				blocks.push(block[i]);
			}
		}
	}
	const method = t.objectMethod('method', t.identifier(name), params, t.blockStatement(blocks));
	return method;
}

// computed 内容被转换为组件的compute对象，同data对象同级，vdom在运算过程中，
// 将compute所有属性挂到当前组件下，因此在代码中，使用this即可引用compute中属性
module.exports = function collectVueComputed (path, state) {
    const childs = path.node.value.properties;
    const parentKey = path.node.key.name; // computed;
    if (childs.length) {
        path.traverse({
			// 通过 key(){ } 方式写的Vue computed函数
            ObjectMethod (propPath) {
                const parentNode = propPath.parentPath.parent;
                if (parentNode.key && parentNode.key.name === parentKey) {
                    const key = propPath.node.key.name;
                    if (!state.computeds[key]) {
						const method = traverseComputed(propPath, state, key);
						state.computeds[key] = method;
                    }
                }
            },
			// 收集通过 key:function(){ } 方式写的Vue computed函数
			ObjectProperty (propPath){
				const key = propPath.node.key.name;
				if (!state.computeds[key]) {
					const method = traverseComputed(propPath, state, key);
					state.computeds[key] = method;
				}
			}
        });
    }
};
