/* Copyright 2020 APICloud Inc. All Rights Reserved.


 */

const t = require('@babel/types');
const { 
	log, 
	logast, 
	getIdentifier, 
	replaceThisExpression, 
	getParams, 
	getBody
} = require('./utils');

// 将来自export default中定义的任意函数以及methods下函数收集，并做this兼容处理
function createClassMethod (path, state, name) {
	//logast('createClassMethod: ', path.node);
    const blocks = [];
    let params = getParams(path, state);
	path.traverse({
		ThisExpression (memPath) {
			// logast('createClassMethod: ' + name + ', ', memPath.node);
			// this.xxx 转this.data.xxx或者this.props.xxx
			replaceThisExpression(memPath, this.state);
		}
	}, { state: state });
	const body = getBody(path, state);
	if(t.isBlockStatement(body)){
		const block = body.body;
		if(block){
			for(var i in block){
				blocks.push(block[i]);
			}
		}
	}
    return t.classMethod('method', t.identifier(name), params, t.blockStatement(blocks));
}

function replaceThisExpression$1 (path, key, state) {
    if (state.data[key] || state.props[key]) {
        path.replaceWith(
            t.memberExpression(t.thisExpression(), getIdentifier(state, key))
        );
    } else {
        // from computed
        path.parentPath.replaceWith(
            t.identifier(key)
        );
    }
    path.stop();
}

function createRenderMethod (path, state, name) {
    if (path.node.params.length) {
        log(`
            Maybe you will call $.createElement or h method in your render, but avm does not support it.
            And it's maybe cause some unknown error in transforming
        `);
    }
    path.traverse({
        ThisExpression (thisPath) {
            const parentNode = thisPath.parentPath.parentPath.parent;
            const isValid = t.isExpressionStatement(parentNode) || 
                t.isVariableDeclaration(parentNode) ||
                t.isBlockStatement(parentNode) || 
                t.isJSXElement(parentNode) || 
                t.isCallExpression(parentNode) || 
                (t.isJSXAttribute(parentNode) && !parentNode.name.name.startsWith('on'));

            if (isValid) {
                // prop
                const key = thisPath.parent.property.name;
                replaceThisExpression$1(thisPath, key, state);
            }
        },
        JSXAttribute (attrPath) {
            const attrNode = attrPath.node;
            if (attrNode.name.name === 'class') {
                attrPath.replaceWith(
                    t.jSXAttribute(t.jSXIdentifier('className'), attrNode.value)
                );
            }

            if (attrNode.name.name === 'domPropsInnerHTML') {
                const v = attrNode.value;
                if (t.isLiteral(v)) {
                    attrPath.replaceWith(
                        t.jSXAttribute(
                            t.jSXIdentifier('dangerouslySetInnerHTML'), 
                            t.jSXExpressionContainer(t.objectExpression([t.objectProperty(t.identifier('__html'), attrNode.value)]))
                        )
                    );
                } else if (t.isJSXExpressionContainer(v)) {
                    const expression = v.expression;
                    if (t.isMemberExpression(expression)) {
                        attrPath.traverse({
                            ThisExpression (thisPath) {
                                const key = thisPath.parent.property.name;
                                replaceThisExpression$1(thisPath, key, state);
                            }
                        });
                    }
                    attrPath.replaceWith(
                        t.jSXAttribute(
                            t.jSXIdentifier('dangerouslySetInnerHTML'), 
                            t.jSXExpressionContainer(t.objectExpression([t.objectProperty(t.identifier('__html'), expression)]))
                        )
                    );
                }
            }
        }
    });
    let blocks = [];
	/*
    // computed props
    const computedProps = Object.keys(state.computeds);
    if (computedProps.length) {
        computedProps.forEach(prop => {
            const v = state.computeds[prop];
            blocks = blocks.concat(v['_statements']);
        });
    }
	*/
    blocks = blocks.concat(path.node.body.body);
    return t.classMethod('method', t.identifier(name), [], t.blockStatement(blocks));
}

exports.collectCycleMethods = function collectCycleMethods (path, collect, state, name, cycleName, isSFC) {
    if (name === 'render') {
        if (isSFC) {
            return;
        }
        collect.classMethods[cycleName] = createRenderMethod(path, state, name);
    } else {
        collect.classMethods[cycleName] = createClassMethod(path, state, cycleName);
    }
};

exports.collectGeneralMethods = function collectGeneralMethods (path, collect, state, name) {
    collect.classMethods[name] = createClassMethod(path, state, name);
};

exports.isGeneralMethods = function isGeneralMethods(path){
	// 该方法只查询上一个父节点
	return path.parentPath.parent.key && path.parentPath.parent.key.name === 'methods';
	
	/* 该方法向顶部查询，直到符合条件的节点，会引起误判
	const method = path.findParent(function(p){
		if(p.isObjectProperty()){
			if(p.node.key.name === 'methods'){
				return true;
			}
		}
		return false;
	});
	return method;
	*/
}
