/* Copyright 2020 APICloud Inc. All Rights Reserved.


 */

const RECYCLERS_CELLS = {
    'cell': 'cell',
    'swiper-item': 'swiper-item'
};

const RECYCLERS_COMPONENTS = {
    'swiper': true,
    'list-view': true,
	'grid-view': true
};

/**
*  是否是cell类型节点
*/
exports.isCell = function(name) {
    return RECYCLERS_CELLS[name];
}

/**
*  是否是子元素可回收类型组件，例如 list-view、grid-view 等
*/
exports.isRecycler = function(name) {
    return RECYCLERS_COMPONENTS[name];
}

/*
module.exports = {
    'cell': 'cell',
    'swiper-item': 'swiper-item'
};
*/
