/* Copyright 2020 APICloud Inc. All Rights Reserved.
 

 */

// 根据收集的Vue组件数据，导出新的符合apivm.js组件规范的代码

const t = require('@babel/types');
const { genDefaultProps, genPropTypes } = require('./utils');

exports.genImports = function genImports (path, collect, state) {
    const nodeLists = path.node.body;
    collect.imports.forEach(node => nodeLists.unshift(node));
};

exports.genConstructor = function genConstructor (path, state) {
    const nodeLists = path.node.body;
    const blocks = [
        t.expressionStatement(t.callExpression(t.super(), [t.identifier('props')]))
    ];
	// 导出data到组件的this.data
    if (state.data['_statements']) {
        state.data['_statements'].forEach(node => {
            if (t.isReturnStatement(node)) {
                const props = node.argument.properties;
                // supports init data property with props property
                props.forEach(n => {
                    if (t.isMemberExpression(n.value)) {
                        n.value = t.memberExpression(t.identifier('props'), t.identifier(n.value.property.name));
                    }
                });
                blocks.push(t.expressionStatement(t.assignmentExpression('=', t.memberExpression(t.thisExpression(), t.identifier('data')), node.argument)));
            } else {
                blocks.push(node);
            }
        });
    }

	// 导出computed到组件的this.compute
	const computedProps = Object.keys(state.computeds);
	if (computedProps.length) {
		const objectMethods = [];
		computedProps.forEach(key => {
			const method = state.computeds[key];
			objectMethods.push(method);
			
        });
		const obj = t.objectExpression(objectMethods);
		const compute = t.expressionStatement(t.assignmentExpression('=', t.memberExpression(t.thisExpression(), t.identifier('compute')), obj));
		blocks.push(compute);
    }

    const ctro = t.classMethod(
        'constructor', 
        t.identifier('constructor'), 
        [t.identifier('props')],
        t.blockStatement(blocks)
    );
    nodeLists.push(ctro);
};

exports.genStaticProps = function genStaticProps (path, state) {
    const props = state.props;
    const nodeLists = path.node.body;
    if (Object.keys(props).length) {
        //nodeLists.push(genPropTypes(props)); // Notes 2019/10/17
        //nodeLists.push(genDefaultProps(props)); // Notes 2019/10/17
    }
};

exports.genClassMethods = function genClassMethods (path, collect) {
    const nodeLists = path.node.body;
    const methods = collect.classMethods;
    if (Object.keys(methods).length) {
        Object.keys(methods).forEach(key => {
            nodeLists.push(methods[key]);
        });
    }
};
