/* Copyright 2020 APICloud Inc. All Rights Reserved.

 */

/**
* 格式化代码，可选
* prettier doc: https://prettier.io/docs/en/options.html
*/

const prettier = require('prettier');
const { 
	info, 
	logi, 
	warn, 
	error
} = require('./utils');

function output (code, filepath) {
    const opts = {
		printWidth: 80,
		tabWidth: 1,
		useTabs: true,
		semi: false,
		singleQuote: false,
		trailingComma: "none",
		bracketSpacing: false,
		jsxBracketSameLine: false,
		parser: "babel"
	};
	logi('Prettier JSX[1]      ');

    code = prettier.format(code, opts);

	logi('Prettier JSX[2]      ');
	return code;
}

module.exports = output;
