/* Copyright 2020 APICloud Inc. All Rights Reserved.
 

 */

/**
* CSS to JSON or JSON file
*/
const postcss = require('postcss');
const postcssJs = require('postcss-js');
const fs = require('fs');
//const rollupPluginutils = require('rollup-pluginutils');

function css2Json(source, filename){
	const ast = postcss.parse(source);
	const styleJson = postcssJs.objectify(ast);
	/*
	const indent = '\t';
	const code = rollupPluginutils.dataToEsm(styleJson, {
					indent
				});
	console.log('code:\n' + code);
	*/
	return styleJson;
}

/**/
exports.css2Json = css2Json;

// stml中通过style标签src引入的css，生成同名的json文件，APP中通过增加.json后缀引用
exports.saveAsJson = function saveAsJson(filename){
	if(!fs.existsSync(filename)){
		return;
	}
	const jsonfile = filename + '.json';
	if(fs.existsSync(jsonfile)){
		// return;
	}
	var source = fs.readFileSync(filename);
	source = css2Json(source, filename);
	const data = JSON.stringify(source);
	fs.writeFileSync(jsonfile, data);
}
