/* Copyright 2020 APICloud Inc. All Rights Reserved.
 

 */

/**  
 * 转换SFC中通过 var 或者 function 方式在export default{} 代码块以外地方定义的函数或值，将其挂载到当前Component对象内部或者global下，防止被Rollup优化
 */

function _interopDefault(ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

const babelTraverse = _interopDefault(require('@babel/traverse'));
const babelTemplate = _interopDefault(require('@babel/template'));
const generate = _interopDefault(require('@babel/generator'));
const t = require('@babel/types');

const { 
	log, 
	logi, 
	logast
} = require('./utils');

// 是否位于最外层，而非函数体或对象内部
function isOutermost(p){
	const parent = p.parentPath.parent;
	if (!parent || !t.isFile(parent)) {
		return false;
	}
	return true;
}

exports.collectDeclaration = function collectDeclaration (ast, collect) {
    
	babelTraverse(ast, {
        
		VariableDeclaration (path) {
			if(!isOutermost(path)){
				return;
			}
			const decs = path.node.declarations;
			if(0 === decs.length){
				return;
			}
			if(1 === decs.length){
				const declarator = decs[0];
				const left = t.memberExpression(
				  t.identifier('global'),
				  t.identifier(declarator.id.name)
				);
				//const right = t.objectExpression(declarator.init.properties);
				const code = generate(declarator.init).code;
				const right = babelTemplate.expression.ast(code);
				const assignment = t.assignmentExpression('=', left, right);
				const expression = t.expressionStatement(assignment);
				collect.declarations.unshift(expression);
			}else{
				//处理 var {a, b, c} = {a:'', b:'', c:'', ...} 方式代码 
			}
        },

		FunctionDeclaration (path) {
			if(!isOutermost(path)){
				return;
			}
			const left = t.memberExpression(
			  t.identifier('global'),
			  t.identifier(path.node.id.name)
			);
			const right = t.functionExpression(
				path.node.id,
				path.node.params,
				path.node.body
			);
			const assignment = t.assignmentExpression('=', left, right);
			const expression = t.expressionStatement(assignment);
			collect.declarations.unshift(expression);
		},

		ExpressionStatement (path) {
			if(!isOutermost(path)){
				return;
			}
			const ex = path.node.expression;
			if(t.isAssignmentExpression(ex)){ // 例如：apiready = function(){ }
				if(t.isIdentifier(ex.left)){
					ex.left.name = 'global.' + ex.left.name;
				}else if(t.isMemberExpression(ex.left)){ // 已经是global.xx形式不处理
					
				}
				collect.declarations.unshift(path.node);
			}
			if(t.isCallExpression(ex)){  // 例如：api.addEventListener({ });
				collect.declarations.unshift(path.node);
			}
		}
    });
};