/* Copyright 2020 APICloud Inc. All Rights Reserved.

 */

/**
* 使用Buble代替Babel，对最后生成的ES6及SFC模板，转换为ES5及JSX。Buble支持的ES6及JSX规范比Babel少，但效率比Babel高10倍以上
*
* Buble文档：https://buble.surge.sh/guide/
*
* 如后期有更复杂的功能Buble无法支持，仍可还原回Babel。见build-config.js
*
*/

const buble = require('buble').transform;
const {
	info,
	logi,
	warn,
	error
} = require('./utils');

function transform (code) {
	const opts = {
        target: { chrome: 48, firefox: 44 },
		transforms: {
			arrow: true,
			classes: true,
			computedProperty: true,
			conciseMethodProperty: true,
			defaultParameter: true,
			destructuring: true,
			dangerousForOf: true,
			exponentiation: true,
			generator: true,
			letConst: true,
			modules: false,
			moduleImport: false, // Buble目前暂不支持import，
			numericLiteral: true,
			objectRestSpread: true,
			parameterDestructuring: true,
			spreadRest: true,
			stickyRegExp: true,
			templateString: true,
			unicodeRegExp: true
		},
		jsx:'apivm.h',
		jsxFragment: "apivm.f",
		objectAssign: true, // 'Object.assign'
		namedFunctionExpressions: false  // class.prototype.xxx = function xxx(){} -> class.prototype.xxx = function(){}
    };

	logi('Buble JSX[1]         ');

    code = buble(code, opts).code;

	logi('Buble JSX[2]         ');

	// TODO format
	return code;
}

module.exports = transform;
