/* Copyright 2020 APICloud Inc. All Rights Reserved.

 */

/*
 * rollup插件，统一处理stml文件
 */

'use strict';

const rollupPluginutils = require('rollup-pluginutils');
const vuecompiler = require('vue-template-compiler');
const MagicString = require('magic-string');

const path = require('path');

const {
	extname,
	resolve,
	dirname,
	basename
} = require('path');

const transformCode = require('./src/index');

const { emitStyle,emitAssetFile } = require('../style-to-json/style-emit');
const {error} = require('../tools/client');

/*
* 只处理.stml文件
*/
function createFilter(include = [/\.stml$/i], exclude = []) {
    const filter = rollupPluginutils.createFilter(include, exclude);
    return id => filter(id);
}

/*
* 将代码中require引用转为import
*/
function _transformRequireToImport(code) {
    const imports = {};
    let strImports = '';
    code = code.replace(/require\(("(?:[^"\\]|\\.)+"|'(?:[^'\\]|\\.)+')\)/g, (_, name) => {
        if (!(name in imports)) {
            imports[name] = `__$_require_${name
                .replace(/[^a-z0-9]/g, '_')
                .replace(/_{2,}/g, '_')
                .replace(/^_|_$/g, '')}__`;
            strImports += 'import ' + imports[name] + ' from ' + name + '\n';
        }
        return imports[name];
    });
    return strImports + code;
}

// 使用rollup自带的acorn - ast解析，进行相关处理
function _innerAst(rollup, code, filename) {
    let ast = null;
	try {
		ast = rollup.parse(code);
		console.log('source ast: ' + ast);
	} catch (err) {
		rollup.warn({
			code: 'PARSE_ERROR',
			message: `sfc-to-dsl: failed to parse ${filename}. Consider restricting the plugin to particular files via options.include`
		});
	}
	if (!ast) {
		return null;
	}

	return code;
}


/**
 * Rollup plugin for handling .stml files.
 *
 *  options -> buildStart -> resolveId -> load -> transform -> buildEnd
 *
 */
function SFCCompiler(opts = {include: [/\.stml$/i]}) {

	let i=0
	const isSfc = createFilter(opts.include, opts.exclude);
	let _importer = null;
	const miniapp = 'miniapp' === opts.platform;

    return {

        name: 'sfc-to-dsl',

		options(opts) {

		},

		buildStart(options) {

		},

        resolveId(id, importer) {
			/*if(id.indexof('@') == 0){
				// 支持vue的import card from '@/components/card'方式引入组件
				id = resolve(dirname(importer), id);
			}*/
			if(isSfc(id)){
				_importer = importer;
			}
        },

        load(id) {

        },

        async transform(source, filename) {
									if (!isSfc(filename)) {
										if (miniapp&&filename.indexOf('Babel')===-1&&filename.split('.').pop()!=='json'){
											const parser = require('@babel/parser');
											const babelTraverse = require('@babel/traverse');
											const ast = 	parser.parse(source,{sourceType:'module',plugins:['jsx']})
											babelTraverse.default(ast, {
												enter:path=>{
														if ((path.type === 'ClassMethod' || path.type === 'ClassProperty') && path.node.key.name === 'css') {
															let css, ret
															if (path.type === 'ClassMethod') { // 类的 css 方法看 body
																ret = path.node.body.body.length ? path.node.body.body.pop().argument : false
															} else {// 类的 css 属性看 value
																ret = path.node.value.body
															}
															if (ret) {//如果有返回值
															css =	getCssText(ret)
																function getCssText(ret){
																	let css
																	const { type, name, value } = ret
																	if (type === 'Identifier') {//如果是表达式
																		const ref = path.scope.getBinding(name)
																		if (ref) css = ref.path.node.init.value
																	} else if (type === 'BlockStatement') {
																		ret = ret.body.pop().argument
																	return 	getCssText(ret)
																	} else if (type === 'TemplateLiteral') {// 模板字符串
																		css = getResultFromTemplateLiteral(ret,path)
																	} else {//如果是字符串
																		css = value
																	}
																	return css
																}
																// 可能存在多个 css 块
																css && emitAssetFile(this, `/**-- START --*/\n${css}\n/**-- E-N-D --*/\n`, filename+i++, false)
															}
														}
													}
											});
										}
										return null
									}
			const isSFC = !('.js' === extname(filename));
			const isimport = _importer;
			if(miniapp){
				const res = vuecompiler.parseComponent(source, { pad: 'space' });
				const tmpl = res.template ? res.template.content : '';
				const script = res.script ? res.script.content : '';
				const styles = res.styles ? res.styles : null;
				// 编译小程序平台，样式单独抽出到wxss，js只编译<template>和<script>部分
				source = `<template>${tmpl}</template>\n<script>${script}</script>`;
				emitStyle(this, styles, filename);
			}
			let code;
									try {
										 code = await transformCode(source, filename, isSFC, isimport)
									} catch (e) {
										error(e.message,undefined,{codeFrame:{e,filename}})
									}
			//code = _transformRequireToImport(code);
			//code = _innerAst(this, code, filename);
			writeForDebug(filename, code);
			if(!opts.needMap){
				return { code };
			}
			const s = new MagicString(source);
			s.overwrite(0, source.length, code.toString());
			return {
				code: s.toString(),
				map: s.generateMap({ hires: true })
			};
        },

		buildEnd(error) {

		}
    };
}

module.exports = SFCCompiler;

const debug_flag = false;

//add by moral.li 2019/09/28
function writeForDebug(filename, code){
	if(!debug_flag){
		return;
	}
	filename = filename + '.sfc.js';
	if(typeof code == 'object'){
		code = JSON.stringify(code, null, '\t');
	}
	require('fs').writeFileSync(filename, code);
}


function getResultFromTemplateLiteral(ret,path){


	const {expressions,quasis} = ret;

	// 拼接模板
	let str = ''
	for (let i = 0; i < quasis.length; i++) {
		if (i){
			str+='__'+expressions[i-1].name+'__'
		}
		str+=quasis[i].value.cooked
	}

	// 收集变量引用
	const expMap = new Map()

	for (let i = 0; i < expressions.length; i++) {
		const {name} = expressions[i]

		if (!expMap.has(name)){
			const ref = path.scope.getBinding(name)
			if (ref){
						let { init,init :{type,value}} = ref.path.node
						if (type==='StringLiteral'){
							expMap.set(name,value)
						}else if(type==='TemplateLiteral'){
							expMap.set(name,getResultFromTemplateLiteral(init,path))
						}
			}else{
				expMap.set(name,'')
			}
		}
	}

str =  str.replace(/__(.*?)__/gim,name=>expMap.get(name.replace(/__/g,'')));

	return str
}
