/* Copyright 2020 APICloud Inc. All Rights Reserved.

 */

"use strict";

const build = require('./lib/index-app');				// 编译native app

exports.buildSingle = build.buildSingle;				// 编译单个stml文件为app代码
exports.buildList = build.buildList;					// 编译stml文件列表为app代码
exports.buildFolder = build.buildFolder;				// 编译目录下所有stml为app代码

const buildMp = require('./lib/index-mp');
exports.compileMpSingle = buildMp.compileSingle;		// 编译单个stml文件为小程序代码
exports.compileMpList = buildMp.compileList;			// 编译stml文件列表为小程序代码
exports.compileMpFolder = buildMp.compileFolder;		// 编译符合规范的目录为小程序代码
exports.buildMiniapp = buildMp.compileFolder;			// 编译符合规范的目录为小程序代码

const buildWeb = require('./lib/index-web');
exports.buildWeb = buildWeb.compileFolder;					// 编译符合规范的目录为WEB代码



exports.monitor = require('./lib/tools/client').monitor;		// 监听编译过程
