const path = require('path');
const fs = require('fs');

function getWxAppid(uri) {
	let id = 'touristappid';
	const apicloudDir = path.join(uri, '.yonstudio');
	if (fs.existsSync(apicloudDir)) {
		const projectFile = path.join(apicloudDir, '.project');
		if (fs.existsSync(projectFile)) {
			const fileData = fs.readFileSync(projectFile, { encoding: 'utf-8' });
			if (fileData) {
				const wxid = JSON.parse(fileData).wxappid;
				if (wxid) {
					return wxid;
				} else {
					return id;
				}
			} else {
				return id;
			}
		} else {
			return id;
		}
	} else {
		return id;
	}
}

exports.getWxAppid = getWxAppid;
