const { commands, Uri } = require('vscode');
const fs = require('fs');
const path = require('path');
const os = require('os');

async function addToIgnore(localPath) {
	const ignoredir = findIgnoreDir(localPath);
	if (ignoredir !== '') {
		if (fs.existsSync(path.join(ignoredir, '.svnignore'))) {
			const data = fs.readFileSync(path.join(ignoredir, '.svnignore'), { encoding: 'utf8' });
			if (localPath.includes('out-mp')) {
				if (!data.includes('out-mp')) {
					await commands.executeCommand('svn.addToIgnoreExplorer', Uri.file(localPath), [Uri.file(localPath)]);
					const data = 'out-mp' + os.EOL;
					fs.appendFileSync(path.join(ignoredir, '.svnignore'), data, { encoding: 'utf8' });
				}
			} else if (localPath.includes('.bin')) {
				if (!data.includes('.bin')) {
					await commands.executeCommand('svn.addToIgnoreExplorer', Uri.file(localPath), [Uri.file(localPath)]);
					const data = '.bin' + os.EOL;
					fs.appendFileSync(path.join(ignoredir, '.svnignore'), data, { encoding: 'utf8' });
				}
			}
		} else {
			if (localPath.includes('out-mp')) {
				await commands.executeCommand('svn.addToIgnoreExplorer', Uri.file(localPath), [Uri.file(localPath)]);
				const data = 'out-mp' + os.EOL;
				fs.appendFileSync(path.join(ignoredir, '.svnignore'), data, { encoding: 'utf8' });
			} else if (localPath.includes('.bin')) {
				await commands.executeCommand('svn.addToIgnoreExplorer', Uri.file(localPath), [Uri.file(localPath)]);
				const data = '.bin' + os.EOL;
				fs.appendFileSync(path.join(ignoredir, '.svnignore'), data, { encoding: 'utf8' });

			}
		}
	}
}

function findIgnoreDir(localPath) {
	const dir = path.dirname(localPath);
	let ignoredir = '';
	if (fs.existsSync(path.join(dir, '.svn'))) {
		ignoredir = path.join(dir, '.svn');
	}
	return ignoredir;
}

exports.addToIgnore = addToIgnore;
