/* Copyright 2020 APICloud Inc. All Rights Reserved.
 */

var vscode = require('vscode');
var path = require('path');
var { buildFolder, monitor } = require('../index');
// var { addToIgnore } = require('../common/addToIgnore');
var { getWxAppid } = require('../common/utils');
var os = require('os');
var fs = require('fs');

function compileAll(context) {
	let locale;
	vscode.commands.executeCommand('yonstudio.save.locale').then((value) => {
		locale = value;
	});
	let disposable = vscode.commands.registerCommand('extension.stml.compileall', function (option) {
		let rootFolder = path.join(option.project, 'pages');
		let outFolder = path.join(option.project, '.bin');

		buildFolder(rootFolder, outFolder);

		monitor({
			onConsole: function (msg) {
				vscode.commands.executeCommand('apicloud.showlog', `${msg}`);
			},
			onStart: function () {
				vscode.commands.executeCommand('apicloud.showlog', 'build start');
			},
			onEnd: function (stat) {
				const msg = 'build finish: total-' + stat.total + ', ok-' + stat.ok.length + ', err-' + stat.err.length;
				vscode.commands.executeCommand('apicloud.showlog', msg);
				let message = 'Failed to compile a file. Please check the log for details';
				if (locale === 'zh-Hans') {
					message = '有文件编译失败，具体查看日志';
				} else if (locale === 'zh-Hant') {
					message = '有檔案編譯失敗，具體查看日誌';
				}
				if (stat.err.length > 0) {
					vscode.window.showErrorMessage(message);
					if (option.syncMode === 'yydebug') {
						vscode.commands.executeCommand('show.yydebug.qr', option.pageUrl);
					}
				} else {
					if (os.platform() !== 'darwin') {
						// addToIgnore(outFolder);
					}
					if (option.syncMode) {
						if (option.syncMode === 'usbAll') {
							const syncoption = {
								stmlCompile: true,
								devicename: option.devicename,
								projectPath: option.project,
								fileList: option.fileList
							}

							vscode.commands.executeCommand('apicloud.syncAllUSB', syncoption);
						} else if (option.syncMode === 'all') {
							if (option.appType === 'mx-app') {
								if (fs.existsSync(path.join(option.project, 'pages'))) {
									const opt = {
										uri: option.project,
										mode: 'build',
										wid: getWxAppid(option.project)
									}
									vscode.commands.executeCommand('extension.build.miniapp', opt);
								}
							}
						} else if (option.syncMode === 'wifi-all-sync') {
							let params = {
								projectPath: option.project,
								type: 2,
								wifiIndex: option.wifiIndex ? option.wifiIndex : ''
							}
							vscode.commands.executeCommand('apicloud.extension.syncAllWifi', params);
						} else if (option.syncMode === 'yydebug') {
							vscode.commands.executeCommand('show.yydebug.qr', option.pageUrl);
							option.syncMode = 'none';
						}
					}
				}
			}
		});
	});
	context.subscriptions.push(disposable);
}

exports.compileAll = compileAll;
