/* Copyright 2020 APICloud Inc. All Rights Reserved.
 */

let vscode = require('vscode');
let path = require('path');
let fs = require('fs');
let { buildList, monitor } = require('../index');
// let { addToIgnore } = require('../common/addToIgnore');
let { getPath } = require('../common/projectUtil');

let option;
function compile(context) {
	let locale;
	vscode.commands.executeCommand('yonstudio.save.locale').then((value) => {
		locale = value;
	});
	let disposable = vscode.commands.registerCommand('extension.stml.compile', (opt) => {
		option = opt;
		const fileList = option.fileList;
		const lists = [];
		const projectPath = getProjectPath(option, fileList);
		fileList.forEach(file => {
			if (path.extname(file) === '.stml' && file.replace(/\\/g, '/').indexOf(path.join(projectPath, 'pages').replace(/\\/g, '/')) >= 0) {
				const input = path.join(file).replace(/\\/g, '/');
				let output = path.join(projectPath, '.bin', path.join(input.substring(path.join(projectPath, 'pages').length)).replace('.stml', '.js')).replace(/\\/g, '/');
				const fileListItem = { input, output };
				lists.push(fileListItem);
			}
		});
		buildList(lists);
		monitor({
			onConsole: (msg) => {
				vscode.commands.executeCommand('apicloud.showlog', `${msg}`);
			},
			onStart: () => {
				vscode.commands.executeCommand('apicloud.showlog', 'build start');
			},
			onEnd: (stat) => {
				const msg = 'build finish: total-' + stat.total + ', ok-' + stat.ok.length + ', err-' + stat.err.length;
				vscode.commands.executeCommand('apicloud.showlog', msg);
				let message = 'Failed to compile a file. Please check the log for details';
				if (locale === 'zh-Hans') {
					message = '有文件编译失败，具体查看日志';
				} else if (locale === 'zh-Hant') {
					message = '有檔案編譯失敗，具體查看日誌';
				}
				if (stat.err.length > 0) {
					vscode.window.showErrorMessage(message);
				} else {
					if (option.projectPath) {
						// addToIgnore(path.join(option.projectPath, '.bin'));
					} else if (projectPath) {
						// addToIgnore(path.join(projectPath, '.bin'));
					}
					switch (option.syncMode) {
						case 'wifi-preview':
							let params = {
								file: option.uri,
								appId: option.appid,
								localPath: option.projectPath
							};
							vscode.commands.executeCommand('apicloud.extension.wifipreview', params);// wifi预览
							break;
						case 'live-preview':
							const opt = {
								uri: option.uri,
								quickHandle: option.quickHandle,
								history: option.history
							};
							vscode.commands.executeCommand('workbench.action.live.preview', opt);// 实时预览
							break;
						case 'usb':
							const usbParams = {
								projectPath: option.projectPath,
								devicename: option.devicename,
								fileList: option.fileList
							};
							vscode.commands.executeCommand('apicloud.syncUSB', usbParams);
							break;
						case 'wifi-sync':
							const wifiparams = {
								projectPath: projectPath,
								fileList: option.fileList,
								wifiIndex: option.wifiIndex
							};
							vscode.commands.executeCommand('workbech.apicloud.syncWifi', wifiparams);
							break;
						case 'sync-live-preview':
							const liveparams = {
								projectPath: projectPath,
								fileList: option.fileList,
								type: 3
							};
							vscode.commands.executeCommand('workbench.apicloud.wifi.sync', liveparams); // Wi-Fi同步
							vscode.commands.executeCommand('workbench.action.auto.live.preview', option.fileList[0], false);// 实时预览
							break;
						case 'auto-live-preview':
							vscode.commands.executeCommand('workbench.action.auto.live.preview', option.fileList[0], false);// 实时预览
							break;
						case 'wifi-in-sync':
							// 开始发送同步指令
							const wifiInfo = {
								projectPath: option.projectPath,
								type: 3,
								fileList: option.fileList
							};
							vscode.commands.executeCommand('workbench.apicloud.wifi.sync', wifiInfo);
							break;
						default:
							break;
					}
				}
			}
		});

	});
	context.subscriptions.push(disposable);
}

function getProjectPath(option, fileList) {
	if (option.projectPath) {
		return option.projectPath;
	} else {
		return getPath(fileList[0]);
	}
}


exports.compile = compile;
