let vscode = require('vscode');
let { buildMiniapp, compileMpList, monitor } = require('../index');
let path = require('path');
let cp = require('child_process');
let fs = require('fs');
// let { addToIgnore } = require('../common/addToIgnore');

function compileMiniapp(context) {
	let locale;
	vscode.commands.executeCommand('yonstudio.save.locale').then((value) => {
		locale = value;
	});
	let disposable = vscode.commands.registerCommand('extension.build.miniapp', (option) => {
		if (!fs.existsSync(path.join(option.uri, 'pages'))) {
			return;
		}
		const outFolder = path.join(option.uri, 'out-mp');
		if (!fs.existsSync(outFolder)) {
			fs.mkdirSync(outFolder);
		}
		// addToIgnore(outFolder);
		if (option.mode === 'build' || option.mode === 'build-open') {
			const opts = {
				appid: option.wid
			};
			buildMiniapp(option.uri, outFolder, opts);
		} else if (option.mode === 'debug') {
			// 编译文件
			compileMpList(option.files, outFolder);
		}

		monitor({
			onConsole: function (msg) {
				vscode.commands.executeCommand('apicloud.showlog', `${msg}`);
			},
			onStart: function () {
				let message = 'Start compiling WeChat mini program';
				if (locale === 'zh-Hans') {
					message = '开始编译微信小程序';
				} else if (locale === 'zh-Hant') {
					message = '開始編譯微信小程式';
				}
				vscode.commands.executeCommand('apicloud.showlog', message);
			},
			onEnd: function () {
				let message1 = 'WeChat mini program compilation completed';
				let message2 = 'Opening the Weixin DevTools';
				if (locale === 'zh-Hans') {
					message1 = '微信小程序编译完成';
					message2 = '正在打开微信开发者工具';
				} else if (locale === 'zh-Hant') {
					message1 = '微信小程式編譯完成';
					message2 = '正在打開微信開發者工具';
				}
				if (option.mode === 'build') {
					vscode.commands.executeCommand('apicloud.showlog', message1);
				} else if (option.mode === 'build-open') {
					vscode.commands.executeCommand('apicloud.showlog', message1);
					vscode.commands.executeCommand('apicloud.showlog', message2);

					const cmd = option.clipath;
					if (fs.existsSync(cmd)) {
						const ls = cp.spawn(cmd, ['-o', outFolder]);
						ls.stdout.on('data', (data) => {
							vscode.commands.executeCommand('apicloud.showlog', data.toString());
						});

						ls.stderr.on('data', (data) => {
							vscode.commands.executeCommand('apicloud.showlog', data.toString());
						});
					}
				} else if (option.mode === 'debug') {
					vscode.commands.executeCommand('apicloud.showlog', message1);
				}
			}
		});
	});
	context.subscriptions.push(disposable);
}

exports.compileMiniapp = compileMiniapp;
