'use strict';

var buble$1 = require('buble');
var pluginutils = require('@rollup/pluginutils');

function buble(options = {}) {
    const filter = pluginutils.createFilter(options.include, options.exclude);
    const transformOptions = Object.assign(Object.assign({}, options), { transforms: Object.assign(Object.assign({}, options.transforms), { modules: false }) });
    return {
        name: 'buble',
        transform(code, id) {
            if (!filter(id))
                return null;
            try {
                return buble$1.transform(code, transformOptions);
            }
            catch (e) {
                e.plugin = 'buble';
                if (!e.loc)
                    e.loc = {};
                e.loc.file = id;
                e.frame = e.snippet;
                throw e;
            }
        }
    };
}

module.exports = buble;
