"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const node_1 = require("vscode-languageserver/node");
const vls_1 = require("./services/vls");
const connection = process.argv.length <= 2 ? node_1.createConnection(process.stdin, process.stdout) : node_1.createConnection();
console.log = (...args) => connection.console.log(args.join(' '));
console.error = (...args) => connection.console.error(args.join(' '));
const vls = new vls_1.VLS(connection);
connection.onInitialize(async (params) => {
    await vls.init(params);
    console.log('Stml initialized');
    return {
        capabilities: vls.capabilities
    };
});
vls.listen();
//# sourceMappingURL=vueServerMain.js.map