"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.inferVueVersion = exports.getVueVersionKey = exports.floatVersionToEnum = exports.VueVersion = void 0;
var VueVersion;
(function (VueVersion) {
    VueVersion[VueVersion["VPre25"] = 0] = "VPre25";
    VueVersion[VueVersion["V25"] = 1] = "V25";
    VueVersion[VueVersion["V30"] = 2] = "V30";
})(VueVersion = exports.VueVersion || (exports.VueVersion = {}));
function floatVersionToEnum(v) {
    if (v < 2.5) {
        return VueVersion.VPre25;
    }
    else if (v < 3.0) {
        return VueVersion.V25;
    }
    else {
        return VueVersion.V30;
    }
}
exports.floatVersionToEnum = floatVersionToEnum;
function getVueVersionKey(version) {
    var _a;
    return (_a = Object.keys(VueVersion)) === null || _a === void 0 ? void 0 : _a[Object.values(VueVersion).indexOf(version)];
}
exports.getVueVersionKey = getVueVersionKey;
function inferVueVersion(packagePath) {
    const packageJSONPath = packagePath;
    console.log(packageJSONPath);
    return VueVersion.V25;
    // try {
    //   if (!packageJSONPath) {
    //     throw new Error(`Can't find package.json in project`);
    //   }
    //   const packageJSON = packageJSONPath && JSON.parse(readFileSync(packageJSONPath, { encoding: 'utf-8' }));
    //   const vueDependencyVersion = packageJSON.dependencies.vue || packageJSON.devDependencies.vue;
    //   if (vueDependencyVersion) {
    //     // use a sloppy method to infer version, to reduce dep on semver or so
    //     const vueDep = vueDependencyVersion.match(/\d+\.\d+/)[0];
    //     const sloppyVersion = parseFloat(vueDep);
    //     return floatVersionToEnum(sloppyVersion);
    //   }
    //   const nodeModulesVuePackagePath = require.resolve('vue/package.json', { paths: [packageJSONPath] });
    //   const nodeModulesVuePackageJSON = JSON.parse(readFileSync(nodeModulesVuePackagePath, { encoding: 'utf-8' })!);
    //   const nodeModulesVueVersion = parseFloat(nodeModulesVuePackageJSON.version.match(/\d+\.\d+/)[0]);
    //   return floatVersionToEnum(nodeModulesVueVersion);
    // } catch (e) {
    //   console.error(e.stack);
    //   return VueVersion.VPre25;
    // }
}
exports.inferVueVersion = inferVueVersion;
//# sourceMappingURL=vueVersion.js.map