"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.prettierPluginPugify = exports.prettierTslintify = exports.prettierEslintify = exports.prettierify = void 0;
const vscode_languageserver_types_1 = require("vscode-languageserver-types");
const strings_1 = require("../strings");
const log_1 = require("../../log");
const path = require("path");
const utils_1 = require("../../modes/template/stml-parse/utils");
function prettierify(dependencyService, code, fileFsPath, range, vlsFormatConfig, parser, initialIndent, requirePragma) {
    try {
        const prettier = dependencyService.get('prettier', fileFsPath).module;
        let prettierOptions = getPrettierOptions(dependencyService, prettier, fileFsPath, parser, vlsFormatConfig);
        log_1.logger.logDebug(`Using prettier. Options\n${JSON.stringify(prettierOptions)}`);
        if (parser === 'babel') {
            prettierOptions.printWidth = 120; // 超过最大值换行
            prettierOptions.semi = false; // 是否句尾添加分号
            prettierOptions.singleQuote = false; // 是否使用单引号代替双引号
            prettierOptions.trailingComma = 'es5'; // 是否在对象或数组最后一个元素后面加逗号（在ES5中加尾逗号）
            prettierOptions.bracketSpacing = false; // 是否在对象，数组括号与文字之间加空格 "{ foo: bar }"
            prettierOptions.jsxBracketSameLine = true; // 是否在jsx中把'>'单独放一行
            prettierOptions.jsxSingleQuote = false; // 是否在jsx中使用单引号代替双引号
            prettierOptions.stylelintIntegration = false; // 是否使用stylelint的代码格式进行校验
            prettierOptions.eslintIntegration = false; // 是否使用eslint的代码格式进行校验
            prettierOptions.requirePragma = !!requirePragma;
            //==========================
            // prettierOptions.arrowParens = 'always';
            // prettierOptions.bracketSameLine = true;
            // prettierOptions.bracketSpacing = false;
            // prettierOptions.embeddedLanguageFormatting = 'auto';
            // prettierOptions.htmlWhitespaceSensitivity = 'css';
            // prettierOptions.insertPragma = false;
            // prettierOptions.jsxSingleQuote = false;
            // prettierOptions.printWidth = 120;
            // prettierOptions.proseWrap = 'preserve';
            // prettierOptions.quoteProps = 'as-needed';
            // prettierOptions.requirePragma = false;
            // prettierOptions.semi = false;
            // prettierOptions.singleQuote = false;
            // prettierOptions.tabWidth = 4;
            // prettierOptions.trailingComma = 'es5';
            // prettierOptions.useTabs = false;
            // prettierOptions.vueIndentScriptAndStyle = false;
            // range = Range.create(Position.create(0, 10), Position.create(range.end.line, range.end.character));
        }
        // console.log('code : ' + code)
        let prettierifiedCode = prettier.format(code, prettierOptions);
        if (prettierifiedCode === '' && code.trim() !== '') {
            throw Error('Empty result from prettier');
        }
        if (prettierifiedCode.startsWith(';')) {
            prettierifiedCode = prettierifiedCode.substr(1);
        }
        prettierifiedCode = utils_1.convertBackJSX(prettierifiedCode);
        return [toReplaceTextedit(prettierifiedCode, range, vlsFormatConfig, initialIndent)];
    }
    catch (e) {
        console.log('Prettier format failed');
        console.error(e.stack);
        return [];
    }
}
exports.prettierify = prettierify;
function prettierEslintify() {
    // try {
    //   const prettier = dependencyService.get('prettier', fileFsPath).module;
    //   // const prettierEslint = dependencyService.get('prettier-eslint', fileFsPath).module;
    //   const prettierOptions = getPrettierOptions(dependencyService, prettier, fileFsPath, parser, vlsFormatConfig);
    //   logger.logDebug(`Using prettier-eslint. Options\n${JSON.stringify(prettierOptions)}`);
    //   const prettierifiedCode = prettierEslint({
    //     filePath: fileFsPath,
    //     prettierOptions: { parser },
    //     text: code,
    //     fallbackPrettierOptions: prettierOptions
    //   });
    //   if (prettierifiedCode === '' && code.trim() !== '') {
    //     throw Error('Empty result from prettier');
    //   }
    //   return [toReplaceTextedit(prettierifiedCode, range, vlsFormatConfig, initialIndent)];
    // } catch (e) {
    //   console.log('Prettier-Eslint format failed');
    //   console.error(e.stack);
    //   return [];
    // }
    return [];
}
exports.prettierEslintify = prettierEslintify;
function prettierTslintify(dependencyService, code, fileFsPath, range, vlsFormatConfig, parser, initialIndent) {
    try {
        const prettier = dependencyService.get('prettier', fileFsPath).module;
        const prettierTslint = dependencyService.get('prettier-tslint', fileFsPath).module.format;
        const prettierOptions = getPrettierOptions(dependencyService, prettier, fileFsPath, parser, vlsFormatConfig);
        log_1.logger.logDebug(`Using prettier-tslint. Options\n${JSON.stringify(prettierOptions)}`);
        const prettierifiedCode = prettierTslint({
            prettierOptions: { parser },
            text: code,
            filePath: fileFsPath,
            fallbackPrettierOptions: prettierOptions
        });
        return [toReplaceTextedit(prettierifiedCode, range, vlsFormatConfig, initialIndent)];
    }
    catch (e) {
        console.log('Prettier-Tslint format failed');
        console.error(e.stack);
        return [];
    }
}
exports.prettierTslintify = prettierTslintify;
function prettierPluginPugify(dependencyService, code, fileFsPath, range, vlsFormatConfig, parser, initialIndent) {
    try {
        let prettier = dependencyService.get('prettier', fileFsPath).module;
        if (prettier.version.startsWith('1')) {
            prettier = dependencyService.getBundled('prettier').module;
        }
        const prettierPluginPug = dependencyService.get('@prettier/plugin-pug', fileFsPath).module;
        const prettierOptions = getPrettierOptions(dependencyService, prettier, fileFsPath, parser, vlsFormatConfig);
        prettierOptions.pluginSearchDirs = [];
        prettierOptions.plugins = Array.isArray(prettierOptions.plugins)
            ? [...prettierOptions.plugins, prettierPluginPug]
            : [prettierPluginPug];
        log_1.logger.logDebug(`Using prettier. Options\n${JSON.stringify(prettierOptions)}`);
        const prettierifiedCode = prettier.format(code, prettierOptions);
        return [toReplaceTextedit(prettierifiedCode, range, vlsFormatConfig, initialIndent)];
    }
    catch (e) {
        console.log('Prettier format failed');
        console.error(e.stack);
        return [];
    }
}
exports.prettierPluginPugify = prettierPluginPugify;
function getPrettierOptions(dependencyService, prettierModule, fileFsPath, parser, vlsFormatConfig) {
    const prettierrcOptions = prettierModule.resolveConfig.sync(fileFsPath, { useCache: false });
    if (prettierrcOptions) {
        prettierrcOptions.tabWidth = prettierrcOptions.tabWidth || vlsFormatConfig.options.tabSize;
        prettierrcOptions.useTabs = prettierrcOptions.useTabs || vlsFormatConfig.options.useTabs;
        prettierrcOptions.parser = parser;
        if (dependencyService.useWorkspaceDependencies) {
            // For loading plugins such as @prettier/plugin-pug
            prettierrcOptions.pluginSearchDirs = dependencyService.nodeModulesPaths.map(el => path.dirname(el));
        }
        return prettierrcOptions;
    }
    else {
        const vscodePrettierOptions = vlsFormatConfig.defaultFormatterOptions.prettier || {};
        vscodePrettierOptions.tabWidth = vscodePrettierOptions.tabWidth || vlsFormatConfig.options.tabSize;
        vscodePrettierOptions.useTabs = vscodePrettierOptions.useTabs || vlsFormatConfig.options.useTabs;
        vscodePrettierOptions.parser = parser;
        if (dependencyService.useWorkspaceDependencies) {
            // For loading plugins such as @prettier/plugin-pug
            vscodePrettierOptions.pluginSearchDirs = dependencyService.nodeModulesPaths.map(el => path.dirname(el));
        }
        return vscodePrettierOptions;
    }
}
function toReplaceTextedit(prettierifiedCode, range, vlsFormatConfig, initialIndent) {
    if (initialIndent) {
        // Prettier adds newline at the end
        const formattedCode = '\n' + strings_1.indentSection(prettierifiedCode, vlsFormatConfig);
        return vscode_languageserver_types_1.TextEdit.replace(range, formattedCode);
    }
    else {
        return vscode_languageserver_types_1.TextEdit.replace(range, '\n' + prettierifiedCode);
    }
}
//# sourceMappingURL=index.js.map