"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isVCancellationRequested = exports.VCancellationTokenSource = void 0;
const vscode_languageserver_1 = require("vscode-languageserver");
class VCancellationTokenSource extends vscode_languageserver_1.CancellationTokenSource {
    get token() {
        const token = super.token;
        token.tsToken = {
            isCancellationRequested() {
                return token.isCancellationRequested;
            },
            throwIfCancellationRequested() {
                if (token.isCancellationRequested) {
                    throw new Error('OperationCanceledException');
                }
            }
        };
        return token;
    }
}
exports.VCancellationTokenSource = VCancellationTokenSource;
function isVCancellationRequested(token) {
    return new Promise(resolve => {
        if (!token) {
            resolve(false);
        }
        else {
            setImmediate(() => resolve(token.isCancellationRequested));
        }
    });
}
exports.isVCancellationRequested = isVCancellationRequested;
//# sourceMappingURL=cancellationToken.js.map