"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createEnvironmentService = void 0;
const vueVersion_1 = require("../utils/vueVersion");
function createEnvironmentService(rootPathForConfig, projectPath, tsconfigPath, packagePath, snippetFolder, globalComponentInfos, initialConfig) {
    let $config = initialConfig;
    return {
        configure(config) {
            $config = config;
        },
        getConfig: () => $config,
        getRootPathForConfig: () => rootPathForConfig,
        getProjectRoot: () => projectPath,
        getTsConfigPath: () => tsconfigPath,
        getPackagePath: () => packagePath,
        getVueVersion: () => vueVersion_1.inferVueVersion(packagePath),
        getSnippetFolder: () => snippetFolder,
        getGlobalComponentInfos: () => globalComponentInfos
    };
}
exports.createEnvironmentService = createEnvironmentService;
//# sourceMappingURL=EnvironmentService.js.map