"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getVueMode = void 0;
const snippets_1 = require("./snippets");
const vscode_css_languageservice_1 = require("vscode-css-languageservice");
function getVueMode(env, globalSnippetDir) {
    const snippetManager = new snippets_1.SnippetManager(env.getSnippetFolder(), globalSnippetDir);
    // const scaffoldSnippetSources: ScaffoldSnippetSources = {
    //   workspace: '💼',
    //   user: '🗒️',
    //   vetur: '✌'
    // };
    return {
        getId() {
            return 'vue';
        },
        doComplete(document, position) {
            const scaffoldSnippetSources = env.getConfig().stml.completion.scaffoldSnippetSources;
            // console.log('>>>>>>>>>>>>>>>>>>>>>>>>> scaffoldSnippetSources : ' + JSON.stringify(scaffoldSnippetSources));
            if (scaffoldSnippetSources['workspace'] === '' &&
                scaffoldSnippetSources['user'] === '' &&
                scaffoldSnippetSources['vetur'] === '') {
                return { isIncomplete: false, items: [] };
            }
            const offset = document.offsetAt(position);
            const lines = document.getText().slice(0, offset).split('\n');
            const currentLine = lines[position.line];
            const items = snippetManager ? snippetManager.completeSnippets(scaffoldSnippetSources) : [];
            //console.log('>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> items : ' + JSON.stringify(items));
            // If a line starts with `<`, it's probably a starting region tag that can be wholly replaced
            if (currentLine.length > 0 && currentLine.startsWith('<')) {
                const replacementRange = vscode_css_languageservice_1.Range.create(document.positionAt(offset - currentLine.length), document.positionAt(offset));
                items.forEach(i => {
                    if (i.insertText) {
                        i.textEdit = {
                            newText: i.insertText,
                            range: replacementRange
                        };
                    }
                });
            }
            return {
                isIncomplete: false,
                items
            };
        },
        onDocumentRemoved() { },
        dispose() { }
    };
}
exports.getVueMode = getVueMode;
//# sourceMappingURL=index.js.map