"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getVueTagProvider = void 0;
/* tslint:disable:max-line-length */
const common_1 = require("./common");
function getAttribute(label, type, documentation) {
    const linkedDocumentation = documentation + '\n\n' + `[API Reference](https://docs.apicloud.com/apicloud3/#/basic/directive?index=1&subIndex=4)`;
    return common_1.genAttribute(label, type, linkedDocumentation);
}
const vueDirectives = [
    getAttribute('v-text', undefined, '更新文本标签内容'),
    getAttribute('v-show', undefined, '根据表达式之真假值，切换元素的CSS属性display的值'),
    getAttribute('v-if', undefined, '根据表达式来有条件的渲染原生，在切换时，元素及它的数据绑定、组件被销毁并重建'),
    getAttribute('v-else', 'v', '必须搭配v-if使用，它必须紧跟在v-if或者v-else-if后面，否则不起作用'),
    getAttribute('v-else-if', undefined, 'Denotes the “else if block” for `v-if`. Can be chained.'),
    getAttribute('v-for', undefined, '遍历数组来循环渲染元素'),
    getAttribute('v-on', undefined, '绑定事件'),
    getAttribute('v-bind', undefined, '动态地绑定一个或多个attribute'),
    getAttribute('v-model', undefined, '为 input 和 textarea 等输入类型的标签快速创建数据的双向绑定')
];
const transitionProps = [
    getAttribute('name', undefined, 'Used to automatically generate transition CSS class names. Default: "v"'),
    getAttribute('appear', 'b', 'Whether to apply transition on initial render. Default: false'),
    getAttribute('css', 'b', 'Whether to apply CSS transition classes. Defaults: true. If set to false, will only trigger JavaScript hooks registered via component events.'),
    getAttribute('type', 'transType', 'The event, "transition" or "animation", to determine end timing. Default: the type that has a longer duration.'),
    getAttribute('mode', 'transMode', 'Controls the timing sequence of leaving/entering transitions. Available modes are "out-in" and "in-out"; Defaults to simultaneous.')
].concat([
    'enter-class',
    'leave-class',
    'appear-class',
    'enter-to-class',
    'leave-to-class',
    'appear-to-class',
    'enter-active-class',
    'leave-active-class',
    'appear-active-class'
].map(t => common_1.genAttribute(t)));
function genTag(tag, doc, attributes) {
    return new common_1.HTMLTagSpecification(doc + '\n\n' + `[API Reference](https://vuejs.org/v2/api/#${tag})`, attributes);
}
const vueTags = {
    component: genTag('component', 'A meta component for rendering dynamic components. The actual component to render is determined by the `is` prop.', [
        common_1.genAttribute('is', undefined, 'the actual component to render'),
        common_1.genAttribute('inline-template', 'v', 'treat inner content as its template rather than distributed content')
    ]),
    transition: genTag('transition', '<transition> serves as transition effects for single element/component. It applies the transition behavior to the wrapped content inside.', transitionProps),
    'transition-group': genTag('transition-group', 'transition group serves as transition effects for multiple elements/components. It renders a <span> by default and can render user specified element via `tag` attribute.', transitionProps.concat(common_1.genAttribute('tag'), common_1.genAttribute('move-class'))),
    'keep-alive': genTag('keep-alive', 'When wrapped around a dynamic component, <keep-alive> caches the inactive component instances without destroying them.', ['include', 'exclude'].map(t => common_1.genAttribute(t))),
    slot: genTag('slot', '<slot> serve as content distribution outlets in component templates. <slot> itself will be replaced.', [common_1.genAttribute('name', undefined, 'Used for named slot')]),
    template: new common_1.HTMLTagSpecification('The template element is used to declare fragments of HTML that can be cloned and inserted in the document by script.', [
        common_1.genAttribute('scope', undefined, '(deprecated) a temporary variable that holds the props object passed from the child'),
        common_1.genAttribute('slot', undefined, 'the name of scoped slot')
    ])
};
const valueSets = {
    transMode: ['out-in', 'in-out'],
    transType: ['transition', 'animation'],
    b: ['true', 'false']
};
function getVueTagProvider() {
    return {
        getId: () => 'vue',
        priority: common_1.Priority.Framework,
        collectTags: collector => common_1.collectTagsDefault(collector, vueTags),
        collectAttributes: (tag, collector) => {
            common_1.collectAttributesDefault(tag, collector, vueTags, vueDirectives);
        },
        collectValues: (tag, attribute, collector) => {
            common_1.collectValuesDefault(tag, attribute, collector, vueTags, vueDirectives, valueSets);
        }
    };
}
exports.getVueTagProvider = getVueTagProvider;
//# sourceMappingURL=vueTags.js.map