"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNuxtTagProvider = void 0;
const path_1 = require("path");
const externalTagProviders_1 = require("./externalTagProviders");
const NUXT_JSON_SOURCES = ['@nuxt/vue-app-edge', '@nuxt/vue-app', 'nuxt-helper-json'];
function getNuxtTagProvider(packageRoot) {
    let nuxtTags, nuxtAttributes;
    for (const source of NUXT_JSON_SOURCES) {
        if (tryResolve(path_1.join(source, 'package.json'), packageRoot)) {
            nuxtTags = tryRequire(path_1.join(source, 'vetur/nuxt-tags.json'), packageRoot);
            nuxtAttributes = tryRequire(path_1.join(source, 'vetur/nuxt-attributes.json'), packageRoot);
            if (nuxtTags) {
                break;
            }
        }
    }
    const componentsTags = tryRequire(path_1.join(packageRoot, '.nuxt/vetur/tags.json'), packageRoot);
    const componentsAttributes = tryRequire(path_1.join(packageRoot, '.nuxt/vetur/attributes.json'), packageRoot);
    return externalTagProviders_1.getExternalTagProvider('nuxt', { ...nuxtTags, ...componentsTags }, { ...nuxtAttributes, ...componentsAttributes });
}
exports.getNuxtTagProvider = getNuxtTagProvider;
function tryRequire(modulePath, findPath) {
    try {
        const resolved = tryResolve(modulePath, findPath);
        return resolved ? require(resolved) : undefined;
    }
    catch (_err) { }
}
function tryResolve(modulePath, findPath) {
    try {
        return require.resolve(modulePath, {
            paths: [findPath, __dirname]
        });
    }
    catch (_err) { }
    return undefined;
}
//# sourceMappingURL=nuxtTags.js.map