"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getExternalTagProvider = exports.getDependencyTagProvider = exports.getWorkspaceTagProvider = exports.gridsomeTagProvider = exports.bootstrapTagProvider = exports.onsenTagProvider = exports.elementTagProvider = void 0;
const fs = require("fs");
const path = require("path");
const lodash_1 = require("lodash");
const common_1 = require("./common");
// import elementTags from 'element-helper-json/element-tags.json';
const elementTags = require('element-helper-json/element-tags.json');
// import elementAttributes from 'element-helper-json/element-attributes.json';
const elementAttributes = require('element-helper-json/element-attributes.json');
// import onsenTags from 'vue-onsenui-helper-json/vue-onsenui-tags.json';
const onsenTags = require('vue-onsenui-helper-json/vue-onsenui-tags.json');
// import onsenAttributes from 'vue-onsenui-helper-json/vue-onsenui-attributes.json';
const onsenAttributes = require('vue-onsenui-helper-json/vue-onsenui-attributes.json');
// import bootstrapTags from 'bootstrap-vue-helper-json/tags.json';
const bootstrapTags = require('bootstrap-vue-helper-json/tags.json');
// import bootstrapAttributes from 'bootstrap-vue-helper-json/attributes.json';
const bootstrapAttributes = require('bootstrap-vue-helper-json/attributes.json');
// import gridsomeTags from 'gridsome-helper-json/gridsome-tags.json';
const gridsomeTags = require('gridsome-helper-json/gridsome-tags.json');
// import gridsomeAttributes from 'gridsome-helper-json/gridsome-attributes.json';
const gridsomeAttributes = require('gridsome-helper-json/gridsome-attributes.json');
const workspace_1 = require("../../../utils/workspace");
exports.elementTagProvider = getExternalTagProvider('element', elementTags, elementAttributes);
exports.onsenTagProvider = getExternalTagProvider('onsen', onsenTags, onsenAttributes);
exports.bootstrapTagProvider = getExternalTagProvider('bootstrap', bootstrapTags, bootstrapAttributes);
exports.gridsomeTagProvider = getExternalTagProvider('gridsome', gridsomeTags, gridsomeAttributes);
/**
 * Get tag providers specified in workspace root's packaage.json
 */
function getWorkspaceTagProvider(packageRoot, rootPkgJson) {
    if (!rootPkgJson.vetur) {
        return null;
    }
    const tagsPath = workspace_1.findConfigFile(packageRoot, rootPkgJson.vetur.tags);
    const attrsPath = workspace_1.findConfigFile(packageRoot, rootPkgJson.vetur.attributes);
    try {
        if (tagsPath && attrsPath) {
            const tagsJson = JSON.parse(fs.readFileSync(tagsPath, 'utf-8'));
            const attrsJson = JSON.parse(fs.readFileSync(attrsPath, 'utf-8'));
            return getExternalTagProvider('__vetur-workspace', tagsJson, attrsJson);
        }
        return null;
    }
    catch (err) {
        console.error(err.stack);
        return null;
    }
}
exports.getWorkspaceTagProvider = getWorkspaceTagProvider;
/**
 * Get tag providers specified in packaage.json's `vetur` key
 */
function getDependencyTagProvider(packageRoot, depPkgJson) {
    if (!depPkgJson.vetur) {
        return null;
    }
    try {
        const tagsPath = require.resolve(path.join(depPkgJson.name, depPkgJson.vetur.tags), { paths: [packageRoot] });
        const attrsPath = require.resolve(path.join(depPkgJson.name, depPkgJson.vetur.attributes), {
            paths: [packageRoot]
        });
        const tagsJson = JSON.parse(fs.readFileSync(tagsPath, 'utf-8'));
        const attrsJson = JSON.parse(fs.readFileSync(attrsPath, 'utf-8'));
        return getExternalTagProvider(depPkgJson.name, tagsJson, attrsJson);
    }
    catch (err) {
        console.error(err.stack);
        return null;
    }
}
exports.getDependencyTagProvider = getDependencyTagProvider;
function getExternalTagProvider(id, tags, attributes) {
    function findAttributeDetail(tag, attr) {
        return (attributes[attr] ||
            attributes[`${tag}/${attr}`] ||
            attributes[`${tag.toLowerCase}/${attr}`] ||
            attributes[`${lodash_1.kebabCase(tag)}/${attr}`]);
    }
    return {
        getId: () => id,
        priority: common_1.Priority.Library,
        collectTags(collector) {
            for (const tagName in tags) {
                collector(tagName, tags[tagName].description || '');
            }
        },
        collectAttributes(tag, collector) {
            var _a;
            const attrs = (_a = common_1.getSameTagInSet(tags, tag)) === null || _a === void 0 ? void 0 : _a.attributes;
            if (!attrs) {
                return;
            }
            for (const attr of attrs) {
                const detail = findAttributeDetail(tag, attr);
                if ((detail === null || detail === void 0 ? void 0 : detail.type) === 'boolean') {
                    collector(attr, 'v', (detail && detail.description) || '');
                }
                else if ((detail === null || detail === void 0 ? void 0 : detail.type) === 'event') {
                    collector(attr, 'event', (detail && detail.description) || '');
                }
                else {
                    collector(attr, undefined, (detail && detail.description) || '');
                }
            }
        },
        collectValues(tag, attr, collector) {
            var _a;
            const attrs = (_a = common_1.getSameTagInSet(tags, tag)) === null || _a === void 0 ? void 0 : _a.attributes;
            if (!attrs || attrs.indexOf(attr) < 0) {
                return;
            }
            const detail = findAttributeDetail(tag, attr);
            if (!detail || !detail.options) {
                return;
            }
            for (const option of detail.options) {
                collector(option);
            }
        }
    };
}
exports.getExternalTagProvider = getExternalTagProvider;
//# sourceMappingURL=externalTagProviders.js.map