"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.convertBackJSX = exports.convertJSX = void 0;
const jsxType = require('@babel/types');
const jsxParser = require('@babel/parser');
const SelfClosingTags = ['input', 'textarea', 'img', 'image'];
function transformTagClosed(code) {
    if (!code)
        return '';
    var closed = function (tag, str) {
        var t = `</${tag}>`;
        return str.endsWith('>') && (str.endsWith(t) || str.endsWith('/>'));
    };
    let tagReg;
    SelfClosingTags.forEach(key => {
        tagReg = new RegExp("<" + key + "([\\s\\S]*?).*>(?=[^>]*?<)", 'gim');
        code = code.replace(tagReg, (matchstr) => {
            if (matchstr && !closed(key, matchstr)) {
                return matchstr.slice(0, matchstr.length - 1) + '/>';
            }
            return matchstr;
        });
    });
    return code;
}
function convertJSX(code) {
    let res = transformTagClosed(code)
        // 处理注释
        .replace(/<\!--/g, '{/*<!--').replace(/-->/g, '-->*/}')
        // 处理 : 进行数据绑定
        .replace(/(?<=\s):\S+=/g, (str) => {
        return `$__v-bind` + str;
    })
        // 处理 @ 进行事件绑定
        .replace(/(?<=\s)@\S+=/g, (str) => {
        return '$__v-on:' + str.substr(1);
    })
        // 处理三个大括号情形
        .replace(/\{\s*\{\s*\{([\s\S]*?)\}\s*\}\s*\}/g, (str) => {
        return str.replace(/\{\s*\{\s*\{/g, '{/*{*/{').replace(/\}\s*\}\s*\}/g, '}/*}*/}');
    })
        // 处理两个大括号情形
        .replace(/\{\s*\{([\s\S]*?)\}\s*\}(?!\s*\})/g, (str) => {
        let substr = str.replace(/\{\s*\{/g, '').replace(/\}\s*\}(?!\s*\})/g, '');
        try {
            let root = jsxParser.parse(substr, { sourceType: 'module' });
            let ast = root.program.body[0];
            if (jsxType.isExpressionStatement(ast)) {
                // 类似 {{a+b}}
                return str.replace(/\{\s*\{/g, '{/*{*/').replace(/\}\s*\}(?!\s*\})/g, '/*}*/}');
            }
            else if (jsxType.isLabeledStatement(ast)) {
                // 类似 {{a:b}}
                return str;
            }
            return str;
        }
        catch (error) {
            // 报错也许是 {{a:b,c:d}} 情形，可以处理成对象
            return str;
        }
    });
    return res;
}
exports.convertJSX = convertJSX;
// function convertJSXComment(code: string) {
// 	return code.replace(/<\!--/g, '{/*<!--').replace(/-->/g, '-->*/}');
// }
function convertBackJSX(code) {
    // 替换回注释
    let res = code.replace(/\{\s*?\/\*<\!--/g, '<!--').replace(/-->\*\/\s*?}/g, '-->')
        // $__v-bind: 替换回 :
        .replace(/\$__v-bind:/g, ':')
        // $__v-on: 替换回 @
        .replace(/\$__v-on:/g, '@')
        // 替换回大括号
        .replace(/\/\*\{\*\//g, '{').replace(/\/\*\}\*\//g, '}');
    return res;
}
exports.convertBackJSX = convertBackJSX;
//# sourceMappingURL=utils.js.map