"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createLintEngine = exports.doESLintValidation = void 0;
const eslint_1 = require("eslint");
const eslint_plugin_vue_1 = require("eslint-plugin-vue");
const react = require("eslint-plugin-react");
const vscode_languageserver_types_1 = require("vscode-languageserver-types");
// eslint-plugin-vue
function toDiagnostic(error) {
    const line = error.line - 1;
    const column = error.column - 1;
    const endLine = error.endLine ? error.endLine - 1 : line;
    const endColumn = error.endColumn ? error.endColumn - 1 : column;
    return {
        range: vscode_languageserver_types_1.Range.create(line, column, endLine, endColumn),
        message: `[${error.ruleId}]\n${error.message}`,
        source: 'stml',
        severity: error.severity === 1 ? vscode_languageserver_types_1.DiagnosticSeverity.Warning : vscode_languageserver_types_1.DiagnosticSeverity.Error
    };
}
async function doESLintValidation(document, engine) {
    const rawText = document.getText();
    // skip checking on empty template
    if (rawText.replace(/\s/g, '') === '') {
        return [];
    }
    const text = rawText.replace(/ {10}/, '<template>') + '</template>';
    const report = engine.executeOnText(text, document.uri);
    // return report?.[0].messages.map(toDiagnostic) ?? [];
    return report.results[0] ? report.results[0].messages.map(toDiagnostic) : [];
}
exports.doESLintValidation = doESLintValidation;
function createLintEngine(_vueVersion) {
    // const SERVER_ROOT = __dirname;
    // configs.essential
    // const versionSpecificConfig = vueVersion === VueVersion.V30 ? configs['vue3-essential'] : configs.essential;
    // return new ESLint({
    //   useEslintrc: false,
    //   cwd: SERVER_ROOT,
    //   baseConfig: configs.base,
    //   overrideConfig: configs['vue3-essential']
    // });
    const option = {
        useEslintrc: false,
        ...eslint_plugin_vue_1.configs.base,
        ...eslint_plugin_vue_1.configs.essential,
        ...react,
    };
    option['rules']['vue/no-multiple-template-root'] = "error";
    return new eslint_1.CLIEngine(option);
    // return new CLIEngine({
    //   useEslintrc: false,
    //   ...configs.base,
    //   ...configs.essential,
    //   ...react,
    // });
}
exports.createLintEngine = createLintEngine;
//# sourceMappingURL=htmlEslintValidation.js.map