"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VueHTMLMode = void 0;
const languageModelCache_1 = require("../../embeddedSupport/languageModelCache");
const htmlMode_1 = require("./htmlMode");
const interpolationMode_1 = require("./interpolationMode");
const htmlParser_1 = require("./parser/htmlParser");
class VueHTMLMode {
    constructor(tsModule, serviceHost, env, documentRegions, autoImportSfcPlugin, dependencyService, vueInfoService) {
        const vueDocuments = languageModelCache_1.getLanguageModelCache(10, 60, document => htmlParser_1.parseHTMLDocument(document));
        this.htmlMode = new htmlMode_1.HTMLMode(documentRegions, env, dependencyService, vueDocuments, autoImportSfcPlugin, vueInfoService);
        this.vueInterpolationMode = new interpolationMode_1.VueInterpolationMode(tsModule, serviceHost, env, vueDocuments, vueInfoService);
        this.autoImportSfcPlugin = autoImportSfcPlugin;
    }
    getId() {
        return 'vue-html';
    }
    queryVirtualFileInfo(fileName, currFileText) {
        return this.vueInterpolationMode.queryVirtualFileInfo(fileName, currFileText);
    }
    async doValidation(document, cancellationToken) {
        return Promise.all([
            this.vueInterpolationMode.doValidation(document, cancellationToken),
            this.htmlMode.doValidation(document, cancellationToken)
        ]).then(result => [...result[0], ...result[1]]);
    }
    doComplete(document, position) {
        const htmlList = this.htmlMode.doComplete(document, position);
        const intList = this.vueInterpolationMode.doComplete(document, position);
        return {
            isIncomplete: htmlList.isIncomplete || intList.isIncomplete,
            items: htmlList.items.concat(intList.items)
        };
    }
    doResolve(document, item) {
        if (this.autoImportSfcPlugin.isMyResolve(item)) {
            return this.autoImportSfcPlugin.doResolve(document, item);
        }
        return this.vueInterpolationMode.doResolve(document, item);
    }
    doHover(document, position) {
        const interpolationHover = this.vueInterpolationMode.doHover(document, position);
        return interpolationHover.contents.length !== 0 ? interpolationHover : this.htmlMode.doHover(document, position);
    }
    findDocumentHighlight(document, position) {
        return this.htmlMode.findDocumentHighlight(document, position);
    }
    findDocumentLinks(document, documentContext) {
        return this.htmlMode.findDocumentLinks(document, documentContext);
    }
    findDocumentSymbols(document) {
        return this.htmlMode.findDocumentSymbols(document);
    }
    format(document, range, formattingOptions) {
        return this.htmlMode.format(document, range, formattingOptions);
    }
    findReferences(document, position) {
        return this.vueInterpolationMode.findReferences(document, position);
    }
    findDefinition(document, position) {
        const htmlDefinition = this.htmlMode.findDefinition(document, position);
        return htmlDefinition.length > 0 ? htmlDefinition : this.vueInterpolationMode.findDefinition(document, position);
    }
    getFoldingRanges(document) {
        return this.htmlMode.getFoldingRanges(document);
    }
    onDocumentRemoved(document) {
        this.htmlMode.onDocumentRemoved(document);
    }
    dispose() {
        this.htmlMode.dispose();
    }
}
exports.VueHTMLMode = VueHTMLMode;
//# sourceMappingURL=index.js.map