"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SassLanguageMode = void 0;
const vscode_css_languageservice_1 = require("vscode-css-languageservice");
const sass_formatter_1 = require("sass-formatter");
const emmet = require("vscode-emmet-helper");
const emmet_1 = require("../emmet");
class SassLanguageMode {
    constructor(env) {
        this.env = env;
    }
    getId() {
        return 'sass';
    }
    doComplete(document, position) {
        const emmetCompletions = emmet.doComplete(document, position, 'sass', this.env.getConfig().emmet);
        if (!emmetCompletions) {
            return { isIncomplete: false, items: [] };
        }
        else {
            const emmetItems = emmetCompletions.items.map(i => {
                return {
                    ...i,
                    sortText: emmet_1.Priority.Emmet + i.label
                };
            });
            return {
                isIncomplete: emmetCompletions.isIncomplete,
                items: emmetItems
            };
        }
    }
    format(document, range, formattingOptions) {
        if (this.env.getConfig().stml.format.defaultFormatter.sass === 'sass-formatter') {
            return [
                vscode_css_languageservice_1.TextEdit.replace(range, sass_formatter_1.SassFormatter.Format(document.getText(range), { ...formattingOptions, ...this.env.getConfig().sass.format }))
            ];
        }
        return [];
    }
    onDocumentRemoved(_document) { }
    dispose() { }
}
exports.SassLanguageMode = SassLanguageMode;
//# sourceMappingURL=sassLanguageMode.js.map