"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getGlobalComponents = void 0;
const lodash_1 = require("lodash");
const componentInfo_1 = require("./componentInfo");
function getGlobalComponents(tsModule, service, componentInfos, tagCasing = 'kebab') {
    const program = service.getProgram();
    if (!program) {
        return [];
    }
    const checker = program.getTypeChecker();
    const result = [];
    componentInfos.forEach(info => {
        const sourceFile = program.getSourceFile(info.path);
        if (!sourceFile) {
            return;
        }
        const defaultExportNode = componentInfo_1.getDefaultExportNode(tsModule, sourceFile);
        if (!defaultExportNode) {
            return;
        }
        const defaultExportSymbol = checker.getTypeAtLocation(defaultExportNode);
        if (!defaultExportSymbol) {
            return;
        }
        const name = tagCasing === 'kebab' ? lodash_1.kebabCase(info.name) : info.name;
        result.push({
            name,
            documentation: componentInfo_1.buildDocumentation(defaultExportSymbol.symbol, checker),
            definition: {
                path: sourceFile.fileName,
                start: defaultExportNode.getStart(sourceFile, true),
                end: defaultExportNode.getEnd()
            },
            defaultExportNode
        });
    });
    return result;
}
exports.getGlobalComponents = getGlobalComponents;
//# sourceMappingURL=globalComponents.js.map