"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPugMode = void 0;
const vscode_languageserver_types_1 = require("vscode-languageserver-types");
const prettier_1 = require("../../utils/prettier");
const paths_1 = require("../../utils/paths");
function getPugMode(env, dependencyService) {
    return {
        getId() {
            return 'pug';
        },
        format(document, currRange) {
            if (env.getConfig().stml.format.defaultFormatter['pug'] === 'none') {
                return [];
            }
            const { value, range } = getValueAndRange(document, currRange);
            return prettier_1.prettierPluginPugify(dependencyService, value, paths_1.getFileFsPath(document.uri), range, env.getConfig().stml.format, 
            // @ts-expect-error
            'pug', false);
        },
        onDocumentRemoved() { },
        dispose() { }
    };
}
exports.getPugMode = getPugMode;
function getValueAndRange(document, currRange) {
    let value = document.getText();
    let range = currRange;
    if (currRange) {
        const startOffset = document.offsetAt(currRange.start);
        const endOffset = document.offsetAt(currRange.end);
        value = value.substring(startOffset, endOffset);
    }
    else {
        range = vscode_languageserver_types_1.Range.create(vscode_languageserver_types_1.Position.create(0, 0), document.positionAt(value.length));
    }
    return { value, range };
}
//# sourceMappingURL=index.js.map